<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Usergallery;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use Validator;
use Image;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\DB;
use Imagick;
use File;
use GuzzleHttp\Client;

class UsergalleryController extends Controller
{
    public function resize_crop_image($max_width, $source_file, $dst_dir ){
        $imgsize = getimagesize($source_file);         
        $width = $imgsize[0];
        $height = $imgsize[1];
        $mime = $imgsize['mime'];
    
        switch($mime){
            case 'image/gif':
                $image_create = "imagecreatefromgif";
                $image = "imagegif";
                break;
    
            case 'image/png':
                $image_create = "imagecreatefrompng";
                $image = "imagepng";
                $quality = 7;
                break;
    
            case 'image/jpeg':
                $image_create = "imagecreatefromjpeg";
                $image = "imagejpeg";
                $quality = 80;
                break;
    
            default:
                return false;
                break;
        }
        $new_height = abs($max_width * $height / $width);
        $dst_img = imagecreatetruecolor($max_width, $new_height);
        $src_img = @$image_create($source_file);
                
        imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $max_width, $new_height, $width, $height);
    
        /* $width_new = $height * $max_width / $max_height;
        $height_new = $width * $max_height / $max_width; */
        //if the new width is greater than the actual width of the image, then the height is too large and the rest cut off, or vice versa
/*         if($width_new > $width){
            $h_point = (($height - $height_new) / 2);
            imagecopyresampled($dst_img, $src_img, 0, 0, 0, $h_point, $max_width, $max_height, $width, $height_new);
        }else{
            $w_point = (($width - $width_new) / 2);
            imagecopyresampled($dst_img, $src_img, 0, 0, $w_point, 0, $max_width, $max_height, $width_new, $height);
        } */



        $image($dst_img, $dst_dir, $quality);
    
        if($dst_img)imagedestroy($dst_img);
        if($src_img)imagedestroy($src_img);
    }


  

    public function filename($file)
    {
        return pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
    }

    public function UsergalleryImage(Request $request)
    {

        $data = $request->all();
        $validator = Validator::make($data, [
            'userId' => 'required',
            'userName' => 'required',
            'email' => 'required',
            'userRole' => 'required',
            'file' => 'required',
            'fileName' => 'required',
            'fileExtension' => 'required',
            'size' => 'required',
            'type' => 'required',
            'date' => 'required',
            'fileobject' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors(), 'Validation Error']);
        } else {
            
            $folder = '/gallery'; 
            
            $originalName = $this->filename($request->fileName);
            $originalName = preg_replace('/\W+/', '-', $originalName);
            $newName = $originalName . "_" . intval(microtime(true));
            $extension = $request->fileName->getClientOriginalExtension();
            
            $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->fileName, $newName . '.' . $extension, 'public');
            $fileNamenew = env('AWS_URL') . $uploadPath; 
 
            if( $extension === 'jpg' || $extension === 'jpeg' ||   $extension === 'png' || $extension === 'gif' ){
                $thumb_tmp_path="../storage/tmp/". $newName . '.' . $extension;
                $this->resize_crop_image(300,   $request->fileName, $thumb_tmp_path);
                $uploadThumbnailPath = \Storage::disk('s3')->putFileAs($folder .'/thumbnail', $thumb_tmp_path, $newName . '.' . $extension, 'public');
                $fileNamenew = env('AWS_URL') . $uploadThumbnailPath; 
                unlink($thumb_tmp_path);
            }

            $userId = $request->userId;
            $userName = $request->userName;
            $email = $request->email;
            $userRole = $request->userRole;
            $fileExtension = $request->fileExtension;
            $size = $request->size;
            $type = $request->type;
            $date = $request->date;
            $file = $request->file;
            $fileobject = $request->fileobject;

            $insertdata = array('fileName' => $fileNamenew, "userId" => $userId, "userName" => $userName, "email" => $email, "userRole" => $userRole, "fileExtension" => $fileExtension, "size" => $size, "type" => $type, "date" => $date, "file" => $file, "fileobject" => $fileobject);
            DB::table('usergallery')->insert($insertdata);

            return response([
                'code' => 200,
                'success' => true,
                'message' => 'File Uploaded Successfully',
                'data' => $insertdata
            ]);
        }
    }

    //Worked For save chat contents to gallery
    public function saveChatImageToGallery(Request $request)
    {
        

        $data = $request->all();
        $validator = Validator::make($data, [
            'userId' => 'required',
            'userName' => 'required',
            'email' => 'required',
            'userRole' => 'required',
            'file' => 'required',
            'fileName' => 'required',
            'fileExtension' => 'required',
            'fileobject' => 'required',
            'size' => 'required',
            'type' => 'required',
            'date' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors(), 'Validation Error']);
        } else {

            $folder = '/gallery';
            $originalName = $this->filename($request->fileName);
            $originalName = preg_replace('/\W+/', '-', $originalName);
            $newName = $originalName . "_" . intval(microtime(true));
            $extension = $request->fileExtension;
            // $request->fileName->getClientOriginalExtension();
            $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->fileName, $newName . '.' . $extension, 'public');
            $fileNamenew = env('AWS_URL') . $uploadPath;

            if( $extension === 'jpg' || $extension === 'jpeg' ||   $extension === 'png' || $extension === 'gif' ){
                $thumb_tmp_path="../storage/tmp/". $newName . '.' . $extension;
                $this->resize_crop_image(300,   $request->fileName, $thumb_tmp_path);
                $uploadThumbnailPath = \Storage::disk('s3')->putFileAs($folder .'/thumbnail', $thumb_tmp_path, $newName . '.' . $extension, 'public');
                $fileNamenew = env('AWS_URL') . $uploadThumbnailPath; 
                unlink($thumb_tmp_path);
            }

            $userId = $request->userId;
            $userName = $request->userName;
            $email = $request->email;
            $userRole = $request->userRole;
            $fileExtension = $request->fileExtension;
            $size = $request->size;
            $type = $request->type;
            $date = $request->date;
            $file = $fileNamenew;
            $fileobject = $request->fileobject;

            $insertdata = array('fileName' => $fileNamenew, "userId" => $userId, "userName" => $userName, "email" => $email, "userRole" => $userRole, "fileExtension" => $fileExtension, "size" => $size, "type" => $type, "date" => $date, "file" => $file, 'fileobject' => $fileobject);
              
            DB::table('usergallery')->insert($insertdata);

            return response([
                'code' => 200,
                'success' => true,
                'message' => 'File Uploaded Successfully',
                'data' => $insertdata
            ]);
        }
    }
    //Worked For save chat contents to gallery


    public function GetUsergalleryImage(Request $request)
    {
        $userId = $request->userId;
        $userRole = $request->userRole;
        if ($userRole == 'admin') {
            $users = DB::table('usergallery')->orderBy('id', 'desc')->get();
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Data Get Successfully',
                'data' => $users
            ]);
        } elseif ($userRole != 'admin') {
            $users = DB::table('usergallery')
                ->WHERE('userRole', $userRole)
                ->WHERE('userId', $userId)
                ->orderBy('id', 'desc')
                ->get();
            if ($users == '[]') {
                return response([
                    'code' => 404,
                    'success' => false,
                    'message' => 'Data Not Found',
                    'data' => $users
                ]);
            } else {
                return response([
                    'code' => 200,
                    'success' => true,
                    'message' => 'Data Get Successfully',
                    'data' => $users
                ]);
            }
        } else {
            return response([
                'code' => 404,
                'success' => false,
                'message' => 'Data Not Found'

            ]);
        }
    }
    public function UsergallerydeleteImage(Request $request)
    {
        $id = $request->id;

        $users = DB::delete('delete from usergallery where id = ?', [$id]);

        return response([
            'code' => 200,
            'success' => true,
            'message' => 'Data Deleted Successfully',
            'data' => $users
        ]);
    }


    /* Test - Start */
    protected $client;

    public function __construct(Client $client)
    {
        $this->client = $client;

    }

    
    public function saveEmailImageToGallery(Request $request)
    { 
 
            
            $AWS_URL =  env('AWS_URL');
            $data = $request->all();
            $validator = Validator::make($data, [
                'userId' => 'required',
                'userName' => 'required',
                'email' => 'required',
                'userRole' => 'required',
                'file' => 'required',
                'fileName' => 'required',
                'fileExtension' => 'required',
                'size' => 'required',
                'type' => 'required',
                'date' => 'required'
            ]);
            if ($validator->fails()) {
                return response()->json(['error' => $validator->errors(), 'Validation Error']);
            } else {
                 
                $url = "https://api.nylas.com/files/". $request->downloadId ."/download"; 


                $headers = [
                    'Authorization' => 'Bearer ' . $request->token,
                ];
                $binary =  $this->client->request('GET', $url, [
                    'headers' => $headers 
                ])->getBody()->getContents();
                
                
                /* $originalName = $this->filename($request->fileName); */
                /* $originalName = preg_replace('/\W+/', '-', $originalName); */
                $newName = intval(microtime(true)) .'_'. $request->fileName;
                $extension = pathinfo($request->fileName, PATHINFO_EXTENSION);
                $fileName = "/email-images/". $newName;
                $uploadPath =  Storage::disk("s3")->put($fileName , $binary); 
                $fileNamenew = $AWS_URL . $fileName; 
     
                if( $extension === 'jpg' || $extension === 'jpeg' ||   $extension === 'png' || $extension === 'gif' ){
                    $thumb_tmp_path = "../storage/tmp/". $newName;
                    $this->resize_crop_image(150,   "data:".$request->type.";base64,".base64_encode($binary), $thumb_tmp_path);
                    $thumbnailFileName = "/email-images/thumbnail/". $newName . '.' . $extension;
                    $uploadThumbnailPath = \Storage::disk('s3')->putFileAs( '/email-images/thumbnail', $thumb_tmp_path, $newName , 'public');
                                       
                    $fileNamenew = $AWS_URL . $uploadThumbnailPath; 
                    unlink($thumb_tmp_path);
                }
    
                $userId = $request->userId;
                $userName = $request->userName;
                $email = $request->email;
                $userRole = $request->userRole;
                $fileExtension = $request->fileExtension;
                $size = $request->size;
                $type = $request->type;
                $date = $request->date;
                $file = $request->file;
                $fileobject = "data:".$request->type.";base64,".base64_encode($binary);
    
                $insertdata = array('fileName' => $fileNamenew, "userId" => $userId, "userName" => $userName, "email" => $email, "userRole" => $userRole, "fileExtension" => $fileExtension, "size" => $size, "type" => $type, "date" => $date, "file" => $file, "fileobject" => $fileobject);
                DB::table('usergallery')->insert($insertdata);
    
                return response([
                    'code' => 200,
                    'success' => true,
                    'message' => 'File Uploaded Successfully',
                    'data' => $insertdata
                ]);
            }
         

       
    }

    public function previewEmailAttachedImage(Request $request)
    { 
        $extension = pathinfo($request->fileName, PATHINFO_EXTENSION);
        $newName = $request->downloadId . '.' . $extension;
        $imagePath =  "/email-images/thumbnail/". $newName;
        $APP_URL =  env('APP_URL');
        
        if(Storage::disk('temp')->exists($imagePath)){
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'File Exist',
                'data' => $APP_URL . "/temp" . $imagePath
            ]);
        } else {  

                $url = "https://api.nylas.com/files/". $request->downloadId ."/download";  

                $headers = [
                    'Authorization' => 'Bearer ' . $request->token,
                ];
                $binary =  $this->client->request('GET', $url, [
                    'headers' => $headers 
                ])->getBody()->getContents();
                 
                 
                $fileName = "../storage/tmp/". $newName;  
                if( $extension === 'jpg' || $extension === 'jpeg' ||   $extension === 'png' || $extension === 'gif' ){
                    $thumb_tmp_path = "../storage/tmp/". $newName;
                    $this->resize_crop_image(150,   "data:".$request->type.";base64,".base64_encode($binary), $thumb_tmp_path);
                    $thumbnailFileName = "/email-images/thumbnail/". $newName . '.' . $extension;
                    $uploadThumbnailPath = \Storage::disk('temp')->putFileAs( '/email-images/thumbnail', $thumb_tmp_path, $newName , 'public');
                                       
                    $fileNamenew = $APP_URL . "/temp/" . $uploadThumbnailPath; 
                    unlink($thumb_tmp_path);
                } 
    
                return response([
                    'code' => 200,
                    'success' => true,
                    'message' => 'File Preview',
                    'data' => $fileNamenew
                ]);
           
            }

       
    }


    public function previewThumbnailImage(Request $request)
    { 
        header('Content-type: image/jpeg');
 
  /*       $im = new Imagick(public_path('file.pdf[0]'));
        $im->setImageAlphaChannel(Imagick::ALPHACHANNEL_REMOVE );
        $im->resizeImage(300, 0, Imagick::FILTER_LANCZOS, 1);
        $im->setImageFormat('jpg');
        $im->writeImage(public_path('file_das.jpg'));
 
        echo $im; */
        
        $extension = pathinfo(strtolower($request->fileName), PATHINFO_EXTENSION);
        if($extension == ''){
            $extension = 'jpg';
        } 
        $newName = $request->downloadId . '.' . $extension; 
        if( $extension === 'jpg' || $extension === 'jpeg' ||   $extension === 'png' || $extension === 'gif' ){
            $imagePath =  "/email-images/thumbnail/". $newName; 
        }else{
            $imagePath =  "/email-images/thumbnail/". $request->downloadId .'.jpg';
        } 
        $APP_URL =  env('APP_URL');
        $test = $APP_URL . '/temp/'. $imagePath;
        if(Storage::disk('temp')->exists($imagePath)){ 
            $image = Storage::disk('temp')->get($imagePath);
            return response($image, 200)->header('Content-Type', Storage::disk('temp')->getMimeType($imagePath));
        } else {   

                $url = "https://api.nylas.com/files/". $request->downloadId ."/download";  

                $headers = [
                    'Authorization' => 'Bearer ' . $request->token,
                ];
                $binary =  $this->client->request('GET', $url, [
                    'headers' => $headers 
                ])->getBody()->getContents();
                  
                $fileName = "../storage/tmp/". $newName;  
                if( $extension === 'jpg' || $extension === 'jpeg' ||   $extension === 'png' || $extension === 'gif' ){
                    $thumb_tmp_path = "../storage/tmp/". $newName;
                    $this->resize_crop_image(300,   "data:".$request->type.";base64,".base64_encode($binary), $thumb_tmp_path);
                    $thumbnailFileName = "/email-images/thumbnail/". $newName . '.' . $extension;
                    $uploadThumbnailPath = \Storage::disk('temp')->putFileAs( '/email-images/thumbnail', $thumb_tmp_path, $newName , 'public');
                                       
                   /*  $fileNamenew = $APP_URL . "/temp/" . $uploadThumbnailPath;   */
                  
                    unlink($thumb_tmp_path);
                }else {
               


                    $img_array = array();
                    $im = new imagick();
                     
                    $im->readImageBlob($binary);
                    $im->setImageAlphaChannel(Imagick::ALPHACHANNEL_REMOVE );
                    $im->resizeImage(300, 0, Imagick::FILTER_LANCZOS, 1);
                    $im->setImageFormat('jpg');
                    $num_pages = $im->getNumberImages();
                    /* for($i = 0;$i < $num_pages; $i++) 
                    { */
                        $im->setIteratorIndex(0);
                        $im->setImageFormat('jpeg');
                        $img_array[0] = $im->getImageBlob();
                        $im->writeImage(public_path('/temp/email-images/thumbnail/'. $request->downloadId .'.jpg'));
                    /* } */
                    /* $im->destroy(); */
                   /*  echo $im; */
                } 
    
                $image = Storage::disk('temp')->get($imagePath);
                return response($image, 200)->header('Content-Type', Storage::disk('temp')->getMimeType($imagePath));
            }

       
    }

    public function previewImage(Request $request)
    { 
        header('Content-type: image/jpeg');
        $extension = pathinfo($request->fileName, PATHINFO_EXTENSION);
        $newName = $request->downloadId . '.' . $extension;
        $imagePath =  "/email-images/". $newName;
        $APP_URL =  env('APP_URL');
        /* $test = $APP_URL . '/temp/'. $imagePath; */
        if(Storage::disk('temp')->exists($imagePath)){ 
            $image = Storage::disk('temp')->get($imagePath);
            return response($image, 200)->header('Content-Type', Storage::disk('temp')->getMimeType($imagePath));
        } else {   

                $url = "https://api.nylas.com/files/". $request->downloadId ."/download";  

                $headers = [
                    'Authorization' => 'Bearer ' . $request->token,
                ];
                $binary =  $this->client->request('GET', $url, [
                    'headers' => $headers 
                ])->getBody()->getContents();

  
                $uploadPath =  Storage::disk("temp")->put($imagePath , $binary); 
               
                $image = Storage::disk('temp')->get($imagePath);
                return response($image, 200)->header('Content-Type', Storage::disk('temp')->getMimeType($imagePath));
            }

       
    }
    /* Test - End */


    
    public function generateImage(Request $request)
    { 

        $APP_URL =  env('APP_URL');

        $gallery = DB::table('usergallery')
        ->WHERE('id', $request->id)
        ->get('fileName');
        $imageValue  = str_replace($APP_URL, '', $gallery[0]->fileName);
        if($request->size == 'preview'){
            $imageSize = "1000";
        }else if($request->size == 'thumbnail'){
            $imageSize = "300";
        }
         
        header('Content-type: image/jpeg');
        $im = new Imagick(public_path($imageValue));
        $im->setImageAlphaChannel(Imagick::ALPHACHANNEL_REMOVE );
        $im->resizeImage($imageSize, 0, Imagick::FILTER_LANCZOS, 1);
        $im->setImageFormat('jpg');
        $im->writeImage(public_path('file_das.jpg'));
 
        echo $im;
  
       
    }

    public function generateOtherImage(Request $request)
    { 

        $APP_URL =  env('APP_URL');

        /* $query = parse_url(request('v'), PHP_URL_QUERY);
        parse_str($query, $params); */
       /*  $youtubeId = $params['v']; */
     

         
        $imageValue  = str_replace($APP_URL, '', request('v'));
        $imageSize = "300";
        
         
        header('Content-type: image/jpeg');
        $im = new Imagick(public_path($imageValue));
        $im->setImageAlphaChannel(Imagick::ALPHACHANNEL_REMOVE );
        $im->resizeImage($imageSize, 0, Imagick::FILTER_LANCZOS, 1);
        $im->setImageFormat('jpg');
        $im->writeImage(public_path('file_das.jpg'));
 
        echo $im;
  
       
    }
}
