<?php

namespace App\Http\Controllers;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\ShopifyLocationController;
//use \EaseAppPHP\Hmac\Hmac;
use Illuminate\Http\Request;
use App\Models\Order;
use Validator;
use App\Models\Misc;
use App\Models\OrderArt;
use App\Models\OrderMeta;
use App\Models\OrderDetails;
use App\Models\UserOrderType;
use App\Models\User;
use App\Models\Resource;
use App\Models\ActivityNotif;
use App\Models\PastLabels;
use App\Models\AccessCode;
use App\Models\SiteSettings;
use App\Models\OrderEmailQueue;
use App\Models\IssueWithOrder;
use App\Mail\SendInvoice;
use App\Mail\ResourceSend;
use App\Mail\CheckoutPageAlert;
use App\Mail\OrderHasBeenPaidFor;
use App\Mail\OrderCompleted;
use App\Mail\OrderCompletedPlusTracking;
use App\Mail\OrderProduction;
use App\Models\ShopifyIntegration;
use App\Models\ShopifyLocation;
use App\Models\UserStripeData;
use App\Models\UserSquareData;
use App\Models\StyleColorProduct;
use Illuminate\Support\Facades\File;
use App\Models\ProductGroup;
/* temp - start */
/* use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Builder;  */
/* temp - end */
use Mail;
use Illuminate\Support\Facades\DB;
use \Stripe;
use Etsy\OAuth\Client as Etsy;
use Goutte\Client;

use GuzzleHttp as Guzzle;
use Illuminate\Support\Facades\Redirect;
use App\Models\Product;
use Illuminate\Support\Facades\Log;

use HeadlessChromium\BrowserFactory;
use HeadlessChromium\Page;

use App\Mail\ResourceEmail;   
use \Twilio;
use Config;
//////////////

use Square\SquareClient;
use Square\Environment;
use Square\Models\Address;
use Square\Models\Country;
use Square\Models\CreateCustomerRequest;
use Square\Models\CreateInvoiceRequest;
use Square\Models\CreateLocationRequest;
use Square\Models\Currency;
use Square\Models\Invoice;
use Square\Models\InvoiceAcceptedPaymentMethods;
use Square\Models\InvoiceAutomaticPaymentSource;
use Square\Models\InvoiceDeliveryMethod;
use Square\Models\InvoiceRecipient;
use Square\Models\InvoicePaymentRequest;
use Square\Models\InvoiceRequestMethod;
use Square\Models\InvoiceRequestType;
use Square\Models\Location;
use Square\Models\LocationCapability;
use Square\Models\Money;
use Square\Models\Order as SquareOrder;
use Square\Models\OrderSource;
use Square\Models\OrderLineItem;
use Square\Models\OrderQuantity;
use Square\Models\OrderQuantityUnit;
use Square\Models\PublishInvoiceRequest;
use Square\Models\MeasurementUnit;
use Square\Models\MeasurementUnitArea;
use Square\Models\MeasurementUnitCustom;
use Square\Models\MeasurementUnitLength;
use Square\Models\MeasurementUnitUnitType;
use Square\Models\MeasurementUnitVolume;
use Square\Models\MeasurementUnitWeight;
use Square\Models\CreateOrderRequest;
use Square\Exceptions\ApiException;

use App\Models\PrintJob;

use Sauladam\ShipmentTracker\ShipmentTracker;



class OrderController extends Controller
{


    public function resize_crop_image($max_width, $source_file, $dst_dir ){
        $imgsize = getimagesize($source_file);
        $width = $imgsize[0];
        $height = $imgsize[1];
        $mime = $imgsize['mime'];
        
        switch($mime){
            case 'image/gif':
                $image_create = "imagecreatefromgif";
                $image = "imagegif"; 
                break;
    
            case 'image/png':
                $image_create = "imagecreatefrompng";
                $image = "imagepng";
                $quality = 7;
                break;
    
            case 'image/jpeg':
                $image_create = "imagecreatefromjpeg";
                $image = "imagejpeg";
                $quality = 80;
                break;
    
            default:                
                return false;
                break;
        }
        $new_height = abs($max_width * $height / $width);
        $dst_img = imagecreatetruecolor($max_width, $new_height);
        $src_img = @$image_create($source_file);
                
        imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $max_width, $new_height, $width, $height); 
        if($image == "imagegif"){
            $image($dst_img, $dst_dir);
        }else{
            $image($dst_img, $dst_dir, $quality);
        }
    
        if($dst_img)imagedestroy($dst_img);
        if($src_img)imagedestroy($src_img);
    }

    public function Etsy(Request $request){

        $isCustomIntegration = $request->get('integration_id') !== null;

        session(['integration_type' => $isCustomIntegration ? "default" : "custom"]);

        if($isCustomIntegration){

            $data = ShopifyIntegration::where(['integration_type' => 'etsy', 'id' => $request->get('integration_id')])->first();

            session(['integration_id' => $request->get('integration_id')]);

            $integration = $data->etsy_client_id;

            if($data === null){
                return "Error: no integration found.";
            }
        }

        $client = new Etsy($data->etsy_client_id); 
        $nonce = $client->createNonce(); 

        [$verifier, $challengeCode] = $client->generateChallengeCode(); 
        session(['nonce' => $nonce, 'challenge_code' => $challengeCode, 'verifier' => $verifier]); 
        session()->save(); 
        return redirect("https://www.etsy.com/oauth/connect?response_type=code&redirect_uri=".urlencode(env('ETSY_REDIRECT'))."&scope=transactions_r%20transactions_w%20listings_r%20shops_r%20email_r&client_id=". $data->etsy_client_id ."&state=superstate&code_challenge=". $challengeCode ."&code_challenge_method=S256");
      
    }

    public function getCustomerOrdersFromOrderID($orderID, Request $request){
        //get order details from the customer of this order
        if(is_numeric($orderID)){
            // orderID-based searching
            $orderDataToCheck = Order::where(['id' => $orderID])->first();
            if($orderDataToCheck !== null){
                $userDataToCheck = User::where(['id' => $orderDataToCheck->customer_id])->first();
                $fullOrderList = Order::where(['customer_id' => @$orderDataToCheck->customer_id ])->orderByDesc('id')->get();
            }else{
                $fullOrderList = null;
                $userDataToCheck = null;
            }
        }else{
            $userDataToCheck = User::whereIn('email' , explode(',',$request->email))->where(['role' => 'Customer'])->first();
            $fullOrderList = Order::where(['customer_id' => @$userDataToCheck->id])->orderByDesc('id')->get();
            if(count($fullOrderList) === 0){
                $fullOrderList = null;
            }
        }
        
        return ['orders' => $fullOrderList, 'customer' => $userDataToCheck];
    }

    public function sampleReceiptList(){
        return [
          'count' => 0,
          'results' => [
            0 => [
              'receipt_id' => 2,
              'receipt_type' => 0,
              'seller_user_id' => 1,
              'seller_email' => 'user@example.com',
              'buyer_user_id' => 1,
              'buyer_email' => 'buyer@email.com',
              'name' => 'Buyer\'s Name',
              'first_line' => 'string',
              'second_line' => 'string',
              'city' => 'Los Angeles',
              'state' => 'CA',
              'zip' => '90210',
              'status' => 'paid',
              'formatted_address' => 'Address St., Los Angeles, CA',
              'country_iso' => 'USA',
              'payment_method' => 'card',
              'payment_email' => 'buyer@email.com',
              'message_from_seller' => 'string',
              'message_from_buyer' => 'New Message From Buyer',
              'message_from_payment' => 'string',
              'is_paid' => true,
              'is_shipped' => true,
              'create_timestamp' => 946684800,
              'created_timestamp' => 946684800,
              'update_timestamp' => 946684800,
              'updated_timestamp' => 946684800,
              'is_gift' => true,
              'gift_message' => 'string',
              'grandtotal' => [
                'amount' => 0,
                'divisor' => 0,
                'currency_code' => 'string',
              ],
              'subtotal' => [
                'amount' => 0,
                'divisor' => 0,
                'currency_code' => 'string',
              ],
              'total_price' => [
                'amount' => 0,
                'divisor' => 0,
                'currency_code' => 'string',
              ],
              'total_shipping_cost' => [
                'amount' => 0,
                'divisor' => 0,
                'currency_code' => 'string',
              ],
              'total_tax_cost' => [
                'amount' => 0,
                'divisor' => 0,
                'currency_code' => 'string',
              ],
              'total_vat_cost' => [
                'amount' => 0,
                'divisor' => 0,
                'currency_code' => 'string',
              ],
              'discount_amt' => [
                'amount' => 0,
                'divisor' => 0,
                'currency_code' => 'string',
              ],
              'gift_wrap_price' => [
                'amount' => 0,
                'divisor' => 0,
                'currency_code' => 'string',
              ],
              'shipments' => [
                0 => [
                  'receipt_shipping_id' => 1,
                  'shipment_notification_timestamp' => 946684800,
                  'carrier_name' => 'string',
                  'tracking_code' => 'string',
                ],
              ],
              'transactions' => [
                0 => [
                  'transaction_id' => 1,
                  'title' => 'string',
                  'description' => 'string',
                  'seller_user_id' => 1,
                  'buyer_user_id' => 1,
                  'create_timestamp' => 946684800,
                  'created_timestamp' => 946684800,
                  'paid_timestamp' => 946684800,
                  'shipped_timestamp' => 946684800,
                  'quantity' => 0,
                  'listing_image_id' => 1,
                  'receipt_id' => 1,
                  'is_digital' => true,
                  'file_data' => 'string',
                  'listing_id' => 0,
                  'transaction_type' => 'string',
                  'product_id' => 1,
                  'sku' => 'string',
                  'price' => [
                    'amount' => 0,
                    'divisor' => 0,
                    'currency_code' => 'string',
                  ],
                  'shipping_cost' => [
                    'amount' => 0,
                    'divisor' => 0,
                    'currency_code' => 'string',
                  ],
                  'variations' => [
                    0 => [
                    ],
                  ],
                  'product_data' => [
                    0 => [
                    ],
                  ],
                  'shipping_profile_id' => 1,
                  'min_processing_days' => 1,
                  'max_processing_days' => 1,
                  'shipping_method' => 'string',
                  'shipping_upgrade' => 'string',
                  'expected_ship_date' => 946684800,
                  'buyer_coupon' => 0,
                  'shop_coupon' => 0,
                ],
              ],
              'refunds' => [
                0 => [
                  'amount' => [
                    'amount' => 0,
                    'divisor' => 0,
                    'currency_code' => 'string',
                  ],
                  'created_timestamp' => 946684800,
                  'reason' => 'string',
                  'note_from_issuer' => 'string',
                  'status' => 'string',
                ],
              ],
            ],
          ],
        ];
    }

    public function orderKeyList(){
        return ["name","type","type_notes","arrival_type","arrival_other","arrival_date","hard_due_date","art_notes","ship_type","ship_notes","customer_name","customer_attn","customer_track_url","customer_notes","customer_address","customer_state","customer_zipcode","customer_email","customer_phone","shipping_label_url","packing_list_url","setup_name","setup_screen_1","setup_screen_2","setup_notes","proof_url","proof_notes","position_front","position_back","position_right_left","position_additional","position_notes","product_user_type_1","product_user_other_type_1","per_piece_1","tax_1","item_number_1","apparel_type_1","product_color_1","brand_name_1","product_description_1","product_apparel_source_1","product_apparel_source_other_1","location_1","xs_1","s_1","m_1","l_1","xl_1","xxl_1","xxxl_1","other_size_1_1","other_size_text_1_1","pcs_1_1","other_size_2_1","other_size_text_2_1","pcs_2_1","other_size_3_1","other_size_text_3_1","pcs_3_1","other_size_4_1","other_size_text_4_1","pcs_4_1","product_user_type_2","product_user_other_type_2","per_piece_2","tax_2","item_number_2","apparel_type_2","product_color_2","brand_name_2","product_description_2","product_apparel_source_2","product_apparel_source_other_2","location_2","xs_2","s_2","m_2","l_2","xl_2","xxl_2","xxxl_2","other_size_1_2","other_size_text_1_2","pcs_1_2","other_size_2_2","other_size_text_2_2","pcs_2_2","other_size_3_2","other_size_text_3_2","pcs_3_2","other_size_4_2","other_size_text_4_2","pcs_4_2","product_user_type_3","product_user_other_type_3","per_piece_3","tax_3","item_number_3","apparel_type_3","product_color_3","brand_name_3","product_description_3","product_apparel_source_3","product_apparel_source_other_3","location_3","xs_3","s_3","m_3","l_3","xl_3","xxl_3","xxxl_3","other_size_1_3","other_size_text_1_3","pcs_1_3","other_size_2_3","other_size_text_2_3","pcs_2_3","other_size_3_3","other_size_text_3_3","pcs_3_3","other_size_4_3","other_size_text_4_3","pcs_4_3","product_user_type_4","product_user_other_type_4","per_piece_4","tax_4","item_number_4","apparel_type_4","product_color_4","brand_name_4","product_description_4","product_apparel_source_4","product_apparel_source_other_4","location_4","xs_4","s_4","m_4","l_4","xl_4","xxl_4","xxxl_4","other_size_1_4","other_size_text_1_4","pcs_1_4","other_size_2_4","other_size_text_2_4","pcs_2_4","other_size_3_4","other_size_text_3_4","pcs_3_4","other_size_4_4","other_size_text_4_4","pcs_4_4","product_user_type_5","product_user_other_type_5","per_piece_5","tax_5","item_number_5","apparel_type_5","product_color_5","brand_name_5","product_description_5","product_apparel_source_5","product_apparel_source_other_5","location_5","xs_5","s_5","m_5","l_5","xl_5","xxl_5","xxxl_5","other_size_1_5","other_size_text_1_5","pcs_1_5","other_size_2_5","other_size_text_2_5","pcs_2_5","other_size_3_5","other_size_text_3_5","pcs_3_5","other_size_4_5","other_size_text_4_5","pcs_4_5","created_at","pay","invoice_number","status","printer_id","printer_schedule","printer_duration","print_date","printer_type","color_notes","customer_address_2","color_1","color_2","color_3","color_4","color_5","color_6","color_1_pantone","color_2_pantone","color_3_pantone","color_4_pantone","color_5_pantone","color_6_pantone","boxes","weight","po_number","shipping_order_id","carriers_code","film_file","order_key","temp_password","shipping_des","shipping_amt","invoice","film_notes","etsy_id","full_color_count","placements","extra_services","access_code"];
    }

    public function orderKeyListForShopify(){
        return ["name","type","type_notes","arrival_type","arrival_other","arrival_date","hard_due_date","art_notes","ship_type","ship_notes","customer_name","customer_attn","customer_track_url","customer_notes","customer_address","customer_state","customer_zipcode","customer_email","customer_phone","shipping_label_url","packing_list_url","setup_name","setup_screen_1","setup_screen_2","setup_notes","proof_url","proof_notes","position_front","position_back","position_right_left","position_additional","position_notes","product_user_type_1","product_user_other_type_1","per_piece_1","tax_1","item_number_1","apparel_type_1","product_color_1","brand_name_1","product_description_1","product_apparel_source_1","product_apparel_source_other_1","location_1","xs_1","s_1","m_1","l_1","xl_1","xxl_1","xxxl_1","other_size_1_1","other_size_text_1_1","pcs_1_1","other_size_2_1","other_size_text_2_1","pcs_2_1","other_size_3_1","other_size_text_3_1","pcs_3_1","other_size_4_1","other_size_text_4_1","pcs_4_1","product_user_type_2","product_user_other_type_2","per_piece_2","tax_2","item_number_2","apparel_type_2","product_color_2","brand_name_2","product_description_2","product_apparel_source_2","product_apparel_source_other_2","location_2","xs_2","s_2","m_2","l_2","xl_2","xxl_2","xxxl_2","other_size_1_2","other_size_text_1_2","pcs_1_2","other_size_2_2","other_size_text_2_2","pcs_2_2","other_size_3_2","other_size_text_3_2","pcs_3_2","other_size_4_2","other_size_text_4_2","pcs_4_2","product_user_type_3","product_user_other_type_3","per_piece_3","tax_3","item_number_3","apparel_type_3","product_color_3","brand_name_3","product_description_3","product_apparel_source_3","product_apparel_source_other_3","location_3","xs_3","s_3","m_3","l_3","xl_3","xxl_3","xxxl_3","other_size_1_3","other_size_text_1_3","pcs_1_3","other_size_2_3","other_size_text_2_3","pcs_2_3","other_size_3_3","other_size_text_3_3","pcs_3_3","other_size_4_3","other_size_text_4_3","pcs_4_3","product_user_type_4","product_user_other_type_4","per_piece_4","tax_4","item_number_4","apparel_type_4","product_color_4","brand_name_4","product_description_4","product_apparel_source_4","product_apparel_source_other_4","location_4","xs_4","s_4","m_4","l_4","xl_4","xxl_4","xxxl_4","other_size_1_4","other_size_text_1_4","pcs_1_4","other_size_2_4","other_size_text_2_4","pcs_2_4","other_size_3_4","other_size_text_3_4","pcs_3_4","other_size_4_4","other_size_text_4_4","pcs_4_4","product_user_type_5","product_user_other_type_5","per_piece_5","tax_5","item_number_5","apparel_type_5","product_color_5","brand_name_5","product_description_5","product_apparel_source_5","product_apparel_source_other_5","location_5","xs_5","s_5","m_5","l_5","xl_5","xxl_5","xxxl_5","other_size_1_5","other_size_text_1_5","pcs_1_5","other_size_2_5","other_size_text_2_5","pcs_2_5","other_size_3_5","other_size_text_3_5","pcs_3_5","other_size_4_5","other_size_text_4_5","pcs_4_5","created_at","pay","invoice_number","status","printer_id","printer_schedule","printer_duration","print_date","printer_type","color_notes","customer_address_2","color_1","color_2","color_3","color_4","color_5","color_6","color_1_pantone","color_2_pantone","color_3_pantone","color_4_pantone","color_5_pantone","color_6_pantone","boxes","weight","po_number","shipping_order_id","carriers_code","film_file","order_key","temp_password","shipping_des","shipping_amt","invoice","film_notes","etsy_id","full_color_count","placements","extra_services"];
    }

    public function deliverViaUber(Request $request, $orderID){
        $alertMessage = 'Failed to Order Via Uber. Reason: ';

        //check to see if order exists
        $orderDetails = Order::where(['id' => $orderID])->first();
        $orderDetailsTable = OrderDetails::where(['order_id' => $orderID])->first();
        $userDetails = User::where(['id' => $orderDetails->customer_id])->first();
        $redirectionScript = "";

        if($orderDetails !== null){

            //check to see that the user has the right code
            if($request->get('code') !== $orderDetailsTable->access_code){
                $alertMessage = 'Wrong access code. Please use the link provided for you in your email.';
            }

            //check to see if order has already delivered
            $orderIsntDeliveredYetCheck = (strlen(trim($orderDetailsTable->uber_was_delivered)) <= 1) && $orderDetailsTable->uber_was_delivered !== 'cancelled';

            if($orderIsntDeliveredYetCheck){
                //get a token from Uber

                $loginClient = new Guzzle\Client([
                    'base_uri' =>  "https://auth.uber.com/oauth/v2/token/"
                ]);

                $accessToken = $loginClient->post('',[
                    'form_params' => [
                        'client_id' => env('UBER_API_CLIENT_ID'),
                        'client_secret' => env('UBER_API_CLIENT_SECRET'),
                        'grant_type' => 'client_credentials',
                        'scope' => 'eats.deliveries direct.organizations'
                    ]
                ]);

                $accessToken = json_decode($accessToken->getBody()->getContents());
                $accessToken = $accessToken->access_token;

                //manifest items will be the item orders
                //it will be clumped with the other orders in this batch
                //if there is no invoice, then it's just the id

                if(strlen(trim($orderDetails->invoice_id).'') > 0){
                    $ordersWithinInvoice = Order::where(['invoice_id' => $orderDetails->invoice_id])->get();
                }else{
                    $ordersWithinInvoice = Order::where(['id' => $orderDetails->id])->get();
                }

                $manifestItems = [];

                foreach($ordersWithinInvoice as $order){
                    $manifestItems[count($manifestItems)] = [
                        'name' => $order->name,
                        'quantity' => 1,
                        'size' => 'medium',
                        'price' => 0
                    ];
                }

                $userDetailsForPickup = User::where(['id' => env('USER_ID_FOR_UBER_PICKUP')])->first();

                //just the city + address/address2 will suffice as a complete address

                $dropoffAddress = new \stdClass;
                $noDiscernableDropoffAddress = false;

                if(strlen(trim($orderDetails->customer_city)) > 0 && ( strlen(trim($orderDetails->customer_address)) > 0 || strlen(trim($orderDetails->customer_address_2)) > 0 )){

                    $dropoffAddress->street_apartment = $orderDetails->customer_address_2;
                    $dropoffAddress->address = $orderDetails->customer_address;
                    $dropoffAddress->city = $orderDetails->customer_city;
                    $dropoffAddress->state = $orderDetails->customer_state;
                    $dropoffAddress->zipcode = $orderDetails->customer_zipcode;
                }else{
                    //use user details instead if it's not found

                    $dropoffAddress = $userDetails;
                    if(strlen(trim($dropoffAddress->customer_city)) === 0 || ( strlen(trim($dropoffAddress->customer_address)) === 0 || strlen(trim($dropoffAddress->customer_address_2)) === 0 )){

                        // if there is no discernable address, switch it off
                        $noDiscernableDropoffAddress = true;
                    }

                }

                if($noDiscernableDropoffAddress){
                    $alertMessage = 'Creating a delivery is not allowed. Reason: no discernable dropoff address.';
                }else{
                    try {
                        //check to see if the customer details are empty
                        //if it is, use the user's address data instead 

                        $deliveryData = array (
                            'pickup_address' => trim(
                                trim($userDetailsForPickup->street_apartment) . ' ' . 
                                trim($userDetailsForPickup->address) . ', '. 
                                trim($userDetailsForPickup->city) . ', ' . 
                                trim($userDetailsForPickup->state) . ' ' . 
                                trim($userDetailsForPickup->zipcode)),
                            'pickup_name' => env('UBER_PICKUP_NAME'),
                            'pickup_phone_number' => '+1'.$userDetailsForPickup->contact_number,
                            'dropoff_name' => $orderDetails->customer_name,
                            'dropoff_phone_number' => '+1'.$orderDetails->customer_phone,
                            'dropoff_address' => 
                                trim(trim($dropoffAddress->street_apartment) . ' ' . 
                                trim($dropoffAddress->address) . ', '. 
                                trim($dropoffAddress->city) . ', ' . 
                                trim($dropoffAddress->state) . ' ' . 
                                trim($dropoffAddress->zipcode)),
                            'manifest_items' => $manifestItems,
                            'external_id' => $orderDetails->id.''
                        );


                        $directAPIClient = new Guzzle\Client([
                            'base_uri' => "https://api.uber.com/v1/",
                            'headers' => [
                                'Content-Type' => 'application/json',
                                'Authorization' => 'Bearer ' . $accessToken
                            ]
                        ]);

                        $trackingData = $directAPIClient->post('customers/'. env('UBER_CUSTOMER_ID') .'/deliveries',
                            ['body' => json_encode($deliveryData)]
                        );

                        $trackingData = json_decode($trackingData->getBody()->getContents());

                        //get tracking URL
                        $trackingUrl = $trackingData->tracking_url;

                        //message user
                        $redirectionScript = "window.location.href = '$trackingUrl'";
                        \Log::emergency('Note: Your order '.$orderDetails->name.' has been shipped via Uber. You can view the order status at ' . $trackingUrl. ' 

If you want to cancel this delivery, go to '. env("APP_URL") .'/cancel_order/'. $trackingData->id);

                        Twilio::message($orderDetails->customer_phone, 
                        'Your order '.$orderDetails->name.' has been shipped via Uber. You can view the order status at ' . $trackingUrl. ' 

If you want to cancel this delivery, go to '. env("APP_URL") .'/cancel_order/'. $trackingData->id);

                        $alertMessage = 'Creating delivery was successful. Redirecting you to the Uber tracking page...';
                    }catch(\Exception $e){

                        $response = $e->getResponse();
                        $full = $response->getBody()->getContents();
                        $alertMessage = str_replace(array("\r", "\n"), '', 'Error creating delivery. Reason: ' . $e->getMessage());

                    }

                }

            }else{
                $alertMessage .= 'Order has already been processed for delivery.';
            }

        }else{
            $alertMessage .= 'Order doesn\'t exist.';
        }

        return "<script>document.write('$alertMessage'); $redirectionScript</script>";
        //check to see that the order hasnt already had an uber for it or hasnt been delivered

    }



    public function cancelUberOrder($deliveryID, Request $request){

        $loginClient = new Guzzle\Client([
            'base_uri' =>  "https://auth.uber.com/oauth/v2/token/"
        ]);

        $accessToken = $loginClient->post('',[
            'form_params' => [
                'client_id' => env('UBER_API_CLIENT_ID'),
                'client_secret' => env('UBER_API_CLIENT_SECRET'),
                'grant_type' => 'client_credentials',
                'scope' => 'eats.deliveries direct.organizations'
            ]
        ]);

        $accessToken = json_decode($accessToken->getBody()->getContents());
        $accessToken = $accessToken->access_token;

        $directAPIClient = new Guzzle\Client([
            'base_uri' => "https://api.uber.com/v1/",
            'headers' => [
                'Content-Type' => 'application/json',
                'Authorization' => 'Bearer ' . $accessToken
            ]
        ]);

        $alertMessage = '';

        try {

            $cancelDelivery = $directAPIClient->post('customers/'. env('UBER_CUSTOMER_ID') .'/deliveries/'. $deliveryID . '/cancel'

            );

            $deliveryData = json_decode($cancelDelivery->getBody()->getContents());
            $order = Order::where(['id' => $deliveryData->external_id])->first();

            $note = 'Uber Delivery to be sent to ' . $deliveryData->dropoff->address . ' (linked to Order #'. $order->id .': '. $order->name .') was cancelled. Please try again later.';

            \Log::emergency('Note: '. $note);
            $userDetailsForPickup = User::where(['id' => env('USER_ID_FOR_UBER_PICKUP')])->first();
            Twilio::message('+1'.$userDetailsForPickup->contact_number, $note);
            Twilio::message('+1'.$order->customer_phone, $note);

            return "<script>document.write('Successfully cancelled Uber delivery at ". $deliveryData->tracking_url ."')</script>";
        }catch(\Exception $e){
            return "<script>alert('Failed to cancel Uber delivery. Please try again later.'); window.close();</script>";
        }

    }

    public function shopifyOrderSync(Request $request){

        //get list of all shopify integrations


        if($request->get('integration_id') !== null){
            $integrationsList = ShopifyIntegration::where(['integration_type' => 'shopify', 'id' => $request->integration_id])->get();
        }else{
            $integrationsList = ShopifyIntegration::where(['integration_type' => 'shopify'])->get();
        }

        foreach($integrationsList as $integration => $shop):

            try {

            $client = new Guzzle\Client([
                'base_uri' =>  "https://".$shop->shop_url."/admin/api/2023-01/",
                'headers' => [ 
                    'X-Shopify-Access-Token' => $shop->admin_access_api_key,
                    'Content-Type' => 'application/json'
                ],
                'verify' => false
            ]);

            $locations = ShopifyLocation::where(['shop_id' => $shop->id])->get();

            $ordersList = $client->get('orders.json?status=any',[]);

            $ordersList = json_decode($ordersList->getBody()->getContents())->orders;

            //cross reference orders with our order list

            $idCompilation = [];

            foreach($ordersList as $shopifyOrder){
                $idCompilation[count($idCompilation)] = $shopifyOrder->id;
            }

            $existingShopifyOrders = Order::withTrashed()->whereIn('shopify_id',$idCompilation)->get();

            $newOrderCompilation = [];

            $compiledOrderIDs = [];

            $upsertOrderMetaData = [];



            $firstCountChecks = [];
            foreach($ordersList as $shopifyOrder){
                //check to see that the order's location is active
                $locationIsActive = true;
                if(count($locations) > 0){
                    foreach($locations as $loc){
                        if($loc->location_id.'' === @$shopifyOrder->fulfillments[0]->location_id.''){
                            if($loc->is_active === 'false'){
                                $locationIsActive = false;
                            }
                        }
                    }
                }           
                if(!$locationIsActive){
                    continue;
                }


                $compiledOrderIDs[count($compiledOrderIDs)] = $shopifyOrder->id;

                $hasMatchingOrder = false;

                //////////////////////// user sync ///////////////////////////

                //create user if it doesn't exist

                $creatorID = @auth()->user()->id;

                //check if the shop owner's data is available 

                if(@$shop->shop_metadata['email'] !== null){

                    //check to see if this user's email was already registered as a user

                    $creatorUserCheck = User::where(['email' => @$shop->shop_metadata['email']])->first();


                    if($creatorUserCheck === null){

                        //create this user's data

                        $creatorUser = new User;
                        $creatorUser->role = 'Shop_Owner';
                        $creatorUser->password = bcrypt('^^^%!@#$%^&*()*&^^%$#');
                        $creatorUser->first_name = "". @explode(' ', trim(@$shop->shop_metadata['shop_email'] ))[0];
                        $creatorUser->last_name = "". @explode(' ', trim(@$shop->shop_metadata['shop_owner'] ))[1];
                        $creatorUser->email = @$shop->shop_metadata['email'];
                        $creatorUser->save(); 

                        $creatorID = $creatorUser->id;
                    }else{
                        $creatorID = $creatorUserCheck->id;
                    }


                }

                $shopifyAliasEmail = @$shopifyOrder->customer->email !== null ? $shopifyOrder->customer->email : 'shopify-'. $shopifyOrder->customer->id.'@shopify.com';

                $userCheck = User::where(['email' => $shopifyAliasEmail])->get();

                if(count($userCheck) === 0){
                    //create new user

                    //try {
                    $user = new User;
                    $user->role = 'Shopify_Customer';
                    $user->password = bcrypt('!@#$%^&*()~!@#&^%');
                    $user->first_name = @$shopifyOrder->customer->first_name !== null ? @$shopifyOrder->customer->first_name : 'USERID#';
                    $user->last_name = @$shopifyOrder->customer->last_name !== null ? @$shopifyOrder->customer->last_name : $shopifyOrder->customer->id;
                    $user->company = '';
                    $user->street_appartment = @$shopifyOrder->shipping_address->address1;
                    $user->created_by = 1;
                    $user->email = $shopifyAliasEmail;
                    $user->status = 1;
                    $user->terms = '';
                    $user->sales_tax_enabled = '';
                    $user->sales_tax = '';
                    $user->sms_required = '';
                    $user->state = @$shopifyOrder->shipping_address->state;
                    $user->contact_number = '3109169514';
                    $user->shipping_phone = '3109169514';
                    $user->shipping_city = @$shopifyOrder->shipping_address->city;
                    $user->city = @$shopifyOrder->shipping_address->city;
                    $user->zipcode = @$shopifyOrder->shipping_address->zip;
                    $user->shipping_name = @$shopifyOrder->customer->first_name;
                    $user->shipping_state = @$shopifyOrder->shipping_address->state;
                    $user->shipping_last_name = @$shopifyOrder->customer->last_name;
                    $user->shipping_address = @$shopifyOrder->shipping_address->address1;
                    $user->address = @$shopifyOrder->shipping_address->address2;
                    // $user->shipping_street_appartment = $receipt->second_line;
                    // $user->street_appartment = $receipt->second_line;
                    $user->shipping_email = @$shopifyOrder->contact_email;
                    $user->shipping_zipcode = @$shopifyOrder->shipping_address->zip;
                    $user->shopify_id = @$shopifyOrder->user_id;

                    $user->save();

                    // }catch(\Exception $e){

                    // }

                }
                
                $userCheck = User::where(['email' => $shopifyAliasEmail])->get();
            
                        
                //////////////////////////////////////////////////////////////

                foreach($existingShopifyOrders as $currentOrder){
                    if($shopifyOrder->id.'' === $currentOrder->shopify_id.''){
                        $hasMatchingOrder = true;
                        $orderOnQue = $currentOrder;
                    }
                }

                $newOrCurrentStatus = $hasMatchingOrder ? $orderOnQue->status : 'Processing';

                $creatorID = @auth()->user()->id;

                //check if the shop owner's data is available 

                if(@$shop->shop_metadata['email'] !== null){

                    //check to see if this user's email was already registered as a user

                    $creatorUserCheck = User::where(['email' => @$shop->shop_metadata['email']])->first();


                    if($creatorUserCheck === null){

                        //create this user's data

                        $creatorUser = new User;
                        $creatorUser->role = 'Shop_Owner';
                        $creatorUser->password = bcrypt('^^^%!@#$%^&*()*&^^%$#');
                        $creatorUser->first_name = "". @explode(' ', trim(@$shop->shop_metadata['shop_email'] ))[0];
                        $creatorUser->last_name = "". @explode(' ', trim(@$shop->shop_metadata['shop_owner'] ))[1];
                        $creatorUser->email = @$shop->shop_metadata['email'];
                        $creatorUser->save(); 

                        $creatorID = $creatorUser->id;
                    }else{
                        $creatorID = $creatorUserCheck->id;
                    }


                }
                unset($customerAddress,$customerAddress2,$customerCity,$customerZip,$customerPhone,$customerState);
                if(!$hasMatchingOrder){
                    $shipType = '';
                    $shippingInstructions = '';

                    //check to see the first line in fulfillments

                    $fulfillmentData = @$shopifyOrder->fulfillments[0];

                    $firstShippingline = @$shopifyOrder->shipping_lines[0];

                    $orderIsInPickupMode = ($shopifyOrder->shipping_address === null);

                    $shippingInstructions = @$firstShippingline->code;
                    $shipType = $firstShippingline->code;


                    if($orderIsInPickupMode){
                        //update list of shopify locations for this shop

                        $shopifyLocationController = new ShopifyLocationController;

                        $shopifyLocationController->index($shop->id,$request);

                        //scout the name with a matching location

                        $matchingLocation = ShopifyLocation::where(['shop_id' => $shop->id])->where('name','like',"%". @$firstShippingline->code ."%")->first();

                        if($matchingLocation !== null){
                            $shipType = 'location_pickup';
                            /* $shippingInstructions = @$firstShippingline->code; */

                            $customerAddress = @$matchingLocation->location_metadata->address1;
                            $customerAddress2 = @$matchingLocation->location_metadata->address2;
                            $customerCity = @$matchingLocation->location_metadata->city;
                            $customerState = @$matchingLocation->location_metadata->province_code;
                            $customerZip = @$matchingLocation->location_metadata->zip;
                            $customerPhone = @$matchingLocation->location_metadata->phone;

                        }

                        //if location matches, make it the customer data 
                    }else{
                        $customerAddress = @$shopifyOrder->shipping_address->address1;
                        $customerAddress2 = @$shopifyOrder->shipping_address->address2;
                        $customerCity = @$shopifyOrder->shipping_address->city;
                        $customerState = @$shopifyOrder->shipping_address->province_code;
                        $customerZip = @$shopifyOrder->shipping_address->zip;
                        $customerPhone = @$shopifyOrder->shipping_address->phone;
                    }

                    $timestampToModify = strtotime($shopifyOrder->processed_at);

                    $newOrderCompilation[count($newOrderCompilation)] = [
                        'customer_id' => @$userCheck[0]->id !== null ? $userCheck[0]->id : @$user->id,
                        'shopify_id' => $shopifyOrder->id,
                        'created_by' => @$creatorID,
                        'hard_due_date' => 1,
                        'name' =>  @$shopifyOrder->line_items[0]->name . " - no SKU",
                        'type' => 'screen_printing',
                        'arrival_type' => '7_10_days',
                        'tax_1' => 0,
                        'tax_2' => 0,
                        'tax_3' => 0,
                        'tax_4' => 0,
                        'tax_5' => 0,
                        'arrival_date' => DB::Raw('FROM_UNIXTIME('.$timestampToModify.') + INTERVAL 7 DAY'),
                        'arrival_type' => '7_10_days',
                        "created_at" => $shopifyOrder->created_at,
                        "customer_name" => @$shopifyOrder->customer->first_name. ' ' .@$shopifyOrder->customer->last_name,
                        "art_is_sized" => 1,
                        "customer_notes" => @$shopifyOrder->note,
                        "customer_address" => @$customerAddress,
                        "customer_address_2" => @$customerAddress2,
                        "customer_city" => @$customerCity,
                        "customer_state" => @$customerState,
                        "customer_zipcode" => @$customerZip,
                        "customer_phone" => @$customerPhone,
                        "customer_email" => @$shopifyOrder->contact_email,
                        "pay" => 1,
                        "shipped_date" => DB::Raw('NOW()'), //this will do for now
                        "status" => $newOrCurrentStatus,
                        "invoice_number" => "S".$shopifyOrder->order_number."-".$shop->id,
                        'shipping_instructions' => $shippingInstructions,
                        'ship_type' => $shipType
                    ];  

                    $shippingAddress = $shopifyOrder->shipping_address;
                    
                    $upsertOrderMetaData[count($upsertOrderMetaData)] = [
                        'shopify_metadata' => json_encode($shopifyOrder),
                        'shopify_id' => $shopifyOrder->line_items[0]->id
                    ];

                    //search for any applicable SKU

                    $skuList = [];

                    $sku = '';

                    $firstCount = true;

                    $preProductOrderDetails = $newOrderCompilation[count($newOrderCompilation)-1];

                    if(gettype($shopifyOrder->line_items) === 'array' && $shopifyOrder->line_items !== null){
                        foreach($shopifyOrder->line_items as $lineItemIndex => $item){ 
                            //first off, check to see if this item already exists

                            $alreadyExistsCheck = Order::where(['shopify_id' => $item->id])->get();

                            if(count($alreadyExistsCheck) > 0){
                                continue;
                            }

                            $firstCountChecks[count($firstCountChecks)] = [$firstCount,$lineItemIndex, $item,$shopifyOrder->id];
                            $shopifyOrder->line_item_id = $item->id;
                            $shopifyOrder->shop_id = $shop->id;
                            if($firstCount){
                                $upsertOrderMetaData[count($upsertOrderMetaData)-1]['line_item_index'] = $lineItemIndex;
                                $upsertOrderMetaData[count($upsertOrderMetaData)-1]['shopify_id'] = $item->id;
                                $upsertOrderMetaData[count($upsertOrderMetaData)-1]['shopify_metadata'] = json_encode($shopifyOrder);
                                $upsertOrderMetaData[count($upsertOrderMetaData)-1]['integration_id'] = $shop->id;
                                $firstCount = false;
                            }else{
                                //make a copy of the order before product sync, as a prototype for each succeeding line item
                                $newOrderCompilation[count($newOrderCompilation)] = $preProductOrderDetails;
                                $upsertOrderMetaData[count($upsertOrderMetaData)] = [
                                    'shopify_metadata' => json_encode($shopifyOrder),
                                    'shopify_id' => $item->id,
                                    'line_item_index' => $lineItemIndex,
                                    'integration_id' => $shop->id
                                ];
                            }
                            $newOrderCompilation[count($newOrderCompilation)-1]['name'] = $item->name;
                            $newOrderCompilation[count($newOrderCompilation)-1]['other_size_text_4_1'] = $item->quantity;
                            if(@$item->quantity !== null){
                                $newOrderCompilation[count($newOrderCompilation)-1]['other_size_text_4_1'] = $item->quantity;
                            }

                            $newOrderCompilation[count($newOrderCompilation)-1]['art_notes'] = $shopifyOrder->note;

                            $newOrderCompilation[count($newOrderCompilation)-1]['shopify_id'] = $item->id;
                            if($item->sku !== null && $item->sku !== ''){
                                $sku = $item->sku;

                                $skuList[count($skuList)] = $sku;

                                //check that this SKU wasn't already here (to prevent duplicates)

                                foreach($skuList as $currentSku){
                                    if($currentSku.'' === $sku.''){
                                        continue;
                                    }
                                }
                                $variantIDFromOrder = $item->variant_id;
                                //synchronize product data
                                $productCheck =   Product::
                                    where('sku',$sku)->orWhere(['foreign_db_id' => $variantIDFromOrder])->
                                get();
                                if(count($productCheck) > 0){

                                   

                                    $newOrderCompilation[count($newOrderCompilation)-1]['name'] = $productCheck[0]->product_name;

                                    //match the data
                                    $newOrderCompilation[count($newOrderCompilation)-1]['proof_url'] = $productCheck[0]->proof_url;
                                    $newOrderCompilation[count($newOrderCompilation)-1]['film_file'] = $productCheck[0]->film_url;
                                    $newOrderCompilation[count($newOrderCompilation)-1]['type'] = $productCheck[0]->order_type;
                                    $newOrderCompilation[count($newOrderCompilation)-1]['setup_name'] = $productCheck[0]->setup_costs;
                                    $newOrderCompilation[count($newOrderCompilation)-1]['art_notes'] = $productCheck[0]->upload_notes;
                                    $newOrderCompilation[count($newOrderCompilation)-1]['position_front'] = $productCheck[0]->front_desc;
                                    $newOrderCompilation[count($newOrderCompilation)-1]['position_back'] = $productCheck[0]->back_desc;
                                    $newOrderCompilation[count($newOrderCompilation)-1]['position_right_left'] = $productCheck[0]->right_left_desc;
                                    $newOrderCompilation[count($newOrderCompilation)-1]['position_additional'] = $productCheck[0]->additional_desc;
                                    $newOrderCompilation[count($newOrderCompilation)-1]['position_notes'] = $productCheck[0]->notes_desc;

                                    $newOrderCompilation[count($newOrderCompilation)-1]['extra_services'] = $productCheck[0]->extra_services;
                                    $newOrderCompilation[count($newOrderCompilation)-1]['full_color_count'] = $productCheck[0]->full_color_count;
                                    $newOrderCompilation[count($newOrderCompilation)-1]['placements'] = $productCheck[0]->placements;
                

                                    $checkIfEmptyColumns = ['arrival_type','arrival_other','hard_due_date'];
                                    //by default, +7 days
                                    foreach($checkIfEmptyColumns as $columnToVerify){
                                        if($productCheck[0]->{$columnToVerify}.'' !== ''){
                                            if($columnToVerify === 'arrival_type'){
                                                switch($productCheck[0]->{$columnToVerify}){
                                                    case "7_10_days":
                                                        $newOrderCompilation[count($newOrderCompilation)-1]['arrival_date'] = DB::Raw('FROM_UNIXTIME('.$timestampToModify.') + INTERVAL 7 DAY');
                                                    break;
                                                    case "5_business_days":
                                                        $newOrderCompilation[count($newOrderCompilation)-1]['arrival_date'] = DB::Raw('FROM_UNIXTIME('.$timestampToModify.') + INTERVAL 5 DAY');
                                                    break;
                                                    case "eow":
                                                        $nextFriday = strtotime('next friday');
                                                        $newOrderCompilation[count($newOrderCompilation)-1]['arrival_date'] = DB::Raw('FROM_UNIXTIME('.$nextFriday.')');
                                                    break;
                                                    case "3_days":
                                                        $newOrderCompilation[count($newOrderCompilation)-1]['arrival_date'] = DB::Raw('FROM_UNIXTIME('.$timestampToModify.') + INTERVAL 3 DAY');
                                                    break;
                                                }
                                            }
                                            $newOrderCompilation[count($newOrderCompilation)-1][$columnToVerify] = $productCheck[0]->{$columnToVerify};
                                        }
                                    } 

                                    $newOrderCompilation[count($newOrderCompilation)-1]['product_id'] = $productCheck[0]->id;

                                    for($i = 1; $i <= 5; $i++) {

                                        $newOrderCompilation[count($newOrderCompilation)-1]['product_apparel_source_'.$i] = $productCheck[0]->{'pdesc'.$i.'_source'} ;
                                        $newOrderCompilation[count($newOrderCompilation)-1]['product_apparel_source_other_'.$i] = $productCheck[0]->{'pdesc'.$i.'_other'} ;
                                        $newOrderCompilation[count($newOrderCompilation)-1]['per_piece_'.$i] = $productCheck[0]->{'pdesc'.$i.'_price'};
                                        $newOrderCompilation[count($newOrderCompilation)-1]['tax_'.$i] = isset($productCheck[0]->{'pdesc'.$i.'_tax'}) && $productCheck[0]->{'pdesc'.$i.'_tax'} == 'true' ? 'true' : 'false';
                                        $newOrderCompilation[count($newOrderCompilation)-1]['item_number_'.$i] = $productCheck[0]->{'pdesc'.$i.'_item_num'};
                                        $newOrderCompilation[count($newOrderCompilation)-1]['apparel_type_'.$i] = $productCheck[0]->{'pdesc'.$i.'_style'} ;
                                        $newOrderCompilation[count($newOrderCompilation)-1]['location_'.$i] = $productCheck[0]->{'pdesc'.$i.'_location'} ;
                                        $newOrderCompilation[count($newOrderCompilation)-1]['product_color_'.$i] = $productCheck[0]->{'pdesc'.$i.'_color'} ;
                                        $newOrderCompilation[count($newOrderCompilation)-1]['brand_name_'.$i] = $productCheck[0]->{'pdesc'.$i.'_brandname'};
                                        $newOrderCompilation[count($newOrderCompilation)-1]['product_user_type_'.$i] = $productCheck[0]->{'pdesc'.$i.'_body'} ;
                                        $newOrderCompilation[count($newOrderCompilation)-1]['product_description_'.$i] = $productCheck[0]->{'pdesc'.$i.'_desc'} ;
                                        $newOrderCompilation[count($newOrderCompilation)-1]['other_size_4_'.$i] = strtoupper($productCheck[0]->{'pdesc'.$i.'_size'});
                                        if(@$item->quantity === null){
                                            $newOrderCompilation[count($newOrderCompilation)-1]['other_size_text_4_'.$i] = $productCheck[0]->{'pdesc'.$i.'_quantity'} ;
                                        }
                                        
                                        $size = $productCheck[0]->{'pdesc'.$i.'_'.'size'};
            
                                         

                                        //color columns are identical

                                        $colorColumns = ["color_1","color_2","color_3","color_4","color_5","color_6","color_1_pantone","color_2_pantone","color_3_pantone","color_4_pantone","color_5_pantone","color_6_pantone"];

                                        foreach($colorColumns as $column){
                                            $newOrderCompilation[count($newOrderCompilation)-1][$column] = $productCheck[0]->{$column};
                                        }

                                        $allData = [
                                            'product' => $productCheck[0],
                                            'upsertData' => $newOrderCompilation[count($newOrderCompilation)-1]
                                        ];

                                         
 
                                    }
                                }

                            }

                            $uploadedImageUrl = '';

                            $fileAttachments = [];

                            foreach($item->properties as $property){


                                if(gettype($property->value) === 'string' && preg_match("#\.(png|gif|bmp|tiff|webp|zip|jp(e)?g|ai|psd|cdr|pdf)#",@$property->value)){
                                    $uploadedImageUrl = $property->value;
                                }

                                if(gettype($property->value) === 'string' && preg_match("#\.(png|gif|bmp|tiff|webp|zip|jp(e)?g|ai|psd|cdr|pdf)#",@$property->value)){
                                    $fileAttachments[count($fileAttachments)] = $property->value;
                                }


                            }

                            $uploadedData['id_'.$item->id] = $fileAttachments;

                            if($uploadedImageUrl !== ''){
                                $newOrderCompilation[count($newOrderCompilation)-1]['proof_url'] = $uploadedImageUrl;    

                            }


                        }
                    }

                }           
                
            }



            $ordersFromShopify = Order::whereIn('shopify_id',$compiledOrderIDs)->get();
            $compiledNativeOrderIDS = [];
            foreach($ordersFromShopify as $newOrders){
                $compiledNativeOrderIDS[count($compiledNativeOrderIDS)] = $newOrders->id;
            }
            $ordersMetaFromShopify = OrderMeta::whereIn('order_id',$compiledNativeOrderIDS);

            $orderProductMatches = [];

            $dataCheck = [];

            foreach($newOrderCompilation as $key => $data){
                if(isset($data['product_id'])){
                    $orderProductMatches[count($orderProductMatches)] = [$data['product_id'],$data['shopify_id']];
                    unset($newOrderCompilation[$key]['product_id']);
                }

                $orderKeyList = $this->orderKeyListForShopify();

                foreach($orderKeyList as $orderKey){
                    $dataCheck[$orderKey] = [@$data[$orderKey],isset($data[$orderKey])];
                    if(!isset($data[$orderKey])){

                        $newOrderCompilation[$key][$orderKey] = null;
                    }
                }
            }
 
            $newOrders = Order::insert($newOrderCompilation);

            $newOrderList = Order::with('orders_meta')->orderBy('id','DESC')->take(count($newOrderCompilation))->get();
            $comparisons = [];
            foreach($newOrderList as  $newOrder){
                //clone the order art for each order with a product
                if($newOrder->proof_url !== null){
                    if(isset($uploadedData['id_'.$newOrder->shopify_id])){
                        foreach($uploadedData['id_'.$newOrder->shopify_id] as $file){

                            $newOrderArt = new OrderArt;
                            $newOrderArt->order_id = $newOrder->id;
                            $newOrderArt->aws_key = '';
                            $newOrderArt->filename = basename(strtok($file,'?'));
                            $newOrderArt->file_url = $file; 

                            $newOrderArt->save();

                        }
                    }


                }
                $hasProductMatch = false;

                $productGroupID = null;

                foreach($orderProductMatches as $check){
                    if($check[1].'' === $newOrder->shopify_id.''){
                        $hasProductMatch = true;
                        $productGroupID = $check[0];
                    }
                }

                AccessCode::create([
                    'order_id' => $newOrder->id,
                    'code' => md5(microtime(true))
                ]);

            
                
                if($hasProductMatch){
                    foreach($ordersList as $shopifyOrder){
                        if($shopifyOrder->line_items[0]->id.'' === $newOrder->shopify_id.''){
                            //the ID of the first line item is the foreign DB identifier on our end
                            //product group = product group ID here, variant = product ID (to clarify)
                            //we're also going to only get the first product's data for reference
                            $productGroupID = @$shopifyOrder->line_items[0]->product_id;
                            $productID = @$shopifyOrder->line_items[0]->variant_id;
                            $productGroupData = ProductGroup::where(['foreign_db_id' => $productGroupID, 'integration_id' => $shop->id])->first();
                            $productData = Product::where(['foreign_db_id' => $productID, 'integration_id' => $shop->id])->first();
    
                            OrderDetails::create([
                                'order_id' => $newOrder->id,
                                'product_group_id' => $productGroupData->id,
                                'product_id' => $productData->id
                            ]);
                        }
                    }             
    
                    $orderArts = OrderArt::where(['order_id' => $productGroupID, 'table_name' => 'products'])->get();

                    foreach($orderArts as $unit)
                    {
                        $unit->replicate();
                        $unit->order_id =  $newOrder->id;
                        $unit->table_name = 'orders';
                        $unit->save();
                    }
                }            

            
                foreach($upsertOrderMetaData as $key2 => $uomd){
                   
                    $comparisons[count($comparisons)] = [$newOrder->shopify_id.'' , @$uomd['shopify_id'].''];
                    if($newOrder->shopify_id.'' === @$uomd['shopify_id'].''){
                        $upsertOrderMetaData[$key2]['order_id'] = $newOrder->id;    
                        if(isset($uomd['line_item_index'])){
                            $decodedData = json_decode($uomd['shopify_metadata']);
                            Order::where(['id' => $newOrder->id])->update(['shopify_id' => $decodedData->id]);
                        }
                    }
                }
            }
                      
            foreach($upsertOrderMetaData as $key2 => $uomd){
                unset($upsertOrderMetaData[$key2]['shopify_id']);
                unset($upsertOrderMetaData[$key2]['line_item_index']);
            }
            $ordersMetaFromShopify->upsert($upsertOrderMetaData, ['order_id'], ['shopify_metadata', 'integration_id']);
        } catch(\Exception $e){
            return ['status' => false, 'message' => "Failed to sync Shopify orders: Reason: ". $e->getMessage(), 'error' => $e->getTrace(), 'order_compilation' => @$newOrderCompilation];
        }

    endforeach;

    return ['status' => true, 'message' => 'Successfully synced Shopify orders.'];

    }

    public function getEtsyShippingCarriers($integration,$accessToken){

        $client = new Guzzle\Client([
            'verify' => false,
            'headers' => [
                'x-api-key' => $integration->etsy_client_id
            ]
        ]);

        try {
            $shippingCarriers = $client->get('https://openapi.etsy.com/v3/application/shipping-carriers?origin_country_iso=US',[
                'form_params' => ['origin_country_iso' => 'US'],
                'headers' => [
                    'x-api-key' => $integration->etsy_client_id
                ] 
            ]);
            return json_decode($shippingCarriers->getBody()->getContents())->results;
        }catch(\Exception $e){
            return $e->getMessage();
        }
        
    }
    public function getEtsyShoppingProfiles($integration,$accessToken){

        $client = new Guzzle\Client([
            'verify' => false,
            'headers' => [
                'x-api-key' => $integration->etsy_client_id
            ]
        ]);

        try {

           $shippingProfiles = $client->get('https://openapi.etsy.com/v3/application/shops/'. $integration->etsy_shop_id .'/shipping-profiles',[
                'form_params' => [],
                'headers' => [
                    'Authorization' => 'Bearer ' . $accessToken,
                    'x-api-key' => $integration->etsy_client_id
                ] 
            ]);
            return json_decode($shippingProfiles->getBody()->getContents())->results;
        }catch(\Exception $e){
            return $e->getMessage();
        }
        
    }

    public function etsyOrderSync(Request $request, $fromExistingRefreshToken = false, $accessToken = null){ 
        DB::enableQueryLog();

        if(env('ETSY_ENABLED')){

            if(!$fromExistingRefreshToken){

                //get integration details, and then the client ID

                $integration = $shop = ShopifyIntegration::where(['id' => session('integration_id')])->first();

                $client = new Guzzle\Client([
                    'verify' => false,
                    'headers' => [
                        'x-api-key' => $integration->etsy_client_id
                    ]
                ]);
                $etsyClient = new Etsy(env('ETSY'));
                $accessToken = $client->post("https://api.etsy.com/v3/public/oauth/token",[
                    'form_params' => [
                        'grant_type' => 'authorization_code',
                        'client_id' => $integration->etsy_client_id,
                        'redirect_uri' => env('ETSY_REDIRECT'),
                        'code' => $request->get('code'),
                        'code_verifier' => $request->session()->get('verifier')
                    ]
                ]);
                $accessToken = json_decode($accessToken->getBody()->getContents());
            } 

            ShopifyIntegration::where(['id' => session('integration_id')])->update(['auth_code_data' => json_encode($accessToken)]);

            $orderUrl = "https://openapi.etsy.com/v3/application/shops/". $integration->etsy_shop_id ."/receipts?api_key=" . $integration->etsy_client_id;


            $orderReceipts = $client->get($orderUrl.'was_canceled=false&limit=100',[
                'body' => json_encode([
             
                ]),
                'headers' => [
                    'Authorization' => 'Bearer ' . $accessToken->access_token,
                    'x-api-key' => $integration->etsy_client_id
                ] 
            ]);

            $orderReceipts = json_decode($orderReceipts->getBody()->getContents());  

            $deletedOrderReceipts =  $client->get($orderUrl.'&was_canceled=true&limit=100',[
                'body' => json_encode([
                   
                ]),
                'headers' => [
                    'Authorization' => 'Bearer ' . $accessToken->access_token,
                    'x-api-key' => env('ETSY')
                ] 
            ]);

            $deletedOrderReceipts = json_decode($deletedOrderReceipts->getBody()->getContents()); 

            $compiledReceiptIDs = [];

            $compiledWhereQueryToDelete = new OrderMeta;

            $firstInQueryIsDone = false;


            foreach($deletedOrderReceipts->results as $receipt){
                if($firstInQueryIsDone){
                    $firstInQueryIsDone = true;
                    $compiledWhereQueryToDelete = $compiledWhereQueryToDelete->where('etsy_metadata','like','%'. $receipt->receipt_id .'%');
                }else{
                    $compiledWhereQueryToDelete = $compiledWhereQueryToDelete->orWhere('etsy_metadata','like','%'. $receipt->receipt_id .'%');
                } 
            } 

            $compiledWhereQueryToDelete->delete();

            foreach($orderReceipts->results as $receipt){
                $receipt = (object) $receipt;
                $compiledReceiptIDs[count($compiledReceiptIDs)] = $receipt->receipt_id;
            }

        }else{
            //dummy sample response  
            $orderReceipts = (object) $this->sampleReceiptList();
        }

        //get orders with matching etsy ID's

        $receipts = $orderReceipts->results;

        foreach($receipts as $receipt){
            $receipt = (object) $receipt;
            $compiledReceiptIDs[count($compiledReceiptIDs)] = $receipt->receipt_id;
        }

        //get all orders with these etsy ID's

        $ordersFromEtsy = Order::withTrashed()->where('etsy_id','like',$receipts[0]->receipt_id.'%');

        $shippingProfiles = $this->getEtsyShoppingProfiles($integration,$accessToken->access_token);
        $shippingCarriers = $this->getEtsyShippingCarriers($integration,$accessToken->access_token);


        foreach($receipts as $i => $receipt){
            if(intval($i) > 0){
                $ordersFromEtsy = $ordersFromEtsy->orWhere('etsy_id','like',$receipt->receipt_id.'%');
            }
        }

        $ordersFromEtsy = $ordersFromEtsy->get();

        $orderIDCompilation = [];

        $upsertData = ['insert' => [], 'update' => []];

        $upsertOrderMetaData = [];

        foreach($receipts as $receipt){

            unset($userCheck);

            $receipt = (object) $receipt;

            //move to the next receipt if this receipt's status is cancelled

            if($receipt->status === 'Canceled'){
                continue;
            }

            //create user if it doesn't exist

            //The buyer is the relevant ID. If there is no buyer ID, the seller will be the email ID instead.

            $dummyCustomer = User::where(['id' => env('DUMMY_CUSTOMER_ID')])->first();

            //since the email address doesn't exist anymore, the identifier will be the buyer user ID

            $customerEmail = 'user_'.$receipt->buyer_user_id.'@etsy.com';

            $userCheck = User::where(['email' => $customerEmail])->get();

            if(count($userCheck) === 0){
                //create new user

                //try {
                    $user = new User;
                    $user->role = 'Etsy_Customer';
                    $user->password = bcrypt('pass1234');
                    $user->first_name = "". @explode(' ', trim(@$receipt->name ))[0];
                    $user->last_name = "". @explode(' ', trim(@$receipt->name ))[1];
                    $user->company = '';
                    $user->street_appartment = $request->street_appartment;
                    $user->created_by = 1;
                    $user->email = $customerEmail;
                    $user->status = 1;
                    $user->terms = '';
                    $user->sales_tax_enabled = '';
                    $user->sales_tax = '';
                    $user->sms_required = '';
                    $user->state = @$receipt->state;
                    $user->contact_number = '3109169514';
                    $user->shipping_phone = '3109169514';
                    $user->shipping_city = @$receipt->city;
                    $user->city = @$receipt->city;
                    $user->zipcode = @$receipt->zip;
                    $user->shipping_name = explode(' ', trim(@$receipt->name ))[0];
                    $user->shipping_state = @$receipt->state;
                    $user->shipping_last_name = @$user->last_name;
                    $user->shipping_address = @$receipt->first_line;
                    $user->address = @$receipt->first_line;
                    $user->shipping_street_appartment = @$receipt->second_line;
                    $user->street_appartment = @$receipt->second_line;
                    $user->shipping_email = @$receipt->buyer_email;
                    $user->shipping_zipcode = @$receipt->zip;
                    $user->etsy_id = @$receipt->buyer_user_id;

                    $user->save();

                // }catch(\Exception $e){

                // }

            }

            $creatorID = @auth()->user()->id;

            //check if the shop owner's data is available 


            if(@$shop->shop_metadata['user_data']['primary_email'] !== null){

                //check to see if this user's email was already registered as a user

                $creatorUserCheck = User::where(['email' => @$shop->shop_metadata['user_data']['primary_email']])->first();


                if($creatorUserCheck === null){

                    //create this user's data

                    $creatorUser = new User;
                    $creatorUser->role = 'Shop_Owner';
                    $creatorUser->password = bcrypt('^^^%!@#$%^&*()*&^^%$#');
                    $creatorUser->first_name = "". @explode(' ', trim(@$shop->shop_metadata['shop_email'] ))[0];
                    $creatorUser->last_name = "". @explode(' ', trim(@$shop->shop_metadata['shop_owner'] ))[1];
                    $creatorUser->email = $shop->shop_metadata['user_data']['primary_email'];
                    $creatorUser->save(); 

                    $creatorID = $creatorUser->id;
                }else{
                    $creatorID = $creatorUserCheck->id;
                }

            }

            //check to see if an order exists with a receipt ID

            $hasMatchingOrder = false;
            $orderOnQue = null;

            foreach($ordersFromEtsy as $importedOrder){
                if(str_contains($importedOrder->etsy_id,$receipt->receipt_id.'')){
                    $hasMatchingOrder = true;
                    $orderOnQue = $importedOrder;
                    $orderIDCompilation[count($orderIDCompilation)] = $importedOrder->id;
                }
            }

            $newOrCurrentStatus = $hasMatchingOrder ? $orderOnQue->status : 'Processing';

            $keyword = $hasMatchingOrder ? 'update' : 'insert';

            //check to see that this order isn't deleted

            $deletedCheck = Order::where(['etsy_id' => $receipt->receipt_id])->onlyTrashed()->get();

            if(count($deletedCheck) > 0){
                continue;
            }

            $designatedShipType = null;

            $shipTypes = [
                 "pickup", 
                 "courier", 
                 "hand_deliver", 
                 "shipping_others", 
                 "USPS First Class Mail", 
                 "USPS Media Mail", 
                 "USPS Parcel Select Ground", 
                 "USPS Priority Mail", 
                 "USPS Priority Mail Express", 
                 "FedEx Ground", 
                 "FedEx Home Delivery", 
                 "FedEx 2Day", 
                 "FedEx 2Day A.M.", 
                 "FedEx Express Saver", 
                 "FedEx Standard Overnight", 
                 "FedEx Priority Overnight", 
                 "FedEx First Overnight", 
                 "FedEx 1Day Freight", 
                 "FedEx 2Day Freight", 
                 "FedEx 3Day Freight", 
                 "FedEx First Overnight Freight", 
                 "Provided Label", 
                 "UPS Ground", 
                 "UPS 3 Day Select", 
                 "UPS 2nd Day Air", 
                 "UPS Next Day Air Saver", 
                 "UPS Next Day Air", 
                 "UPS Next Day Air Early", 
                 "UPS 2nd Day Air AM" 
            ]; 

            foreach($shipTypes as $st){
                if(preg_match("#". $st ."#",@$receipt->transactions[0]->shipping_upgrade)){
                    $designatedShipType = $st;
                }
            }

            $timestampToModify = $receipt->create_timestamp;
            $receipt->transactions[0]->title = html_entity_decode($receipt->transactions[0]->title, ENT_QUOTES);
            $upsertData[$keyword][count($upsertData[$keyword])] = [
                'etsy_id' => $receipt->receipt_id.'',
                'customer_id' =>  @$userCheck[0]->id !== null ? $userCheck[0]->id : @$user->id,
                'created_by' => $creatorID,
                'hard_due_date' => 1,
                'name' => strlen($receipt->transactions[0]->title) > 25 ? substr($receipt->transactions[0]->title,0,25)."..." : $receipt->transactions[0]->title,
                'type' => 'screen_printing',
                'arrival_type' => '7_10_days',
                'tax_1' => 0,
                'tax_2' => 0,
                'tax_3' => 0,
                'tax_4' => 0,
                'tax_5' => 0,
                'arrival_date' => $receipt->transactions[0]->expected_ship_date !== null ? DB::Raw('FROM_UNIXTIME('. $receipt->transactions[0]->expected_ship_date .')') : null,
                "created_at" => $receipt->transactions[0]->created_timestamp !== null ? DB::Raw('FROM_UNIXTIME('. $receipt->transactions[0]->created_timestamp .')') : null,
                "customer_name" => $receipt->name,
                "customer_notes" => $receipt->message_from_buyer,
                "customer_address" => $receipt->first_line,
                "customer_city" => $receipt->city,
                "customer_state" => $receipt->state,
                "customer_zipcode" => $receipt->zip,
                "customer_email" => $customerEmail,
                "pay" => $receipt->is_paid ? 1 : 0,
                "shipped_date" => $receipt->is_shipped ? DB::Raw('NOW()') : null,
                "status" => $newOrCurrentStatus,
                "invoice_number" => $receipt->receipt_id,
                "shipping_instructions" => @$receipt->transactions[0]->shipping_upgrade !== null ? @$receipt->transactions[0]->shipping_upgrade : 'No Shipping Data Available.',
                "ship_type" => $designatedShipType
            ];  

            if($hasMatchingOrder){
                $upsertData[$keyword][count($upsertData[$keyword])-1]['id'] = $orderOnQue->id;
            }

            $upsertOrderMetaData[count($upsertOrderMetaData)] = [
                'etsy_metadata' => json_encode($receipt),
                'receipt_id' => $receipt->receipt_id,
                'integration_id' => session('integration_id')
            ];            

            //search for any applicable SKU

            $skuList = [];

            $sku = '';

            $firstCount = true;

            $preProductOrderDetails = $upsertData[$keyword][count($upsertData[$keyword])-1];

            $orderKeyList = $this->orderKeyList();

            $comparisons = [];

            foreach($receipt->transactions as $i => $transaction){
                $sku = $transaction->sku;

                $skuList[count($skuList)] = $sku;
                $receipt->this_transaction = $transaction;
                $receipt->transactions[$i]->title = html_entity_decode($receipt->transactions[$i]->title, ENT_QUOTES);
                $upsertData[$keyword][count($upsertData[$keyword])-1]['name'] = $receipt->transactions[$i]->title;

                //check that this SKU wasn't already here (to prevent duplicates)

                foreach($skuList as $currentSku){
                    if($currentSku.'' === $sku.''){
                        continue;
                    }
                }

                $shippingProfileData = new \stdClass; 
                $shippingCarrier = new \stdClass;
                $hasShippingProfileMatch = false;
                $hasCarrierMatch = false;
                $shippingLabelToDisplay = $transaction->shipping_upgrade;
                foreach($shippingProfiles as $shippingProfile){
                    if($shippingProfile->shipping_profile_id.'' === $transaction->shipping_profile_id.''){
                        $hasShippingProfileMatch = true;
                        $shippingProfileData = $shippingProfile;
                        $amount = $receipt->total_shipping_cost->amount;
                        if($amount > 0){
                            $amount = $amount / 100;
                        }
                        $shippingLabelToDisplay = $shippingProfile->title . " - $" . $amount;
                        foreach($shippingCarriers as $carrier){
                            if($carrier->shipping_carrier_id.'' === $shippingProfile->shipping_profile_destinations[0]->shipping_carrier_id.''){
                                $hasCarrierMatch = true;
                                $shippingCarrier = $carrier;
                                
                                $shippingLabelToDisplay .= " (Carrier ID: ". $carrier->shipping_carrier_id .")";
                            }
                        }
                        if($transaction->shipping_upgrade !== null){
                            $shippingLabelToDisplay .= " (Upgrade: ". $transaction->shipping_upgrade .")";
                        }
                    }
                }
                $upsertData[$keyword][count($upsertData[$keyword])-1]['proof_notes'] = $shippingLabelToDisplay;

                $upsertData[$keyword][count($upsertData[$keyword])-1]['etsy_id'] = $receipt->receipt_id.'-'.$sku;

                /* $upsertData[$keyword][count($upsertData[$keyword])-1]['other_size_3_1'] = 'one_size';
                $upsertData[$keyword][count($upsertData[$keyword])-1]['other_size_text_3_1'] = $transaction->quantity; */

                //synchronize product data

                $productCheck = Product::where('sku',$sku)->get();
                $test[] = $productCheck;
                if(count($productCheck) > 0){

                    if(!$firstCount){
                        //make a copy of the order before product sync, as a prototype for each succeeding line item
                        $upsertData[$keyword][count($upsertData[$keyword])] = $preProductOrderDetails;
                        $receipt->sku = $sku;
                        $upsertOrderMetaData[count($upsertOrderMetaData)] = [
                            'etsy_metadata' => json_encode($receipt),
                            'receipt_id' => $receipt->receipt_id.'-'.$sku
                        ];

                        $upsertData[$keyword][count($upsertData[$keyword])-1]['etsy_id'] = $receipt->receipt_id.'-'.$sku;

                    }

                    $upsertData[$keyword][count($upsertData[$keyword])-1]['name'] = $productCheck[0]->product_name;

                    //match the data
                    $upsertData[$keyword][count($upsertData[$keyword])-1]['proof_url'] = $productCheck[0]->proof_url;
                    $upsertData[$keyword][count($upsertData[$keyword])-1]['type'] = $productCheck[0]->order_type;
                    $upsertData[$keyword][count($upsertData[$keyword])-1]['setup_name'] = $productCheck[0]->setup_costs;
                    $upsertData[$keyword][count($upsertData[$keyword])-1]['art_notes'] = $productCheck[0]->upload_notes;
                    $upsertData[$keyword][count($upsertData[$keyword])-1]['position_front'] = $productCheck[0]->front_desc;
                    $upsertData[$keyword][count($upsertData[$keyword])-1]['position_back'] = $productCheck[0]->back_desc;
                    $upsertData[$keyword][count($upsertData[$keyword])-1]['position_right_left'] = $productCheck[0]->right_left_desc;
                    $upsertData[$keyword][count($upsertData[$keyword])-1]['position_additional'] = $productCheck[0]->additional_desc;
                    $upsertData[$keyword][count($upsertData[$keyword])-1]['position_notes'] = $productCheck[0]->notes_desc;
                    $upsertData[$keyword][count($upsertData[$keyword])-1]['product_id'] = $productCheck[0]->id;

                    $upsertData[$keyword][count($upsertData[$keyword])-1]['extra_services'] = $productCheck[0]->extra_services;
                    $upsertData[$keyword][count($upsertData[$keyword])-1]['full_color_count'] = $productCheck[0]->full_color_count;
                    $upsertData[$keyword][count($upsertData[$keyword])-1]['placements'] = $productCheck[0]->placements;
                    
                    //Temporarily store the product group id in Access_code column
                    $upsertData[$keyword][count($upsertData[$keyword])-1]['access_code'] = $productCheck[0]->product_group_id;



                    for($i = 1; $i <= 5; $i++) {

                        $upsertData[$keyword][count($upsertData[$keyword])-1]['product_apparel_source_'.$i] = $productCheck[0]->{'pdesc'.$i.'_source'} ;
                        $upsertData[$keyword][count($upsertData[$keyword])-1]['product_apparel_source_other_'.$i] = $productCheck[0]->{'pdesc'.$i.'_other'} ;
                        $upsertData[$keyword][count($upsertData[$keyword])-1]['per_piece_'.$i] = $productCheck[0]->{'pdesc'.$i.'_price'};
                        $upsertData[$keyword][count($upsertData[$keyword])-1]['tax_'.$i] = isset($productCheck[0]->{'pdesc'.$i.'_tax'}) && $productCheck[0]->{'pdesc'.$i.'_tax'} == 'true' ? 'true' : 'false';
                        $upsertData[$keyword][count($upsertData[$keyword])-1]['item_number_'.$i] = $productCheck[0]->{'pdesc'.$i.'_item_num'};
                        $upsertData[$keyword][count($upsertData[$keyword])-1]['apparel_type_'.$i] = $productCheck[0]->{'pdesc'.$i.'_style'} ;
                        $upsertData[$keyword][count($upsertData[$keyword])-1]['location_'.$i] = $productCheck[0]->{'pdesc'.$i.'_location'} ;
                        $upsertData[$keyword][count($upsertData[$keyword])-1]['product_color_'.$i] = $productCheck[0]->{'pdesc'.$i.'_color'} ;
                        $upsertData[$keyword][count($upsertData[$keyword])-1]['brand_name_'.$i] = $productCheck[0]->{'pdesc'.$i.'_brandname'};
                        $upsertData[$keyword][count($upsertData[$keyword])-1]['product_user_type_'.$i] = $productCheck[0]->{'pdesc'.$i.'_body'} ;
                        $upsertData[$keyword][count($upsertData[$keyword])-1]['product_description_'.$i] = $productCheck[0]->{'pdesc'.$i.'_desc'} ;
                        $upsertData[$keyword][count($upsertData[$keyword])-1]['other_size_4_'.$i] = $productCheck[0]->{'pdesc'.$i.'_size'};
                        if($transaction->quantity === null){
                            $upsertData[$keyword][count($upsertData[$keyword])-1]['other_size_text_4_'.$i] = $productCheck[0]->{'pdesc'.$i.'_quantity'} ;
                        }
                        $size = $productCheck[0]->{'pdesc'.$i.'_'.'size'};         
                        $checkIfEmptyColumns = ['arrival_type','arrival_other','hard_due_date'];
                        //by default, +7 days



                        foreach($checkIfEmptyColumns as $columnToVerify){
                            if($productCheck[0]->{$columnToVerify}.'' !== ''){
                                if($columnToVerify === 'arrival_type'){
                                    switch($productCheck[0]->{$columnToVerify}){
                                        case "7_10_days":
                                            $upsertData[$keyword][count($upsertData[$keyword])-1]['arrival_date'] = DB::Raw('FROM_UNIXTIME('.$timestampToModify.') + INTERVAL 7 DAY');
                                        break;
                                        case "5_business_days":
                                            $upsertData[$keyword][count($upsertData[$keyword])-1]['arrival_date'] = DB::Raw('FROM_UNIXTIME('.$timestampToModify.') + INTERVAL 5 DAY');
                                        break;
                                        case "eow":
                                            $nextFriday = strtotime('next friday');
                                            $upsertData[$keyword][count($upsertData[$keyword])-1]['arrival_date'] = DB::Raw('FROM_UNIXTIME('.$nextFriday.')');
                                        break;
                                        case "3_days":
                                            $upsertData[$keyword][count($upsertData[$keyword])-1]['arrival_date'] = DB::Raw('FROM_UNIXTIME('.$timestampToModify.') + INTERVAL 3 DAY');
                                        break;
                                    }
                                }
                                $upsertData[$keyword][count($upsertData[$keyword])-1][$columnToVerify] = $productCheck[0]->{$columnToVerify};
                            }
                        } 

                        //color columns are identical

                        $colorColumns = ["color_1","color_2","color_3","color_4","color_5","color_6","color_1_pantone","color_2_pantone","color_3_pantone","color_4_pantone","color_5_pantone","color_6_pantone"];

                        foreach($colorColumns as $column){
                            $upsertData[$keyword][count($upsertData[$keyword])-1][$column] = $productCheck[0]->{$column};
                        }

                    }                
                    $allData = [

                        'product' => $productCheck[0],
                        'upsertData' => $upsertData[$keyword][count($upsertData[$keyword])-1]

                    ];
                }else{
                    if($firstCount){
                        $upsertOrderMetaData[count($upsertOrderMetaData)] = [
                            'etsy_metadata' => json_encode($receipt),
                            'receipt_id' => $receipt->receipt_id,
                            'integration_id' => session('integration_id')
                        ];
                    }else{
                        $upsertOrderMetaData[count($upsertOrderMetaData)-1] = [
                            'etsy_metadata' => json_encode($receipt),
                            'receipt_id' => $receipt->receipt_id,
                            'integration_id' => session('integration_id')
                        ];
                    }
                    
                } 

                if($firstCount){
                    $firstCount = false;
                } 

                foreach($orderKeyList as $key){
                    if(!isset($upsertData[$keyword][count($upsertData[$keyword])-1][$key])){
                        $upsertData[$keyword][count($upsertData[$keyword])-1][$key] = null;
                    }
                } 
            }    

            foreach($orderKeyList as $key){
                if(!isset($upsertData[$keyword][count($upsertData[$keyword])-1][$key])){
                    $upsertData[$keyword][count($upsertData[$keyword])-1][$key] = null;
                }
            }           

        }
        
        //make orders meta 

        $orderProductMatches = [];

        $ordersMetaFromEtsy = OrderMeta::whereIn('order_id',$orderIDCompilation);

        foreach($upsertData['insert'] as $key => $data){
            if(isset($data['product_id'])){
                $orderProductMatches[count($orderProductMatches)] = [$data['product_id'],$data['etsy_id']];
                unset($upsertData['insert'][$key]['product_id']);
            }
        }

        foreach($upsertData['update'] as $key => $data){
            if(isset($data['product_id'])){
                unset($upsertData['update'][$key]['product_id']);
            }
        }

        //return $upsertData['insert'];

        $newOrders = Order::insert($upsertData['insert']);

        

        $newOrderList = Order::orderBy('id','DESC')->take(count($upsertData['insert']))->get();

        foreach($newOrderList as $key => $order){
            //clone the order art for each order with a product

            $hasProductMatch = false;

            $productGroupID = null;

            AccessCode::create([
                'order_id' => $order->id,
                'code' => md5(microtime(true))
            ]);

            OrderDetails::create([
                'order_id' => $order->id,
                'product_group_id' => $order->access_code
            ]);

            //delete Temporary product_group_id from order
            $order->access_code = null;

            foreach($orderProductMatches as $check){
                if($check[1].'' === $order->etsy_id.''){
                    $hasProductMatch = true;
                    $productGroupID = $check[0];
                }
            }

            if($hasProductMatch){
               
                $orderArts = OrderArt::where(['order_id' => $productGroupID, 'table_name' => 'products'])->get();


                foreach($orderArts as $unit)
                {
                    $unit->replicate();
                    $unit->order_id =  $order->id;
                    $unit->table_name = 'orders';
                    $unit->save();
                }
            }           
            
            $order->save();

        }

        
        //Order::upsert($upsertData['update'], ['etsy_id'], $this->orderKeyList());

        $ordersFromEtsy = Order::where('etsy_id','like',$receipts[0]->receipt_id.'%');

        foreach($receipts as $i => $receipt){
            if(intval($i) > 0){
                $ordersFromEtsy = $ordersFromEtsy->orWhere('etsy_id','like',$receipt->receipt_id.'%');
            }
        }

        $ordersFromEtsy = $ordersFromEtsy->get();



        foreach($upsertOrderMetaData as $key => $uomd){
            
            foreach($ordersFromEtsy as $order){
                if(str_contains($order->etsy_id,$upsertOrderMetaData[$key]['receipt_id'].'')){
                    $upsertOrderMetaData[$key]['order_id'] = $order->id;    
                }
            }

            unset($upsertOrderMetaData[$key]['receipt_id']);
        }

        $ordersMetaFromEtsy->upsert($upsertOrderMetaData, ['order_id'], ['etsy_metadata', 'integration_id']);

        

        return "
            <script type='text/javascript'>
                setTimeout(()=>{
                    window.self.close();
                },100);
            </script>
        ";
    }

    public function GetPrintJobs(Request $request, $type) {

        $getprintjob=DB::table('print_jobs')->where('type',$type)->get();
        
       
        return response([
            'code' => 200,
            'success' => true,
            'message' => 'Print Job List',
            'data' => $getprintjob
        ]);

    }

    public function DeletePrintJob(Request $request)
    {

        $pid=$request->id;
        $type=$request->type;
        $deleted = DB::table('print_jobs')->where('order_id', $pid, 'type', $type)->delete();
        return response([
            'code' => 200,
            'success' => true,
            'message' => 'data deleted'
        
        ]);

    }
    
    public function CreatePrintJobs(Request $request) {
        $validator = Validator::make($request->all(), [
            'order_id' => 'required',
            'url' => 'required',
            'useremail' =>   'required',
            'type' =>   'required'      
        ]);

        if ($validator->fails()) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => Misc::FirstValidationMessage($validator->errors()),
                'errors' => $validator->errors()
            ]);
        }

        $PrintJob = new PrintJob;

        $PrintJob->order_id = $request->order_id;
        $PrintJob->url = $request->url;
        $PrintJob->useremail = $request->useremail;
        $PrintJob->type = $request->type;
      
        $order = Order::find($request->order_id)->first();

        if($PrintJob->save()) {

            ActivityNotif::create([
                'order_id' => $request->order_id,
                'title' => 'Apparel Received for ' . $request->order_id,
                'description' => 'Updated by'. $order->name,
                'initiated_by' => $order->created_by,
                'action' => 'apparel_received',
                'type' => 'admin' 
            ]);

            $PrintJobid = $PrintJob->id;

            return response([
                'code' => 200,
                'success' => true,
                'message' => 'New PrintJob created.',
                'data' => $PrintJob               
            ]);

        }
        else 
        {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }


    }

    public function OrdersList(Request $request) {

        DB::enableQueryLog();

        $query = Order::with('order_arts')->leftJoin('printers', 'orders.printer_id', '=', 'printers.id')
            ->leftJoin('users', 'orders.customer_id', '=', 'users.id')
            //->leftJoin('orders_meta', 'orders.id', '=', 'orders_meta.order_id')
            ;

        $type = $request->type;



        if(isset($request->title)) {
            $query = $query->where(function($q) use ($request, $type) {
                $q->orWhere('orders.name', 'LIKE', '%'.$request->title.'%');
                $q->orWhere('orders.id', 'LIKE', '%'.$request->title.'%');
                $q->orWhere('users.first_name', 'LIKE', '%'.$request->title.'%');
                $q->orWhere('users.last_name', 'LIKE', '%'.$request->title.'%');
                $q->orWhere('orders.invoice_number', 'LIKE', '%'.$request->title.'%');

                if(isset($type) && $type == "purchasing") {
                    $q->orWhere('orders.po_number', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_apparel_source_1', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_apparel_source_2', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_apparel_source_3', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_apparel_source_4', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_apparel_source_5', 'LIKE', '%'.$request->title.'%');

                    $q->orWhere('orders.item_number_1', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.item_number_2', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.item_number_3', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.item_number_4', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.item_number_5', 'LIKE', '%'.$request->title.'%');

                    $q->orWhere('orders.product_color_1', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_color_2', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_color_3', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_color_4', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_color_5', 'LIKE', '%'.$request->title.'%');
                }
            });
        }

        if(isset($request->customer_id)) {
            $query = $query->where('orders.customer_id', $request->customer_id);
        }

        if(isset($request->startCalendarDate) && isset($request->endCalendarDate) ) {

            $query = $query->where(function($q) use ($request, $type) {
                $q->whereDate('orders.arrival_date', '>=', $request->startCalendarDate);
                $q->whereDate('orders.arrival_date', '<=', $request->endCalendarDate);
            });
        }


        if(isset($request->startCalendarDate) && isset($request->endCalendarDate) && isset($request->calendar)) {

            $query = $query->where(function($q) use ($request, $type) {
                $q->whereDate('orders.arrival_date', '>=', $request->startCalendarDate);
                $q->whereDate('orders.arrival_date', '<=', $request->endCalendarDate);
            });
        }


        if(isset($request->apparel)) {
            $query = $query->where('orders.apparel', $request->apparel);
        }

        if(isset($request->sale_id)) {
            $query = $query->where('orders.created_by', $request->sale_id);
        }

        if(isset($request->print_date)) {
            $query = $query->where('orders.print_date', $request->print_date);
        }

        if(isset($request->film_status)) {
            if($request->film_status == 'not_added') {
                $query = $query->where('orders.film', false);
            } else if($request->film_status == 'film_added') {
                $query = $query->where('orders.film', true);
            } else if($request->film_status == 'all_orders') {
                $query = $query->where('orders.status', 'Processing');
            }
        }

        if(isset($request->printer_id)) {
            $query = $query->where('orders.printer_id', $request->printer_id);
        }

        // Production, Completed, Processing
        if(isset($request->order_status)) {
            $query = $query->where('orders.status', $request->order_status);
        }

        if(isset($request->order_type)) {
           /*  $query = $query->where('orders.type', $request->order_type); */
           
           switch($request->order_type){
            case "screen_printing":
                $query->whereIn('orders.type', ['screen_printing','screen_and_embroidery','screen_and_dtg','screen_and_dtf']);
            break; 
            case "direct_to_garment":
                $query->whereIn('orders.type', ['direct_to_garment','screen_and_dtg']);
            break;
            case "embroidery":
                $query->whereIn('orders.type', ['embroidery','screen_and_embroidery']);
            break; 
            case "dtf":
                $query->whereIn('orders.type', ['dtf','screen_and_dtf']);
            break; 
            case "vynil":
                $query->whereIn('orders.type', ['vynil']);
            break; 
            case "dyesub":
                $query->whereIn('orders.type', ['dyesub']);
            break; 
            case "screen_and_embroidery":
                $query->whereIn('orders.type', ['embroidery','screen_and_embroidery']);
            break; 
            case "screen_and_dtg":
                $query->whereIn('orders.type', ['direct_to_garment','screen_and_dtg']);  
            break; 
            case "screen_and_dtf":
                $query->whereIn('orders.type', ['dtf','screen_and_dtf']);
            break;  
            case "order_others":
                $query->whereIn('orders.type', ['order_others']);
            break;  
        } 
        }


        switch(auth()->user()->role){
            case "Sales":
                $query = $query->where('orders.created_by', auth()->user()->id);
            break;
            case "Trader":
                $getUserId = User::whereStatus(1)->where('created_by',auth()->user()->id)->get('id');         
                $query = $query->where(function($sqlquery) use($getUserId){
                    $sqlquery->whereIn('orders.created_by',  $getUserId)->orWhere('orders.created_by', auth()->user()->id)
                    ->orWhere('orders.trader_printer_id', auth()->user()->id);
                });

            break;
            case "Admin":
                $trader = User::where('role', 'Trader')->whereStatus(1)->get('id');
                $traderUserId = User::whereStatus(1)->whereIn('created_by',$trader)->get('id'); 
 
                $query = $query->where(function($sqlquery) use($trader, $traderUserId){
                    $sqlquery->whereNull('orders.trader_printer_id')->whereNotIn('orders.created_by', $trader)->whereNotIn('orders.created_by', $traderUserId)
                    ->orWhere('orders.resource_admin', ['5']);
                });
            break;
            case "Etsy_Admin":
                $etsyUsers = User::where('role', 'Etsy_Admin')->get('id');
                $query = $query->whereIn('orders.created_by', $etsyUsers);
            break;
            case "Production":
                $query = $query->where('orders.status', 'Production');
            break;
            case "Customer":
                $query = $query
                         ->where(function($query){
                            $query->where('orders.customer_id',auth()->user()->id)
                                  ->orWhere('orders.created_by', auth()->user()->id);
                         });
                               
            break;
        } 
        
        
        if(isset($request->date_order)) {
            $query = $query->whereDate('orders.created_at','>=' ,\Carbon\Carbon::now()->subDays($request->date_order));
        }

        if(auth()->user()->role == 'Sales') {
            $query = $query->where('orders.created_by', auth()->user()->id);
        }

        if(auth()->user()->role == 'Production') {
            $query = $query->where('orders.status', 'Production');
        }

        if(isset($request->in)){
            $ids = explode(",",$request->in);

            $query->whereIn('orders.id',$ids);

        }

        $query = $query->select(['orders.*', 'printers.title as printer_name'])->orderBy('orders.arrival_date', 'ASC');

        $data = $query->get();

        $idsToFetch = [];

        $returned = [
            'code' => 200,
            'success' => true,
            'message' => 'Orders List.',
            'data' => $data
        ];

        if($request->get('with_labels') !== null){
            $pastLabels = PastLabels::whereIn('order_id',$idsToFetch)->get();

            $returned['labels'] = new stdClass;

            foreach($pastLabels as $label){
                if(!isset($returned['labels']->{'for_'.$label->order_id})){
                    $returned['labels']->{'for_'.$label->order_id} = [];
                }

                array_push($returned['labels']->{'for_'.$label->order_id},$label);
            }

        }

        

        return response($returned);
    }

    public function UpdateOrderDetailsForShipstation(){

        $shipStation = app(\LaravelShipStation\ShipStation::class);

        $shipStation->endpoint = 'shipments';

        $orders = $this->OrdersListV2(request(),'raw');
 
        foreach($orders as $order){

            //get all shipstation data

             try {

                $currentShipments = $shipStation->shipments->get(['orderNumber' => $order->id]);
                //for the sake of brevity, we'll only get the first shipment

                $shipmentData = $currentShipments->shipments[0];

                

                $trackingUrl = '';

                switch(@$shipmentData->carrierCode){
                    case "fedex":
                        $trackingUrl .= 'https://www.fedex.com/fedextrack/?action=track&trackingnumber='.$shipmentData->trackingNumber; 
                    break;
                    case "stamps_com":
                        $trackingUrl .= 'https://tools.usps.com/go/TrackConfirmAction.action?tLabels='.$shipmentData->trackingNumber;
                    break;
                    case "ups_walleted":
                        $trackingUrl .= 'http://wwwapps.ups.com/WebTracking/processRequest?HTMLVersion=5.0&Requester=NES&AgreeToTermsAndConditions=yes&loc=en_US&tracknum='.$shipmentData->trackingNumber;
                    break;
                }

                if($trackingUrl !== ""){

                    $carrierCode = $shipmentData->carrierCode;
                    $client = new Client();
                    $shippingStatusIndicator = "";
                    $statusForLabel = "";

                    $trackingUrl = 'https://wwwapps.ups.com/WebTracking/processRequest?HTMLVersion=5.0&Requester=NES&AgreeToTermsAndConditions=yes&loc=en_US&tracknum=1Z7XR9680390709405/trackdetails'; //test only                    

                    $carrierCode = 'ups_walleted'; //test only

                    switch($carrierCode){
                        case "stamps_com": //last updated August 17, 2022

                            $crawler = $client->request('GET', $trackingUrl);

                            $crawler = $crawler->filter('.delivery_status > h2');
                            foreach($crawler as $i=> $domElement){
                                try {
                                     if($i === 0){
                                        $shippingStatusIndicator = $domElement->nodeValue;
                                     }     
                                }catch(\Exception $e){
                                    var_dump("error on DOM");
                                }     
                            }

                            if(preg_match("#Shipping Label Created#",$shippingStatusIndicator)){
                                $status = 'Created Label';
                            }else if(preg_match("#Delivery#",$shippingStatusIndicator)){
                                $status = 'Delivery';
                            }else if(preg_match("#Delivered#",$shippingStatusIndicator)){
                                $status = 'Delivered';
                            }

                        break;
                        case "ups_walleted":

                            $browserFactory = new BrowserFactory();
                            $browser = $browserFactory->createBrowser();

                            try {
                                // creates a new page and navigate to an URL
                                $page = $browser->createPage();
                                $page->navigate($trackingUrl)->waitForNavigation(Page::NETWORK_IDLE);

                                // get page title
                                $pageTitle = $page->evaluate('document.title')->getReturnValue();

                                var_dump($pageTitle);

                            }catch(\Exception $e){
                                var_dump($e->getMessage());
                            }finally {
                                $browser->close();
                            }


                            // $crawler = $crawler->filter('body');

                            // foreach($crawler as $i=> $domElement){
                            //     try {
                            //          if($i === 0){
                            //             var_dump($domElement);
                            //          }     
                            //     }catch(\Exception $e){
                            //         var_dump("error on DOM");
                            //     }     
                            // }
                        break;
                    }

                    
                    
                }

            }catch(\Exception $e){
                var_dump($e->getMessage());
            }

            echo "<br><br>";

        }

    }

    public function AfterCheckoutSquare(Request $request){
 
        $invoiceData = json_decode(@file_get_contents('php://input'));

        switch ($invoiceData->type) {
          case 'invoice.payment_made':
            try {

                $orderIds = $invoiceData->data->object->invoice->description;

                Log::emergency('Status: ' . $invoiceData->data->object->invoice->status);

                if($invoiceData->data->object->invoice->status === 'PAID'){
                    //set all of them to paid

                    $orderIds = explode(",",$orderIds);

                    $cumulativeOrderList = Order::whereIn('id', $orderIds);

                    $markAllAsPaid = $cumulativeOrderList->update([
                        'pay' => '1',
                        'invoice_number' => $invoiceData->data->object->invoice->invoice_number
                    ]);

                    ActivityNotif::create([
                        'order_id' => $orderIds[0],
                        'title' => "Invoice Paid - " . $orderIds[0],
                        'description' => $invoiceData->data->object->invoice->title,
                        'initiated_by' => -1,
                        'action' => 'invoice_paid',
                        'type' => 'payments' 
                    ]);   

                    $order = Order::find($orderIds[0]);
                    $order = $this->updateStatusToProduction($order); 
                    $order->update();
                }


            }catch(\Exception $e){
                Log::emergency('Error: ' . $e->getMessage());

                return "Error: ". $e->getMessage();
            }
            

            return response()->json($invoiceData->data->object);

          break;
          // ... handle other event types

          default:
            return "Error: ". $e->getMessage();
            Log::emergency('Error: ' . 'Received unknown event type ' . $event->type); //for testing only
          break;

        }

        return "Something to return lol";

        

    }

    public function apparelTypeConversion($type){

        $apparelTypeData = array (
          0 => 
          array (
            0 => 'Style',
            1 => '',
          ),
          1 => 
          array (
            0 => 'T-Shirts',
            1 => 'tshirts',
          ),
          2 => 
          array (
            0 => 'Short Sleeve',
            1 => 'short_sleeve',
          ),
          3 => 
          array (
            0 => 'Long Sleeve',
            1 => 'long_sleeve',
          ),
          4 => 
          array (
            0 => '3/4 Sleeve',
            1 => '3by4_sleeve',
          ),
          5 => 
          array (
            0 => 'Tank Top',
            1 => 'tank_top',
          ),
          6 => 
          array (
            0 => 'Sweatshirt & Fleece',
            1 => 'sweatshirt_and_Fleece',
          ),
          7 => 
          array (
            0 => 'Pullover Hooded',
            1 => 'pullover_hooded',
          ),
          8 => 
          array (
            0 => 'Crewneck',
            1 => 'crewneck',
          ),
          9 => 
          array (
            0 => 'Zip Hoodie',
            1 => 'zip_hoodie',
          ),
          10 => 
          array (
            0 => 'Short Sleeve Polo',
            1 => 'short_sleeve_polo',
          ),
          11 => 
          array (
            0 => 'Long Sleeves Polo',
            1 => 'long_sleeves_polo',
          ),
          12 => 
          array (
            0 => 'Sports Bra',
            1 => 'sports_bra',
          ),
          13 => 
          array (
            0 => 'Onesie',
            1 => 'onesie',
          ),
          14 => 
          array (
            0 => 'Short',
            1 => 'short',
          ),
          15 => 
          array (
            0 => 'Legging',
            1 => 'legging',
          ),
          16 => 
          array (
            0 => 'Unstructured Cap',
            1 => 'unstructured_cap',
          ),
          17 => 
          array (
            0 => 'Fitted',
            1 => 'fitted',
          ),
          18 => 
          array (
            0 => 'Adjustable',
            1 => 'adjustable',
          ),
          19 => 
          array (
            0 => 'Five-Panel',
            1 => 'five-panel',
          ),
          20 => 
          array (
            0 => 'Six-Panel',
            1 => 'six-panel',
          ),
          21 => 
          array (
            0 => 'Beanies',
            1 => 'beanies',
          ),
          22 => 
          array (
            0 => 'Visors',
            1 => 'visors',
          ),
          23 => 
          array (
            0 => 'Windbreakers',
            1 => 'windbreakers',
          ),
          24 => 
          array (
            0 => 'Rain Coats',
            1 => 'rain_coats',
          ),
          25 => 
          array (
            0 => 'Puffers',
            1 => 'puffers',
          ),
          26 => 
          array (
            0 => 'Packables',
            1 => 'packables',
          ),
          27 => 
          array (
            0 => 'Soft Shells',
            1 => 'soft_shells',
          ),
          28 => 
          array (
            0 => 'Backpack',
            1 => 'backpack',
          ),
          29 => 
          array (
            0 => 'Duffels',
            1 => 'duffels',
          ),
          30 => 
          array (
            0 => 'Drawstring',
            1 => 'drawstring',
          ),
          31 => 
          array (
            0 => 'Totes',
            1 => 'totes',
          ),
          32 => 
          array (
            0 => 'Blanket',
            1 => 'blanket',
          ),
          33 => 
          array (
            0 => 'Scarves & Gloves',
            1 => 'scarves_and_gloves',
          ),
          34 => 
          array (
            0 => 'Socks',
            1 => 'socks',
          ),
          35 => 
          array (
            0 => 'Towels',
            1 => 'towels',
          ),
          36 => 
          array (
            0 => 'Aprons',
            1 => 'aprons',
          ),
          37 => 
          array (
            0 => 'Bibs',
            1 => 'bibs',
          ),
          38 => 
          array (
            0 => 'Other',
            1 => 'other',
          ),
          39 => 
          array (
            0 => 'PPE',
            1 => 'ppe',
          ),
          40 => 
          array (
            0 => 'Face Coverings',
            1 => 'face_coverings',
          ),
          41 => 
          array (
            0 => 'Masks',
            1 => 'masks',
          ),
          42 => 
          array (
            0 => 'Gaiters',
            1 => 'gaiters',
          ),
          43 => 
          array (
            0 => 'Bandanas',
            1 => 'bandanas',
          ),
        );
  
        foreach($apparelTypeData as $apparelType){
          if($type === $apparelType[1]){
              return $apparelType[0];
          }
        }
  
        return $type; //if nothing was matched with
  
      }

      public function squareUpdatePayment($id, Request $request){
        
        $guzzle = new Guzzle\Client([
            'base_uri' =>  env('SQUARE_ENDPOINT_BASE'),
            'headers' => [ 
                'Authorization' => 'Bearer ' . env('SQUARE_APP_TOKEN'),
                'Square-Version' => env('SQUARE_APP_VERSION')
            ],
            'verify' => false
        ]);

        $orderMeta = OrderMeta::where('order_id',$id)->first();
        $orderMeta = json_decode($orderMeta->invoice_meta); 
       
   
 
        $invoiceRequestData = array (             
            'idempotency_key' =>    uniqid(0, true), 
            'source_id' => "CASH",
            'order_id' =>  $orderMeta->order_id,
            'amount_money' =>   array ( 
                    'amount' => 800,
                    'currency' => "USD"             
            ),       
            'cash_details' =>   array ( 
                'buyer_supplied_money' => array ( 
                    'amount' => 800,
                    'currency' => "USD"       
                )      
            ),      
          );
 
/* 

"cash_details": {
      "buyer_supplied_money": {
        "amount": 200,
        "currency": "USD"
      }
    }
*/
        $paymentDetails = $guzzle->post('payments',[
            'body' => json_encode($invoiceRequestData)
        ]);

        return $paymentDetails; 

      }

  
      public function squareUpdateRemainder($id, Request $request){
        
        $guzzle = new Guzzle\Client([
            'base_uri' =>  env('SQUARE_ENDPOINT_BASE'),
            'headers' => [ 
                'Authorization' => 'Bearer ' . env('SQUARE_APP_TOKEN'),
                'Square-Version' => env('SQUARE_APP_VERSION')
            ],
            'verify' => false
        ]);

        $orderMeta = OrderMeta::where('order_id',$id)->first();
        $orderMeta = json_decode($orderMeta->invoice_meta); 
        $dueDate = "";
        $uid = "";
        $scheduledDays = 0;
        foreach ($orderMeta->payment_requests as $json) {
            if($json->request_type == "BALANCE"){
                $dueDate = $json->due_date;
                $uid = $json->uid;
                if(isset($json->reminders)){                    
                    $scheduledDays = $json->reminders[0]->relative_scheduled_days;
                } 
            } 
        }
  
         
        $now = time();  
        $your_date = strtotime($dueDate);
        $datediff =  $now - $your_date;

        $dueDateCount = round($datediff / (60 * 60 * 24));

        if($dueDateCount == $scheduledDays){
            return ['status' => false, 'message' => "Already Sent Mail"];
        }
  

        $publishingInvoiceData = array (             
            'idempotency_key' =>  uniqid(0, true), 
            'invoice' =>   array (
            'version' => $orderMeta->version,
            'payment_requests' => [  array (                
                    'uid' => $uid,
                    'due_date' => $dueDate,
                    "reminders"  => [
                        array (
                          "relative_scheduled_days"  => $dueDateCount,
                          "message"  => "Please Pay the Amouunt. Yesterday your due date"
                        )
                    ]                
            ) ]
            ),           
        );  
        try{
            $updateInvoiceRemainder = $guzzle->put('invoices/'.urlencode($orderMeta->id)."",[
                'body' => json_encode($publishingInvoiceData)
            ]);  

            $publishingInvoiceRequestResult = json_decode($updateInvoiceRemainder->getBody()->getContents());

            $publishingInvoiceRequestResult = $publishingInvoiceRequestResult->invoice;

            $publishingInvoiceRequestResult->url = $publishingInvoiceRequestResult->public_url;

            OrderMeta::upsert([ 
                'order_id' => $id, 
                'invoice_url' => $publishingInvoiceRequestResult->public_url, 
                'invoice_meta' => json_encode($publishingInvoiceRequestResult) 
            ], ['order_id'], ['invoice_url', 'invoice_meta']);

            return ['status' => true, 'message' => "Sucessfully updated"];

        }catch(\Exception $e){
            return ['status' => false, 'message' => $e->getMessage()];
        }
        

      }

    public function InvoiceCheckSquare($ids, Request $request){ 

        $guzzle = new Guzzle\Client([
            'base_uri' =>  env('SQUARE_ENDPOINT_BASE'),
            'headers' => [ 
                'Authorization' => 'Bearer ' . env('SQUARE_APP_TOKEN'),
                'Square-Version' => env('SQUARE_APP_VERSION')
            ],
            'verify' => false
        ]);
        
        $taxRate = .095;
        $compiledOrderNames = "";  
        $netPercentageAfterTaxes = (1 + $taxRate);
        $totalComputedTax = 0;
        $idList = explode(",",$ids);
        $orderDescription = count($idList) > 1 ? "Compiled Orders: " : "";
        //delete all invoices related to currently selected orders
        $currentOrderMetas = OrderMeta::whereIn('order_id',$idList);
        $OMData = $currentOrderMetas->get();
        $invoiceId = '';
 
        


        foreach($OMData as $orderMeta){

            try {
                if(strlen($orderMeta->invoice_meta) > 10){
                    
                    $invoiceDetails = json_decode($orderMeta->invoice_meta);
                    $invoiceId = $invoiceDetails->id;
                    $deleteOrder = $guzzle->post('invoices/'.urlencode($invoiceId)."/cancel",[
                        'body' => json_encode(['version' => 1])
                    ]);
                     
                }
            }catch(\Exception $e){
                 
            }            

        }

      
 
        $currentOrderMetas->update(['invoice_meta' => null]);
        if($request->cancel_invoice == 'cancelInvoice'){
            $response = [
                "cancel_invoices" => true,
                "orderIds" => $ids,

            ];
            return $response;

        }

        $finalizedInvoiceData = ['status' => false];
        $locationId = env('SQUARE_LOCATION_ID');
        $totalPriceBeforeMinimum = 0;
        //check to see if customer data exists

        $allPreviousOrdersResult = [];

        $orderLineItems = [];

       /*  $orderCreator = new \stdClass; */

        foreach($idList as $i => $id){
            $orderCheck = (object) Order::findOrFail($id);
            $orderMeta = OrderMeta::where('order_id',$id)->first();
            $orderNameForOrderPreview = "";

            if(count($idList) > 1){
                $orderDescription .= $orderCheck->name . " (#". $orderCheck->id .")";

                if($i < count($idList) - 1){
                    $orderDescription .= ", ";
                }


                $orderNameForOrderPreview = "(".$orderCheck ->name.") ";
            }else{
                $orderDescription .= $orderCheck->name ;
            }

            if($i > 0){
                $compiledOrderNames .= ",";
            }else{
                $firstOrderName = $orderCheck->name;
               /*  $orderCreator = User::where('id',$orderCheck->created_by)->first(); */
            }

            $compiledOrderNames .= " " . $orderCheck->name;

            switch($request->get('action')){
                default:
                    $customerIdForEmailSend = env('DUMMY_SQUARE_USER_ID');
                break;
                case "confirm":
                    $customerIdForEmailSend = $orderCheck->customer_id;
                break;
            }
            //$deleted = DB::table('user_square_data')
            //->where('email', $orderCheck->customer_email)
            //->delete();
            

            //search for customer
            $customerData = UserSquareData::where('user_id',$customerIdForEmailSend)->first();  
            $customerDataOnSite = User::where('id',$customerIdForEmailSend)->first(); 
            $firstOrder = $orderCheck;
            $firstCustomer = $orderCheck->customer_name;

            $userToSendEmailTo = User::where('id',$customerIdForEmailSend)->first();
            //if customer data isn't found, create a new customer data on Square for this person and on our end

            if($customerData === null){

                $customerDataOnSite = User::where('id',$customerIdForEmailSend)->first();
                $description = "Square Customer Details For: ". $userToSendEmailTo->name;
                try {

                    $customerDataForSquare = array (

                        'address' =>   
                        array (  
                          'address_line_1' => @$customerDataOnSite->shipping_address,  
                          'country' => 'US',  
                          'first_name' => @$customerDataOnSite->first_name,  
                          'last_name' => @$customerDataOnSite->last_name,  
                          'locality' => @$customerDataOnSite->shipping_city,  
                          'postal_code' => @$customerDataOnSite->shipping_zipcode,  
                        ),
  
                        'email_address' => @$customerDataOnSite->email,  
                        'company_name' => @$customerDataOnSite->shipping_company,  
                        'phone_number' => ENV('DUMMY_PHONE_NUMBER'),  
                        'family_name' => $customerDataOnSite->last_name,  
                        'given_name' => $customerDataOnSite->first_name,  
                      );

                    $customerRequest = $guzzle->post('customers',[
                        'body' => json_encode($customerDataForSquare)
                    ]);

                    $customerRequestResult = json_decode($customerRequest->getBody()->getContents());

                }catch(\Exception $e){
                    $finalizedInvoiceData['error'] = $e->getMessage();
                    return $finalizedInvoiceData;
                }          

                //create user_square_data
                $customerData = UserSquareData::create([
                    'email' => $userToSendEmailTo->email,
                    'user_id' => $userToSendEmailTo->id,
                    'square_id' => $customerRequestResult->customer->id,
                    'description' => $description
                ]);
 

            }

            $customerId = $customerData->square_id; 
            
            //compile the orders

            try {
                //iterate through each variant
                foreach([1,2,3,4,5] as $key => $num){

                    $priceOfProductData = 0;
                    $productDataDescription = 0;
                    $totalProductQuantity = 0;

                    $lineItemChecks = 
                        $orderCheck->{'item_number_'.$num}  !== null ||
                        $orderCheck->{'product_description_'.$num}  !== null ||
                        $orderCheck->{'per_price_'.$num}  !== null 
                    ;
                    if($lineItemChecks){
                        /* $hasTax = ($orderCheck->{'tax_'.$num} === '1');

                        $actualTaxRate = $hasTax ? [$taxRateId] : []; */

                        $hasTax = ($orderCheck->{'tax_'.$num}.'' === '1');
                        $taxRateForThis = $hasTax ? $taxRate : 0;

                        $price = intval(floatval($orderCheck->{'per_piece_'.$num})*100);
                        $apparelTypeClause = $orderCheck->{'apparel_type_'.$num} !== null ? $this->apparelTypeConversion($orderCheck->{'apparel_type_'.$num}) . '; ' : ''; 
                        $productColorClause = $orderCheck->{'product_color_'.$num} !== null ? $orderCheck->{'product_color_'.$num} . '; ' : '';
                        $descriptionClause = $orderCheck->{'product_description_'.$num} !== null ? $orderCheck->{'product_description_'.$num} . '; ' : '';

                        $itemNumberDisplay = $orderCheck->{'item_number_'.$num} !== null ? $orderCheck->{'item_number_'.$num} . '; ' : '';

                        $name = 
                            $itemNumberDisplay .
                            $apparelTypeClause .
                            $productColorClause .
                            $descriptionClause
                        ;
  
                        $itemSizeAttributePrefixes = [
                            'xs',
                            's',
                            'm',
                            'l',
                            'xl',
                            'xxl',
                            'xxxl',
                            'other_size_text_1',
                            'other_size_text_2',
                            'other_size_text_3',
                            'other_size_text_4'
                        ];

                        foreach($itemSizeAttributePrefixes as $attributePrefix){

                            $quantity = intval($orderCheck->{$attributePrefix."_".$num});
                            
                            switch($attributePrefix){
                                case "other_size_text_1":
                                    $nameColumn = "other_size_1_".$num;
                                break;
                                case "other_size_text_2":
                                    $nameColumn = "other_size_2_".$num;
                                break;
                                case "other_size_text_3":
                                    $nameColumn = "other_size_3_".$num;
                                break;
                                case "other_size_text_4":
                                    $nameColumn = "other_size_4_".$num;
                                break;
                            }

                            /* if(preg_match("#^other_size_#",$attributePrefix)){
                                $name .= "Size " .strtoupper($orderCheck->{$nameColumn});
                            }else{
                                $name .= "Size " . strtoupper($attributePrefix);
                            } */
                            if($quantity > 0){
                                if(preg_match("#^other_size_#",$attributePrefix)){

                                    if($orderCheck->{$nameColumn} === 'one_size'){
                                        $name .= "One Size: ". $quantity .", ";
                                    }else{
                                        $name .= strtoupper($orderCheck->{$nameColumn}).": ". $quantity .", ";
                                    }


                                }else{
                                    $name .= strtoupper($attributePrefix).": ". $quantity .", ";
                                }
                            }
                            

                            $totalPriceBeforeMinimum += ($price * $quantity);

                            $totalComputedTax += ($price * $quantity * $taxRateForThis);

                            $priceOfProductData += ($price * $quantity);
                            $totalProductQuantity += $quantity;

                                
                             
                        }

                        $moneyFormat = '$'.number_format($price/100, 2, '.', '');
                        $description = " ($moneyFormat x ".$quantity.")";

                       
                    }

                    if($priceOfProductData * $totalProductQuantity > 0){
                        $orderLineItems[count($orderLineItems)] = array (
                          'quantity' => $totalProductQuantity."",
                          'base_price_money' => 
                          array (
                            'amount' => $price,
                            'currency' => 'USD',
                          ),
                          'name' => $name,
                        );
                    } 
                }

                //setup cost
                if($orderCheck->setup_name !== null && floatval($orderCheck->setup_name) > 0){

                    $totalPriceBeforeMinimum += floatval($orderCheck->setup_name)*100;

                    $orderLineItems[count($orderLineItems)] = array (
                      'quantity' => "1",
                      'base_price_money' => 
                      array (
                        'amount' => intval(floatval($orderCheck->setup_name)*100),
                        'currency' => 'USD',
                      ),
                      'name' => "Setup"
                    );

                } 

               
            
                //Extra Service Cost
                if($orderCheck->extra_cost_each !== null && floatval($orderCheck->extra_cost_each) > 0){
                     
                    switch($orderCheck->extra_services){
                        case null:
                        case "":
                            $extra_services = '';
                        break;
                        case "fold_poly":
                            $extra_services = "Fold & Poly Bag";
                        break; 
                        case "bar_code":
                            $extra_services = "Bar Code";
                        break; 
                        case "hang_tag":
                            $extra_services = "Hang Tag";
                        break; 
                        case "tag_removal":
                            $extra_services = "Tag Removal";
                        break; 
                        case "label_sewing":
                            $extra_services = "Label Sewing";
                        break; 
                        case "tag_sewing":
                            $extra_services = "Tag Sewing";
                        break; 
                        case "color_change":
                            $extra_services = "Color Change";
                        break; 
                        case "rush":
                            $extra_services = "Rush";
                        break; 
                    }

                    if($orderCheck->extra_service_each_cost == 1){ 
 

                        $totalCountQuantity = intval(floatval($orderCheck->total_product_count));

                        $totalComputedTax += (intval(floatval($orderCheck->extra_cost_each)) * $totalCountQuantity * $taxRateForThis * 100);

                     
                        
                        $totalPriceBeforeMinimum += floatval($orderCheck->extra_cost_each)*100;

                        $orderLineItems[count($orderLineItems)] = array (
                            'quantity' =>  $totalCountQuantity."",
                            'base_price_money' => 
                            array (
                            'amount' => intval(floatval($orderCheck->extra_cost_each)*100),
                            'currency' => 'USD',
                            ),
                            'name' => "Extra Services (". $extra_services . ")"
                        );

                    }else{

                        $totalPriceBeforeMinimum += floatval($orderCheck->extra_cost_each)*100;

                        $totalComputedTax += (intval(floatval($orderCheck->extra_cost_each)) * $taxRateForThis * 100);

                      

                        $orderLineItems[count($orderLineItems)] = array (
                            'quantity' => "1",
                            'base_price_money' => 
                            array (
                            'amount' => intval(floatval($orderCheck->extra_cost_each)*100),
                            'currency' => 'USD',
                            ),
                            'name' => "Extra Services (". $extra_services . ")"
                        );

                    }

                 

                }

                //screen cost
                if($orderCheck->setup_screen_1 !== null && $orderCheck->setup_screen_2 !== null){
                    $pricePerScreen = (floatval($orderCheck->setup_screen_2)*100);
                    $screenQuantity = intval($orderCheck->setup_screen_1);
                    $moneyFormat = '$'.number_format($pricePerScreen/100, 2, '.', '');

                    $totalPriceBeforeMinimum += floatval($pricePerScreen*$screenQuantity)*100;

                    $orderLineItems[count($orderLineItems)] = array (
                      'quantity' => "1",
                      'base_price_money' => 
                      array (
                        'amount' => $pricePerScreen*$screenQuantity,
                        'currency' => 'USD',
                      ),
                      'name' => $orderNameForOrderPreview .'Screens; '. $screenQuantity ." ($moneyFormat x ".$screenQuantity.")"
                    );

                }

                //shipping cost
                $shippingMethodDescription = "";
                switch($orderCheck->ship_type){
                    case null:
                    case "other":
                        if($orderCheck->shipping_instructions){
                            $shippingMethodDescription = "(" . $orderCheck->shipping_instructions . ")";
                        }else{
                            $shippingMethodDescription = "";
                        }
                    break;
                    case "courier":
                    case "pickup":
                        if($orderCheck->shipping_instructions){
                            $shippingMethodDescription = ucfirst($orderCheck->ship_type) . " (" . $orderCheck->shipping_instructions . ")";
                        }else{
                            $shippingMethodDescription = ucfirst($orderCheck->ship_type);
                        }
                    break;
                    case "hand_deliver":
                        if($orderCheck->shipping_instructions){
                            $shippingMethodDescription = 'Hand Delivery' . " (" . $orderCheck->shipping_instructions . ")";
                        }else{
                            $shippingMethodDescription = 'Hand Delivery';
                        }
                    break;
                    default:
                        if($orderCheck->shipping_instructions){
                            $shippingMethodDescription = $orderCheck->ship_type . " (" . $orderCheck->shipping_instructions . ")";
                        }else{
                            $shippingMethodDescription = $orderCheck->ship_type;
                        }
                    break;
                }

                $totalPriceBeforeMinimum += floatval($orderCheck->shipping_amt)*100;

                $shippingDes = $orderNameForOrderPreview . $shippingMethodDescription 
                ;

                if($orderCheck->ship_notes !== null || $orderCheck->shipping_des !== null){
                    $des = ($orderCheck->shipping_des !== null) ? $orderCheck->shipping_des : $orderCheck->ship_notes; 
                    $shippingDes .= " (". $des .")";
                }

                if($orderCheck->ship_type !== null){
                    $orderLineItems[count($orderLineItems)] = array (
                      'quantity' => "1",
                      'base_price_money' => 
                      array (
                        'amount' => intval(floatval($orderCheck->shipping_amt)*100),
                        'currency' => 'USD',
                      ),
                      'name' => $shippingDes
                    );
                }

                

            }catch(\Exception $e){
                $finalizedInvoiceData['error'] = $e->getMessage();
                return $finalizedInvoiceData;
            } 
            
        }

        if($totalPriceBeforeMinimum <= 0){
            return ['status' => false, 'error' => 'Total amounts to $0.00.'];
        }

        $orderRequestData = array (
          'order' => 
          array (
            'location_id' => $locationId,
            'customer_id' => $customerId,
            'line_items' => $orderLineItems,
            
            'service_charges' => 
            [
              array (
                'amount_money' => 
                array (
                  'amount' => intval($totalComputedTax),
                  'currency' => 'USD',
                ),
                'name' => 'Sales Tax',
                'calculation_phase' => 'TOTAL_PHASE',
              )
            ]
          )
        );
        try {
            $orderRequest = $guzzle->post('orders',[
                'body' => json_encode($orderRequestData)
            ]);     
        }catch(\Exception $e){
            return ['status' => false, 'error' => $e->getMessage()];
        }

           

        $orderRequestResult = json_decode($orderRequest->getBody()->getContents());

        //next, create the invoice

        $currentInvoicePoint = SiteSettings::getValue('current_invoice_point');

        $fullPayment =  array (
            0 => 
            array (
              'automatic_payment_source' => 'NONE',
              'due_date' => date('Y-m-d'),
              'request_type' => 'BALANCE',
            ),                          
          ); 

        if($request->payment_option == 'others'){

            if($request->deposit_request == 'halfAmount'){
                $createInvoiceWithDepositInPercentage = array ( 
                    0 => 
                    array (
                    'percentage_requested' => '50',
                    'due_date' => date('Y-m-d'),
                    'request_type' => 'DEPOSIT',
                    ),
                    1 => 
                    array ( 
                    'due_date' => date('Y-m-d', strtotime('+7 day')),
                    'request_type' => 'BALANCE',
                    ),
                );
                $paymentRequests =  $createInvoiceWithDepositInPercentage;
            }
           
            if($request->deposit_request == 'manualAmount'){


                $createInvoiceWithDepositInAmount = array ( 
                    0 => 
                    array (
                        'fixed_amount_requested_money' => array (
                            'amount' => intval(floatval($request->deposit_manual_amount)*100),
                            'currency' => 'USD',
                        ),
                        'due_date' => date('Y-m-d'),
                        'request_type' => 'DEPOSIT',
                    ),
                        1 => 
                    array ( 
                        'due_date' => date('Y-m-d', strtotime('+7 day')),
                        'request_type' => 'BALANCE',
                    ),
                );
                $paymentRequests =  $createInvoiceWithDepositInAmount;    
            }

           

        }else{
            $paymentRequests =  $fullPayment;
        }
        
        $invoiceRequestData = array (
          'invoice' => 
          array (
            'delivery_method' => 'EMAIL',
            'location_id' => $locationId."",
            'sale_or_service_date' => date('Y-m-d'),
            'title' => $orderDescription."",
            'accepted_payment_methods' => 
            array (
              'bank_account' => false,
              'card' => true,
              'square_gift_card' => false,
            ),
            'description' => $ids,
            'order_id' => $orderRequestResult->order->id."",
            'invoice_number' => $currentInvoicePoint,
            'primary_recipient' => 
            array (
              'customer_id' => $customerId,
            ),
            'payment_requests' => $paymentRequests,
          )
        );
        
        $latestInvoicePoint = $currentInvoicePoint+1;
        
        SiteSettings::where(['property' => 'current_invoice_point'])->update(['value' => $latestInvoicePoint]);

        $invoiceRequest = $guzzle->post('invoices', [
            'body' => json_encode($invoiceRequestData)
        ]);

        $invoiceRequestResult = json_decode($invoiceRequest->getBody()->getContents());

        $invoiceId = $invoiceRequestResult->invoice->id;

        $publishingInvoiceData = ['version' => 0];

        $publishingInvoiceRequest = $guzzle->post('invoices/'.urlencode($invoiceId)."/publish",[
            'body' => json_encode($publishingInvoiceData)
        ]);     

        $publishingInvoiceRequestResult = json_decode($publishingInvoiceRequest->getBody()->getContents());   

        $publishingInvoiceRequestResult = $publishingInvoiceRequestResult->invoice;

        $publishingInvoiceRequestResult->url = $publishingInvoiceRequestResult->public_url;

        if($request->get('action') == 'confirm') {
            foreach($idList as $id){
                OrderMeta::upsert([ 
                    'order_id' => $id, 
                    'invoice_url' => $publishingInvoiceRequestResult->public_url, 
                    'invoice_meta' => json_encode($publishingInvoiceRequestResult) 
                ], ['order_id'], ['invoice_url', 'invoice_meta']);
            }
    
            $publishingInvoiceRequestResult->status = true;
    
            ActivityNotif::create([
                'order_id' => $idList[0],
                'title' => "Invoice Created - " . $idList[0],
                'description' => $firstOrderName,
                'initiated_by' => $customerId,
                'action' =>  'invoice_created',
                'type' => 'payments' 
            ]); 
        }
         

        return $publishingInvoiceRequestResult;

    }

 
    public function SaveQRCode($orderID, $type, Request $request){

        $return = ['status' => false];

        try {
            if($type=='qr'){
                $folder = $orderID.'/qrcode';   
            }
            else if($type=='complete'){
                $folder = $orderID.'/completeqrcode';   
            }
            else if($type=='incomplete'){
                $folder = $orderID.'/incompleteqrcode';   
            }
            else if ($type=='artwork'){
                $folder = $orderID.'/artwork';   
            }

            $extension = $request->file->getClientOriginalExtension();

            $originalName = $this->filename($request->file);
            $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->file, 'qr.pdf', 'public');
            $return['status'] = true;

        }catch(\Exception $e){
            $return['error'] = $e->getMessage();
        }

        return response()->json($return);

    }

 
     
    public function OrdersListV2(Request $request, $returnType = null,$id = null, $code = null) {
        
       /*  DB::enableQueryLog(); */
/* 
       Builder::macro('toSqlWithBindings', function () {
        $bindings = array_map(
                    fn($value) => is_numeric($value) ? $value : "'{$value}'",
                    $this->getBindings()
                    );
        return Str::replaceArray('?', $bindings, $this->toSql());
        
    });  */

        if($request->purpose === 'cron' && $request->key === env('APP_KEY')){
            auth()->loginUsingId(env('AUTO_LOGIN_ID'));
        }

        $query = Order::with('order_arts')
            ->leftJoin('printers', 'orders.printer_id', '=', 'printers.id')
            ->leftJoin('users', 'orders.customer_id', '=', 'users.id')
            ->leftJoin('resources', 'orders.resource_id', '=', 'resources.id')
            ->leftJoin(DB::Raw('users as creators'), 'orders.created_by', '=', 'creators.id')
            ->leftJoin('orders_meta','orders.id','=','orders_meta.order_id')
            ->leftJoin('order_details','orders.id','=','order_details.order_id')
            ->leftJoin('shopify_integrations','orders_meta.integration_id','=','shopify_integrations.id');

        if(isset($request->deleted_only)){
            switch($request->deleted_only){
                case "all":
                    $query = $query->withTrashed();
                break;
                case "only":
                default:
                    $query = $query->onlyTrashed();
                break;
            }
        }

        if(isset($request->searchId)) {
            $query = $query->where('orders.id', $request->id);             
        }

        $type = $request->type;
        if(isset($request->title) && $request->searchId != 'yes') {
            $query = $query->where(function($q) use ($request, $type) {
                $q->orWhere('orders.name', 'LIKE', '%'.$request->title.'%');
                $q->orWhere('orders.customer_name', 'LIKE', '%'.$request->title.'%');
                $q->orWhere('orders.id', 'LIKE', '%'.$request->title.'%');
                $q->orWhere('users.first_name', 'LIKE', '%'.$request->title.'%');
                $q->orWhere('users.last_name', 'LIKE', '%'.$request->title.'%');
                $q->orWhere('users.email', 'LIKE', '%'.$request->title.'%');

                $q->orWhere('orders.invoice_number', 'LIKE', '%'.$request->title.'%');

                if(isset($type) && $type == "purchasing") {
                    $q->orWhere('orders.po_number', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.tracking_number', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_apparel_source_1', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_apparel_source_2', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_apparel_source_3', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_apparel_source_4', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_apparel_source_5', 'LIKE', '%'.$request->title.'%');

                    $q->orWhere('orders.item_number_1', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.item_number_2', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.item_number_3', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.item_number_4', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.item_number_5', 'LIKE', '%'.$request->title.'%');

                    $q->orWhere('orders.product_color_1', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_color_2', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_color_3', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_color_4', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_color_5', 'LIKE', '%'.$request->title.'%');
                }
            });
        }

        if(isset($type) && $type == "purchasing" ) { 
            $isPurchased = $request->isPurchased; 
            if( $isPurchased === '1'){ 
                $query = $query->where('orders.apparel_row_count', '>', '0'); 
                $query = $query->whereColumn('orders.apparel_row_count', '<=', 'orders.is_purchased_row_count');
                /* return $query->toSql(); */
            }else if( $isPurchased === '0'){ 
                $query = $query->whereColumn('orders.apparel_row_count', '>', 'orders.is_purchased_row_count');
                /* return $query->toSql(); */
            } 
        }

        if(isset($request->customer_id)) {
            $query = $query->where('orders.customer_id', $request->customer_id);
        }

        if(isset($request->apparel)) {
            $query = $query->where('orders.apparel', $request->apparel);
        }

        if(isset($request->sale_id)) {
            $query = $query->where('orders.created_by', $request->sale_id);
        }

        if(isset($request->print_date)) {
            $query = $query->where('orders.print_date', $request->print_date);
        }

        if(isset($request->order_apparel)) {
            if($request->order_apparel != 'all'){
                $query = $query->where('orders.apparel', $request->order_apparel);
            }             
        }

        if(isset($request->film_status)) {
            if($request->film_status == 'not_added') {
                $query = $query->where('orders.film', false);
            } else if($request->film_status == 'film_added') {
                $query = $query->where('orders.film', true);
            } else if($request->film_status == 'all_orders') {
                $query = $query->where('orders.status', 'Processing');
            }
        }

        if(isset($request->shipped)){
            switch($request->shipped){
                default:
                break;
                case "shipped":
                    $query->whereNotNull('actual_shipped');
                break;
                case "not_shipped":
                    $query->whereNull('actual_shipped');
                break;
            }
        }
        
        if(isset($request->printer_id)) {
            $query = $query->where('orders.printer_id', $request->printer_id)->orderBy('orders.sort_by_printer', 'ASC');
        }

     

        if(isset($request->resource_id)) {
            $query = $query->where('orders.resource_id', $request->resource_id)->orderBy('orders.sort_by_resource', 'ASC');
        }

        // Production, Completed, Processing

        if(isset($request->order_status)) {
            if($request->order_status == 'CustomerOpenOrders'){
                $query = $query->whereIn('orders.status', ['Processing','Production']);
            }else if($request->order_status == 'Draft'){
                $query = $query->where('orders.status', $request->order_status);
            }else{
                $query = $query->where('orders.status', $request->order_status);
            } 
        }else{                 
                $query = $query->where('orders.status', '!=', 'Draft'); 
        }

        if(isset($request->order_type)) {
            /*      $query = $query->where('orders.type', $request->order_type); */

            switch($request->order_type){
                case "screen_printing":
                    $query->whereIn('orders.type', ['screen_printing','screen_and_embroidery','screen_and_dtg','screen_and_dtf']);
                break; 
                case "direct_to_garment":
                    $query->whereIn('orders.type', ['direct_to_garment','screen_and_dtg']);
                break;
                case "embroidery":
                    $query->whereIn('orders.type', ['embroidery','screen_and_embroidery']);
                break; 
                case "dtf":
                    $query->whereIn('orders.type', ['dtf','screen_and_dtf']);
                break; 
                case "vynil":
                    $query->whereIn('orders.type', ['vynil']);
                break; 
                case "dyesub":
                    $query->whereIn('orders.type', ['dyesub']);
                break; 
                case "screen_and_embroidery":
                    $query->whereIn('orders.type', ['embroidery','screen_and_embroidery']);
                break; 
                case "screen_and_dtg":
                    $query->whereIn('orders.type', ['direct_to_garment','screen_and_dtg']);  
                break; 
                case "screen_and_dtf":
                    $query->whereIn('orders.type', ['dtf','screen_and_dtf']);
                break;  
                case "order_others":
                    $query->whereIn('orders.type', ['order_others']);
                break;  
                default:
                    $query->where('orders.type', $request->order_type);

            } 
        }

      /*   if(isset($request->date_order)) {
            $query = $query->whereDate('orders.created_at','>=' ,\Carbon\Carbon::now()->subDays($request->date_order));
        } */
        if(isset($request->date_order)) {
            if($request->date_order == '14'){
                $request->startDate = \Carbon\Carbon::today()->startOfWeek()->addWeeks(1);
                $request->endDate =  \Carbon\Carbon::today()->endOfWeek()->addWeeks(1);
            }
            if($request->date_order =='7'){
                $request->startDate = \Carbon\Carbon::today()->startOfWeek();
                $request->endDate =  \Carbon\Carbon::today()->endOfWeek();
            }
            if($request->date_order =='2'){
                $request->startDate =  $request->endDate = \Carbon\Carbon::today()->addDays(1);                
            }
            if($request->date_order =='1'){
                $request->startDate =  $request->endDate = \Carbon\Carbon::today();                
            }
            if($request->date_order =='-1' ){
                $request->startDate = \Carbon\Carbon::today()->subDays(10000);  
                $request->endDate =  \Carbon\Carbon::today()->subDays(1);          
            }
            if($request->date_order =='100000' || $request->date_order =='Latest' || $request->date_order =='Soonest'){
                $request->startDate = \Carbon\Carbon::today()->subDays(10000);  
                $request->endDate =  \Carbon\Carbon::today()->addDays(10000);          
            }
            if($request->date_order == 'order_issue'){
                $request->startDate = \Carbon\Carbon::today()->subDays(10000);  
                $request->endDate = \Carbon\Carbon::today()->addDays(1); 
            }
            
                $query = $query->whereBetween('orders.arrival_date',[$request->startDate, $request->endDate]);
             
              
        } 

        if(isset($request->startDate)) {
            $query = $query->whereBetween('orders.arrival_date',[$request->startDate, $request->endDate]);
        }

        if(isset($request->po_number)) {
            $query = $query->where('orders.po_number', 'LIKE', '%'.$request->po_number.'%');
        }

        if(isset($request->tracking_number)) {
            $query = $query->where('orders.tracking_number', 'LIKE', '%'.$request->tracking_number.'%');
        }

        if(isset($request->created_by_id)) {
            $query = $query->where('orders.created_by', $request->created_by_id)->orderBy('orders.id', 'DESC');
        }else{

            switch(auth()->user()->role){
                case "Sales":
                    $query = $query->where('orders.created_by', auth()->user()->id);
                break;
                case "Trader":
                    $getUserId = User::whereStatus(1)->where('created_by',auth()->user()->id)->get('id');         
                    $query = $query->where(function($sqlquery) use($getUserId){
                        $sqlquery->whereIn('orders.created_by',  $getUserId)->orWhere('orders.created_by', auth()->user()->id)
                        ->orWhere('orders.trader_printer_id', auth()->user()->id);
                    });
    
                break;
                case "Admin":
                    $trader = User::where('role', 'Trader')->whereStatus(1)->get('id');
                    $traderUserId = User::whereStatus(1)->whereIn('created_by',$trader)->get('id'); 
     
                    $query = $query->where(function($sqlquery) use($trader, $traderUserId){
                       /*  $sqlquery->whereNull('orders.trader_printer_id')->whereNotIn('orders.created_by', $trader)->whereNotIn('orders.created_by', $traderUserId)
                        ->orWhere('orders.resource_admin', ['5']); */
                        $sqlquery->whereNotIn('orders.created_by', $trader)->whereNotIn('orders.created_by', $traderUserId)
                        ->orWhere('orders.resource_admin', ['5']);
                    });
                break;
                case "Etsy_Admin":
                    $etsyUsers = User::where('role', 'Etsy_Admin')->get('id');
                    $query = $query->whereIn('orders.created_by', $etsyUsers);
                break;
                case "Production":
                    $query = $query->where('orders.status', 'Production');
                break;
                case "Customer":
                    $query = $query
                             ->where(function($query){
                                $query->where('orders.customer_id',auth()->user()->id)
                                      ->orWhere('orders.created_by', auth()->user()->id);
                             });
                                   
                break;
            } 
        }

        
        
        if (isset($request->pay)) {
            if($request->pay == 0){
                $query->where(function($sql) use ($request, $type) {
                    $sql->where('pay', $request->pay); 
                    $sql->where('payment_terms', $request->pay );                
                });
            }else{
                $query->where(function($sql) use ($request, $type) {
                    $sql->orWhere('pay', $request->pay); 
                    $sql->orWhere('payment_terms', $request->pay );                
                });
            } 
        }

        if (isset($request->art_is_sized)) {
            $query->where('art_is_sized', $request->art_is_sized);
        }
 
        if (isset($request->film)) {
            $query->where('film', $request->film);
        }

        if(isset($request->in)){
            $ids = explode(",",$request->in);

            $query->whereIn('orders.id',$ids);

        }


        if ($request->searchPage  === 'dashboard') {
            $query->where(function($sql) use ($request, $type) {
            $sql->orWhere('orders.name', 'LIKE', '%'.$request->id.'%');
            $sql->orWhere('orders.customer_name', 'LIKE', '%'.$request->id.'%');
            $sql->orWhere('users.first_name', 'LIKE', '%'.$request->id.'%');
            $sql->orWhere('orders.id', 'LIKE', '%'.$request->id.'%');
            $sql->orWhere('users.last_name', 'LIKE', '%'.$request->id.'%');
            $sql->orWhere('users.email', 'LIKE', '%'.$request->id.'%');
            $sql->orWhere('orders.invoice_number', 'LIKE', '%'.$request->id.'%'); 
           
            });
            $query->whereIn('orders.status', ['Processing','Production','Completed']);
            
            $query = $query->select(['orders.*', 'users.first_name as firstName', 'users.last_name as lastName', 'orders.s_intro_email', 'printers.title as printer_name','resources.name as resource_name',DB::Raw('creators.first_name as creator_name,creators.email as creator_email, creators.role as creator_role'),'orders_meta.invoice_url','orders_meta.invoice_meta','orders_meta.ss_date','orders_meta.ss_invoice'])->orderBy('orders.id', 'DESC'); 
             /* return $query->toSql();  */
        }else if ($request->searchPage  === 'update_issues') {
            
            $request->issueStartDate = \Carbon\Carbon::today()->subDays(10000);  
            $request->issueEndDate = \Carbon\Carbon::today()->addDays(1); 
            
            $query = $query->whereBetween('orders.arrival_date',[$request->issueStartDate, $request->issueEndDate]);
             
            $query->whereIn('orders.status', ['Processing','Production']);
            $query = $query->select(['orders.*', 'users.first_name as firstName', 'users.last_name as lastName', DB::Raw('creators.first_name as creator_name,creators.email as creator_email,creators.company_name as companyName, creators.role as creator_role')])->orderBy('orders.id', 'DESC');
            /* return $query->toSql();  */
        }else{ 
            if($request->date_order =='Latest'){
                $query = $query->select(['orders.*', 'users.first_name as firstName', 'users.last_name as lastName', 'orders.s_intro_email', 'printers.title as printer_name','resources.name as resource_name',DB::Raw('creators.first_name as creator_name,creators.company_name as companyName,creators.email as creator_email,'.
               'creators.role as creator_role'), 'shopify_integrations.name as store_name', 'order_details.production_start_date as production_start_date',
               'orders_meta.invoice_url','orders_meta.invoice_meta','orders_meta.ss_date','orders_meta.ss_invoice',
               'orders_meta.purchasing_tracking','orders_meta.purchasing_invoice','orders_meta.purchasing_ordering',
               'orders_meta.product_1_json','orders_meta.product_2_json','orders_meta.product_3_json','orders_meta.product_4_json',
               'orders_meta.product_5_json','orders_meta.ss_references_1','orders_meta.ss_references_2','orders_meta.ss_references_3'
               ,'orders_meta.ss_references_4','orders_meta.ss_references_5','orders_meta.ss_metadata','orders_meta.purchasing_invoice'
               ,'orders_meta.purchasing_ordering','orders_meta.etsy_metadata','orders_meta.shopify_metadata','orders_meta.integration_id','orders_meta.purchasing_tracking'])->orderBy('orders.arrival_date', 'DESC');
            }else if($request->date_order =='Soonest'){
                $query = $query->select(['orders.*', 'users.first_name as firstName', 'users.last_name as lastName', 'orders.s_intro_email', 'printers.title as printer_name','resources.name as resource_name',DB::Raw('creators.first_name as creator_name,creators.company_name as companyName,creators.email as creator_email,'.
               'creators.role as creator_role'), 'shopify_integrations.name as store_name', 'order_details.production_start_date as production_start_date',
               'orders_meta.invoice_url','orders_meta.invoice_meta','orders_meta.ss_date','orders_meta.ss_invoice',
               'orders_meta.purchasing_tracking','orders_meta.purchasing_invoice','orders_meta.purchasing_ordering',
               'orders_meta.product_1_json','orders_meta.product_2_json','orders_meta.product_3_json','orders_meta.product_4_json',
               'orders_meta.product_5_json','orders_meta.ss_references_1','orders_meta.ss_references_2','orders_meta.ss_references_3'
               ,'orders_meta.ss_references_4','orders_meta.ss_references_5','orders_meta.ss_metadata','orders_meta.purchasing_invoice'
               ,'orders_meta.purchasing_ordering','orders_meta.etsy_metadata','orders_meta.shopify_metadata','orders_meta.integration_id','orders_meta.purchasing_tracking'])->orderBy('orders.arrival_date', 'ASC');
            }else{
                $query = $query->select(['orders.*', 'users.first_name as firstName', 'users.last_name as lastName', 'orders.s_intro_email', 'printers.title as printer_name','resources.name as resource_name',DB::Raw('creators.first_name as creator_name,creators.company_name as companyName,creators.email as creator_email,'.
                //'creators.profile_image as creator_profile_image'.
               'creators.role as creator_role'), 'shopify_integrations.name as store_name', 'order_details.production_start_date as production_start_date',
               'orders_meta.invoice_url','orders_meta.invoice_meta','orders_meta.ss_date','orders_meta.ss_invoice',
               'orders_meta.purchasing_tracking','orders_meta.purchasing_invoice','orders_meta.purchasing_ordering',
               'orders_meta.product_1_json','orders_meta.product_2_json','orders_meta.product_3_json','orders_meta.product_4_json',
               'orders_meta.product_5_json','orders_meta.ss_references_1','orders_meta.ss_references_2','orders_meta.ss_references_3'
               ,'orders_meta.ss_references_4','orders_meta.ss_references_5','orders_meta.ss_metadata','orders_meta.purchasing_invoice'
               ,'orders_meta.purchasing_ordering','orders_meta.etsy_metadata','orders_meta.shopify_metadata','orders_meta.integration_id','orders_meta.purchasing_tracking'])->orderBy('orders.id', 'DESC')->orderBy('orders.arrival_date', 'ASC');
            }
            
            //$query = $query->select(['orders.*', 'users.first_name as firstName', 'users.last_name as lastName', 'orders.s_intro_email', 'printers.title as printer_name','resources.name as resource_name',DB::Raw('creators.first_name as creator_name,creators.email as creator_email,'.
                 
               //'creators.role as creator_role'),'orders_meta.invoice_url','orders_meta.invoice_meta'])->orderBy('orders.id', 'DESC')->orderBy('orders.arrival_date', 'ASC');
           /*  return $query->toSql(); */
        }

        /* return $query->toSqlWithBindings();   */
         
        if($returnType !== null){
            switch($returnType){
                case "raw":
                    return $query->get();
                break;
            }
        }
        if(isset($request->startDate)) {
            if($request->date_order !=''){
                $dataToReturn = $query->paginate(6)->toArray();
            }else{
                $dataToReturn = $query->paginate(600)->toArray();
            } 
        }else if(isset($request->issueStartDate)) {
            $dataToReturn = $query->paginate(99)->toArray();
        }else{
            if($request->paginate){
                $dataToReturn = $query->paginate($request->paginate)->toArray();
            }else{
                $dataToReturn = $query->paginate(6)->toArray();
                if($type === 'purchasing' && @$request->purpose === 'cron'){
                    $dataToReturn = $query->paginate(100)->toArray();
                }    
            }
            
        }
        
        //$dataToReturn['query'] = DB::getQueryLog();
        
        $notBoughtOrders = '';

        foreach($dataToReturn['data'] as $i => $data){

            /* Code - Start */
            
          if(isset($type)) {

            switch($type){
              case "purchasing":
                
                $notBoughtOrders = '';
                $dt = $dataToReturn['data'][$i];

                if($dt['pay'].'' === '1' && !$this->checkIfInvoiceIdExists($dt)){
                    $notBoughtOrders .= $dt['id'];
                }

                if(array_key_exists('ss_metadata', $dt)){                    
                  if($dt['ss_metadata']  === null){
                    $dt['ss_metadata'] = [];
                  }
                }
/* 
                if($dt['ss_metadata'].'' === null){
                  $dt['ss_metadata'] = [];
                } */

                $dt['ss_price'] = 0;

                foreach([1,2,3,4,5] as $num){

                    $sizes = [
                        'xs',
                        's',
                        'm',
                        'l',
                        'xl',
                        'xxl',
                        'xxxl',
                        'other_size_1',
                        'other_size_2',
                        'other_size_3',
                        'other_size_4'
                    ];

                    //get all style color products associated with this
                     
                    if(isset($dt['product_'.$num.'_json']) && count($dt['product_'.$num.'_json']) > 0){
                        
                        $colorStyles = StyleColorProduct::searchSpecific($dt['product_'.$num.'_json']['brand_name'],$dt['product_'.$num.'_json']['style_name'],$dt['product_'.$num.'_json']['color_name'])->get();

                        //match to corresponding quantities on the references side
                      
                        foreach($sizes as $size){
                            //check if size is highlighted
                            if(isset($dt['ss_references_'.$num][$size]['highlighted']) && $dt['ss_references_'.$num][$size]['highlighted']){
                                //if it's highlighted, get the quantity

                                $sizeSpec = $size;

                                switch($size){
                                    case 'other_size_1':
                                        $sizeSpec = 'other_size_text_1';
                                    break;
                                    case 'other_size_2':
                                        $sizeSpec = 'other_size_text_2';
                                    break;
                                    case 'other_size_3':
                                        $sizeSpec = 'other_size_text_3';
                                    break;
                                    case 'other_size_4':
                                        $sizeSpec = 'other_size_text_4';
                                    break;

                                }

                                $quantity = intval($dt[$sizeSpec.'_'.$num]);
                                $pricePerPiece = 0;
                                if(isset($dt['ss_references_'.$num][$size]['raw'])){ 
                                    $sizeToMatchWith = $dt['ss_references_'.$num][$size]['raw'];
                                } 

                                foreach($colorStyles as $product){
                                    if($product->json_data['sizeName'] === $sizeToMatchWith){
                                        $pricePerPiece = floatval($product->json_data['casePrice']);
                                    }
                                }

                                $dt['ss_price'] = $dt['ss_price'] + ($quantity*$pricePerPiece);



                            }
                            
                        }
                    }



                }

                //check style color products

                if(isset($dt['ss_date']) && strlen($dt['ss_date'].'') > 0 ){
                  $dt['ss_date'] = @\Carbon\Carbon::parse($dt['ss_date'])->format('m/j/Y h:i A')  ;
                }else{
                  $dt['ss_date'] = '<em>No invoice date.</em>';
                }

                if(!(isset($dt['ss_invoice']) && strlen($dt['ss_invoice'].'') > 0 )){
                  $dt['ss_invoice'] = '<em>No SS invoice.</em>';
                }

                $dataToReturn['data'][$i] = $dt;

              break;
            }

          }
            /* Code - End */

            if(strlen($dataToReturn['data'][$i]['invoice_meta']) > 10){
                $dataToReturn['data'][$i]['invoice_meta'] = json_decode($data['invoice_meta']);
                if($dataToReturn['data'][$i]['pay']."" !== '1'){
                    $dataToReturn['data'][$i]['status_display'] = 'Not Paid';
                }else{
                    $dataToReturn['data'][$i]['status_display'] = $dataToReturn['data'][$i]['invoice_meta']->invoice_number;
                }
            }else{
                $dataToReturn['data'][$i]['invoice_meta'] = (object) [];
                $dataToReturn['data'][$i]['status_display'] = 'No Invoice';
            }      
            if($dataToReturn['data'][$i]['invoice_number'] !== null)  {                 
                $queryInvoiceId = DB::table('orders')->where('invoice_number', $dataToReturn['data'][$i]['invoice_number'])->get(['id']);             
                $queryInvoiceIdData = $queryInvoiceId;
                $dataToReturn['data'][$i]['invoice_id'] = $queryInvoiceIdData;
            }else{
                $dataToReturn['data'][$i]['invoice_id'] = null;
            }

            if($request->type == 'artwork'){
                $queryAddPartialTimestamp = DB::table('addpartialtimestamp')->where('ordernumber', $dataToReturn['data'][$i]['id'])->where('printtype', 'artwork')->get(['timestamp'])->first(); 
                if($queryAddPartialTimestamp){
                    $dataToReturn['data'][$i]['artwork_timestamp'] = $queryAddPartialTimestamp->timestamp; 
                }else{
                    $dataToReturn['data'][$i]['artwork_timestamp'] = "";
                }
                
            }
            //Need to update if required
           /*  $trueCount = 0;
            if($dataToReturn['data'][$i]['status'] === 'Processing')  {                 
                if($dataToReturn['data'][$i]['apparel'] === 1){ $trueCount++; }
                if($dataToReturn['data'][$i]['film'] === 1){ $trueCount++; }
                if($dataToReturn['data'][$i]['art_is_sized'] === 1){ $trueCount++; }
                if($dataToReturn['data'][$i]['pay'] === 1){ $trueCount++; }
                if($trueCount > 3){ 
                    Order::where(['id' => $dataToReturn['data'][$i]['id']])->update(['status' => 'Production']);
                    $dataToReturn['data'][$i]['status'] = 'Production';
                    
                } 
            } */

        }

        /* Code - Start */

        if(isset($type) && $type === "purchasing"){

            $guzzle = new Guzzle\Client([
                'base_uri' => 'https://api.ssactivewear.com/v2/',
                'headers' => [ 
                    'Authorization' => "Basic ". base64_encode(env('SS_USERNAME').':'.env('SS_PASSWORD')),
                    'Content-Type' => 'application/json'
                ]
            ]);

            $orderIdentifiers = '';

            foreach($dataToReturn['data'] as $dt){
                if(array_key_exists('ss_po_1', $dt)){   
                    if(strlen(trim($dt['ss_po_1'].'')) > 0){
                        $orderIdentifiers .= $dt['ss_po_1'].',';
                    }
                }
                if(array_key_exists('ss_po_2', $dt)){   
                    if(strlen(trim($dt['ss_po_2'].'')) > 0){
                        $orderIdentifiers .= $dt['ss_po_2'].',';
                    }
                }
                if(array_key_exists('ss_po_3', $dt)){   
                    if(strlen(trim($dt['ss_po_3'].'')) > 0){
                        $orderIdentifiers .= $dt['ss_po_3'].',';
                    }
                }
            }

            try {

                $response = $guzzle->get('orders/'.$orderIdentifiers, [
                    'body' => json_encode([

                    ])
                ]); 

                $orderMatches = [];

                $ssOrderDetails = json_decode($response->getBody()->getContents()); 

                foreach($dataToReturn['data'] as $orderDt){
                    foreach($ssOrderDetails as $ss){
                        if($orderDt['ss_po_1'].'' === $ss->orderNumber.''){
                            $orderMatches[count($orderMatches)] = [$orderDt['id'],$ss->orderNumber,@$ss->trackingNumber,@$ss->invoiceNumber];
                        }
                        if($orderDt['ss_po_2'].'' === $ss->orderNumber.''){
                            $orderMatches[count($orderMatches)] = [$orderDt['id'],$ss->orderNumber,@$ss->trackingNumber,@$ss->invoiceNumber];
                        }
                        if($orderDt['ss_po_3'].'' === $ss->orderNumber.''){
                            $orderMatches[count($orderMatches)] = [$orderDt['id'],$ss->orderNumber,@$ss->trackingNumber,@$ss->invoiceNumber];
                        }
                    }
                }

                foreach($orderMatches as $match){

                    $metaDetails = OrderMeta::where(['order_id' => $match[0]])->first();
                    //$match[1]
                    //check if order meta exists
                    $json = [];
                    $json2 = [];
                    $json3 = [];
                    if($metaDetails !== null){

                        if($metaDetails->purchasing_invoice !== null){
                            //check if invoice ID already exists

                            $json3 = $metaDetails->purchasing_invoice;

                            $invoiceAlreadyExists = false;

                            $vacantIndex = 0;

                            foreach($json3['data'] as $index => $invoiceID){
                                if(strlen(trim($invoiceID).'') === 0){
                                    $vacantIndex = $index;
                                }
                                if($invoiceID.'' === $match[3].''){
                                    $invoiceAlreadyExists = true;
                                }
                            }

                            if(!$invoiceAlreadyExists){
                                $json3['data'][$vacantIndex] = $match[3];
                            }
                        }else{
                            $json3 = ['data' => [@$match[3].'','','']];
                        }

                        if($metaDetails->purchasing_tracking !== null){
                            //check if invoice ID already exists

                            $json2 = $metaDetails->purchasing_tracking;

                            $trackingAlreadyExists = false;

                            $vacantIndex = -1;

                            foreach($json2['data'] as $index => $trackingID){
                                if(strlen(trim($trackingID).'') === 0){
                                    $vacantIndex = $index;
                                }
                                if($trackingID.'' === $match[2].''){
                                    $trackingAlreadyExists = true;
                                }
                            }

                            if(!$trackingAlreadyExists){
                                $json2['data'][$vacantIndex] = $match[2];
                            }
                        }else{
                            $json2 = ['data' => [@$match[2].'','','']];
                        }

                        if($metaDetails->purchasing_ordering !== null){
                            //check if invoice ID already exists

                            $json = $metaDetails->purchasing_ordering;

                            $orderAlreadyExists = false;

                            $vacantIndex = -1;

                            foreach($json['data'] as $index => $orderID){
                                if(strlen(trim($orderID).'') === 0){
                                    $vacantIndex = $index;
                                }
                                if($orderID.'' === $match[1].''){
                                    $orderAlreadyExists = true;
                                }
                            }

                            if(!$orderAlreadyExists){
                                $json['data'][$vacantIndex] = $match[1];
                            }
                        }else{
                            $json = ['data' => [$match[1],'','']];
                        }
                    }

                    OrderMeta::updateOrInsert(
                        ['order_id' => $match[0]],
                        ['purchasing_ordering' => json_encode($json), 'purchasing_tracking' => json_encode($json2), 'purchasing_invoice' => json_encode($json3)]
                    );
                }

                $dataToReturn['ss_orders'] = $ssOrderDetails;

            }catch(\Exception $e){
                $dataToReturn['error'] = $e->getTrace();
            }

        }



        /* Code - End */


        $dataToReturn['code'] = 200;
        $dataToReturn['success'] = true;
        $dataToReturn['message'] = 'Orders List.';

        $query = $query->select(['orders.*', 'printers.title as printer_name'])->orderBy('orders.arrival_date', 'ASC');

        $data = $query->get();

        $idsToFetch = [];

        foreach($data as $datum){
            $idsToFetch[count($idsToFetch)] = $datum->id;
        }

        if($request->get('with_labels') !== null){
            $pastLabels = PastLabels::where(['type' => 'shipping'])->whereIn('order_id',$idsToFetch)->get();

            $dataToReturn['labels'] = new \stdClass;

            foreach($idsToFetch as $id){
                $dataToReturn['labels']->{'for_'.$id} = [];
            }

            foreach($pastLabels as $label){
                if($label->metadata){
                    $label->metadata = @json_decode($label->metadata);
                    array_push($dataToReturn['labels']->{'for_'.$label->order_id},$label);
                }else{
                    $label->metadata = [
                        'width' => '-', 
                        'height' => '-', 
                        'length' => '-', 
                        'weight' => '-',
                    ];
                    array_push($dataToReturn['labels']->{'for_'.$label->order_id},$label);
                }
                
            }

            foreach($idsToFetch as $id){
                if(count($dataToReturn['labels']->{'for_'.$id}) === 0){
                    //get order data to check if there is an order

                    $orderInQ = Order::where('id',$id)->first();
                    if(strlen($orderInQ->tracking_number."") > 5){

                        $dataToSubmit = [
                            'order_id' => $id,
                            'label_url' => $orderInQ->shipping_label_url.'',
                            'type' => 'shipping',
                            'metadata' => json_encode([
                                'width' => '-', 
                                'height' => '-', 
                                'length' => '-', 
                                'weight' => '-',
                                'tracking_number' => $orderInQ->tracking_number
                            ])
                        ];

                        $pastLabel = PastLabels::create($dataToSubmit);

                        $dataToSubmit['metadata'] = @json_decode($dataToSubmit['metadata']);
                        array_push($dataToReturn['labels']->{'for_'.$id},$dataToSubmit);

                    }
                }
            }

        }

        return response()->json($dataToReturn);
    }

    public function updatePackageDetails(Request $request){
        $id = $request->pastLabelsId;
        $order = PastLabels::find($id);
        if(!$order) {
            $dataToSubmit = [
                'order_id' => $request->orderID, 
                'type' => 'shipping',
                'metadata' => json_encode([
                    'width' => $request->boxWidth, 
                    'height' => $request->boxHeight, 
                    'length' => $request->boxLength, 
                    'weight' => $request->shopBag 
                ])
            ];
            if($request->boxWidth != '' && $request->boxHeight != '' && $request->boxLength != ''){
                PastLabels::create($dataToSubmit); 
            }else{
                return "Some Fields Data Missing";
            }
            

        }else{

            
            $dataToSubmit = [
                'order_id' => $request->orderID, 
                'type' => 'shipping',
                'metadata' => json_encode([
                    'width' => $request->boxWidth, 
                    'height' => $request->boxHeight, 
                    'length' => $request->boxLength, 
                    'weight' => $request->shopBag 
                ])
            ];
            PastLabels::where(['id' => $id])->update($dataToSubmit);
             
        }
/* 
        $dataToSubmit = [
            'order_id' => $request->orderID, 
            'type' => 'shipping',
            'metadata' => json_encode([
                'width' => $request->boxWidth, 
                'height' => $request->boxHeight, 
                'length' => $request->boxLength, 
                'weight' => $request->shopBag 
            ])
        ];

        PastLabels::create($dataToSubmit); */
    }

    public function checkIfInvoiceIdExists($order){
        
      /*   if($order['purchasing_invoice'] === null){
            return true;
        }else{
            $everythingIsNull = false;

            foreach(@$order['purchasing_invoice']['data'] as $invoice){
                if(strlen($invoice) > 0){
                    $everythingIsNull = true;
                }
            }

            return $everythingIsNull;
        } */

        if(array_key_exists('purchasing_invoice',$order)){
            if($order['purchasing_invoice'] === null){
                return true;
            }
        }else{
            $everythingIsNull = false;
            if(array_key_exists('purchasing_invoice', $order)){     
                foreach(@$order['purchasing_invoice']['data'] as $invoice){
                    if(strlen($invoice) > 0){
                        $everythingIsNull = true;
                    }
                }
            }

            return $everythingIsNull;
        } 

    }

    public function unassignedResourceList(Request $request) {
 

        if($request->isPrinter == true || auth()->user()->role == 'Trader'){

            $query = Order::with('order_arts')
            ->whereRaw('(orders.printer_id IS NULL OR orders.printer_id = 0)')            
            ->leftJoin('printers', 'orders.printer_id', '=', 'printers.id')
            ->leftJoin('users', 'orders.customer_id', '=', 'users.id')
            ->leftJoin('resources', 'orders.resource_id', '=', 'resources.id')
            ->leftJoin('order_details','orders.id','=','order_details.order_id')
            ->leftJoin(DB::Raw('users as creators'), 'orders.created_by', '=', 'creators.id')
            ->leftJoin('orders_meta', 'orders.id', '=', 'orders_meta.order_id')->groupBy('orders.id');
        }else{
            $query = Order::with('order_arts')
            ->whereRaw('(orders.resource_id IS NULL OR orders.resource_id = 0)')            
            ->leftJoin('printers', 'orders.printer_id', '=', 'printers.id')
            ->leftJoin('users', 'orders.customer_id', '=', 'users.id')
            ->leftJoin('order_details','orders.id','=','order_details.order_id')
            ->leftJoin('resources', 'orders.resource_id', '=', 'resources.id')
            ->leftJoin(DB::Raw('users as creators'), 'orders.created_by', '=', 'creators.id')
            ->leftJoin('orders_meta', 'orders.id', '=', 'orders_meta.order_id')->groupBy('orders.id');   
        }



           /*  $query = $query->where('printers_id', null);  */
        if(isset($request->deleted_only)){
            switch($request->deleted_only){
                case "all":
                    $query = $query->withTrashed();
                break;
                case "only":
                    $query = $query->onlyTrashed();
                break;
            }
        }

        $type = $request->type;
        if(isset($request->title)) {
            $query = $query->where(function($q) use ($request, $type) {
                $q->orWhere('orders.name', 'LIKE', '%'.$request->title.'%');
                $q->orWhere('orders.customer_name', 'LIKE', '%'.$request->title.'%');
                $q->orWhere('orders.id', 'LIKE', '%'.$request->title.'%');
                $q->orWhere('users.first_name', 'LIKE', '%'.$request->title.'%');
                $q->orWhere('users.last_name', 'LIKE', '%'.$request->title.'%');
                $q->orWhere('users.email', 'LIKE', '%'.$request->title.'%');

                $q->orWhere('orders.invoice_number', 'LIKE', '%'.$request->title.'%');

                if(isset($type) && $type == "purchasing") {
                    $q->orWhere('orders.po_number', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.tracking_number', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_apparel_source_1', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_apparel_source_2', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_apparel_source_3', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_apparel_source_4', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_apparel_source_5', 'LIKE', '%'.$request->title.'%');

                    $q->orWhere('orders.item_number_1', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.item_number_2', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.item_number_3', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.item_number_4', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.item_number_5', 'LIKE', '%'.$request->title.'%');

                    $q->orWhere('orders.product_color_1', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_color_2', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_color_3', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_color_4', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_color_5', 'LIKE', '%'.$request->title.'%');
                }
            });
        }

        if(isset($request->customer_id)) {
            $query = $query->where('orders.customer_id', $request->customer_id);
        }

        if(isset($request->apparel)) {
            $query = $query->where('orders.apparel', $request->apparel);
        }

        if(isset($request->sale_id)) {
            $query = $query->where('orders.created_by', $request->sale_id);
        }

        if(isset($request->print_date)) {
            $query = $query->where('orders.print_date', $request->print_date);
        }

        if(isset($request->film_status)) {
            if($request->film_status == 'not_added') {
                $query = $query->where('orders.film', false);
            } else if($request->film_status == 'film_added') {
                $query = $query->where('orders.film', true);
            } else if($request->film_status == 'all_orders') {
                $query = $query->where('orders.status', 'Processing');
            }
        }

        if(isset($request->printer_id)) {
            $query = $query->where('orders.printer_id', $request->printer_id);
        }

        // Production, Completed, Processing
        if(isset($request->order_status)) {
            $query = $query->where('orders.status', $request->order_status);
            
        }

       /*  if($request->isPrinter == true){
            $query->whereIn('orders.type', ['screen_printing','screen_and_embroidery','screen_and_dtg','screen_and_dtf']);
        }else if (auth()->user()->role == 'Trader' || $request->isTrader == true){
            // No Need any rule for Trader for Order Type. 
        }else{
           // $query->whereIn('orders.type', ['screen_and_embroidery','screen_and_dtg','screen_and_dtf','dtf','vynil','dyesub','embroidery','direct_to_garment','order_others']);

        } */
         
       

       
            if(isset($request->order_type)) {
                /*             $query = $query->where('orders.type', $request->order_type); */

                    switch($request->order_type){
                        case "screen_printing":
                            $query->whereIn('orders.type', ['screen_printing','screen_and_embroidery','screen_and_dtg','screen_and_dtf']);
                        break; 
                        case "direct_to_garment":
                            $query->whereIn('orders.type', ['direct_to_garment','screen_and_dtg']);
                        break;
                        case "embroidery":
                            $query->whereIn('orders.type', ['embroidery','screen_and_embroidery']);
                        break; 
                        case "dtf":
                            $query->whereIn('orders.type', ['dtf','screen_and_dtf']);
                        break; 
                        case "vynil":
                            $query->whereIn('orders.type', ['vynil']);
                        break; 
                        case "dyesub":
                            $query->whereIn('orders.type', ['dyesub']);
                        break; 
                        case "screen_and_embroidery":
                            $query->whereIn('orders.type', ['embroidery','screen_and_embroidery']);
                        break; 
                        case "screen_and_dtg":
                            $query->whereIn('orders.type', ['direct_to_garment','screen_and_dtg']);  
                        break; 
                        case "screen_and_dtf":
                            $query->whereIn('orders.type', ['dtf','screen_and_dtf']);
                        break;  
                        case "order_others":
                            $query->whereIn('orders.type', ['order_others']);
                        break;  
                    } 
            }

        
        if(isset($request->date_order)) {
            if($request->date_order == '14'){
                $request->startDate = \Carbon\Carbon::today()->startOfWeek()->addWeeks(1);
                $request->endDate =  \Carbon\Carbon::today()->endOfWeek()->addWeeks(1);
            }
            if($request->date_order =='7'){
                $request->startDate = \Carbon\Carbon::today()->startOfWeek();
                $request->endDate =  \Carbon\Carbon::today()->endOfWeek();
            }
            if($request->date_order =='2'){
                $request->startDate =  $request->endDate = \Carbon\Carbon::today()->addDays(1);                
            }
            if($request->date_order =='1'){
                $request->startDate =  $request->endDate = \Carbon\Carbon::today();                
            }
            if($request->date_order =='-1' ){
                $request->startDate = \Carbon\Carbon::today()->subDays(10000);  
                $request->endDate =  \Carbon\Carbon::today()->subDays(1);          
            }
            if($request->date_order =='100000' || $request->date_order =='Latest' || $request->date_order =='Soonest'){
                $request->startDate = \Carbon\Carbon::today()->subDays(10000);  
                $request->endDate =  \Carbon\Carbon::today()->addDays(10000);          
            }
            if($request->date_order == 'order_issue'){
                $request->startDate = \Carbon\Carbon::today()->subDays(10000);  
                $request->endDate = \Carbon\Carbon::today()->addDays(1); 
            }
            
                $query = $query->whereBetween('orders.arrival_date',[$request->startDate, $request->endDate]);
             
              
        } 

        if(isset($request->po_number)) {
            $query = $query->where('orders.po_number', 'LIKE', '%'.$request->po_number.'%');
        }

        if(isset($request->tracking_number)) {
            $query = $query->where('orders.tracking_number', 'LIKE', '%'.$request->tracking_number.'%');
        }
 

        switch(auth()->user()->role){
            case "Sales": 
                $query = $query->where('orders.created_by', auth()->user()->id);
            break;
            case "Trader":
                /* $query = $query->where('orders.created_by', auth()->user()->id); */
                 
                $traderId = User::where('created_by', auth()->user()->id)->pluck('id');
                $traderId[] = auth()->user()->id;    
                $isTrader =  $request->isTrader;
                if(isset($request->adminOrder)) {
                    $query = $query->where(function($sqlquery) use($traderId, $isTrader){
                        $sqlquery->whereIn('orders.created_by', $traderId);
                        if($isTrader == true){
                            $sqlquery->orWhereNull('trader_printer_id');
                        }
                    });
                    
                }else{

                    $isTrader =  $request->isTrader;
                    $query = $query->where(function($sqlquery) use($traderId, $isTrader){
                        $sqlquery->whereIn('orders.created_by', $traderId)
                        ->orWhereIn('orders.trader_printer_id', $traderId);
                    /*     if($isTrader == true){
                            $sqlquery->WhereNull('trader_printer_id');
                        } */
                    }); 
                }
            break;
            case "Admin":
                $admin = User::where('role', 'Trader')->get('id');
                $query = $query->where(function($sqlquery) use($admin){
                    $sqlquery->whereNotIn('orders.created_by', $admin)
                    ->orWhere('orders.resource_admin', ['5']);
                });
            break;
            case "Etsy_Admin":
                $query = $query->where('orders.customer_id', '-1');
            break; 
            case "Production":
                $query = $query->where('orders.status', 'Production');
            break; 
        } 


        if(auth()->user()->role == 'Trader') {
           /*  $query = $query->whereNotIn('orders.resource_admin', ['5']); */

            $query = $query->where(function($sqlquery) use($request){
                $sqlquery->whereNotIn('orders.resource_admin', ['5'])
                ->orWhereNull('orders.resource_admin');
            });
        }

 
       

        if (isset($request->art_is_sized)) {
            $query->where('art_is_sized', $request->art_is_sized);
        }

   
        $isTrader =  $request->isTrader;

        if($isTrader == true && auth()->user()->role == 'Admin'){
            $query = $query->where(function($sqlquery) {
                $sqlquery->whereNull('trader_printer_id');
                $sqlquery = $sqlquery->where(function($sqlquery1) {
                    $sqlquery1->whereNull('printer_id')->orWhere('printer_id', 0);  
                    $sqlquery1->whereNull('resource_id')->orWhere('resource_id',0);              
                });
            });
         
        }else{
            $query = $query->where(function($sqlquery) {
                $sqlquery = $sqlquery->where(function($sqlquery1) {
                    $sqlquery1->whereNull('printer_id')->orWhere('printer_id', 0);    
                });
                $sqlquery = $sqlquery->where(function($sqlquery1) { 
                    $sqlquery1->whereNull('resource_id')->orWhere('resource_id',0);     
                });
                $sqlquery = $sqlquery->where(function($sqlquery1) { 
                    $sqlquery1->whereNull('trader_printer_id')->orWhere('trader_printer_id',0);  
                });
              /*   $sqlquery->whereNull('printer_id')
                ->orWhere('printer_id', 0)
                ->orWhereNull('resource_id')
                ->orWhere('resource_id',0); */ 
            });
        }
 
        
        $query = $query->select(['orders.*', 'printers.title as printer_name','resources.name as resource_name',DB::Raw('creators.first_name as creator_name,creators.company_name as companyName,creators.email as creator_email'), 'orders_meta.thread_id_for_message','order_details.production_start_date as production_start_date', 'order_details.product_group_id',])->orderBy('orders.arrival_date', 'ASC');

         
        /* return $query->toSqlWithBindings(); */
        //if($request->get('type') === 'purchasing' || $request->get('type') === 'artwork' || $request->get('type') === 'dashboard' || $request->get('type') === 'checklist'){
            $dataToReturn = $query->paginate(100)->toArray();

            /* $dataToReturn['query'] = DB::getQueryLog(); */
            $getGroupIds = array();  
            foreach($dataToReturn['data'] as $i => $data){
                if(isset($dataToReturn['data'][$i]['product_group_id'])){
                    $getGroupIds[] = $dataToReturn['data'][$i]['product_group_id'];
                    $getOrderIds[$dataToReturn['data'][$i]['product_group_id']] = $dataToReturn['data'][$i]['id'];
                }
            } 
            
            $batchOrders = OrderDetails::select('product_group_id', DB::raw('GROUP_CONCAT(order_id  SEPARATOR ", ") as ids'))
            ->Join('orders','orders.id','=','order_details.order_id')            
            ->whereIn('product_group_id', $getGroupIds)
            ->where('orders.status', 'Production')
            ->groupBy('product_group_id')
            ->get();
            $filterData = array();  
            foreach($dataToReturn['data'] as $i => $data){
                if(isset($dataToReturn['data'][$i]['product_group_id'])){
                    foreach($batchOrders as $j => $details){
                        if($details['product_group_id'] == $dataToReturn['data'][$i]['product_group_id']){
                            $batchedOrderCount = count(explode(', ',$details['ids']));
                            if($batchedOrderCount > 1){
                                $dataToReturn['data'][$i]['group_id'] = $details['ids'];
                            }else{
                                $dataToReturn['data'][$i]['product_group_id'] = null;
                            }
                            
                            foreach($getOrderIds as $getOrderId){
                                if($getOrderId == $dataToReturn['data'][$i]['id']){
                                    $filterData[] = $dataToReturn['data'][$i];
                                } 
                            } 
                        }                        
                    }
                }else{
                    $filterData[] = $dataToReturn['data'][$i];
                }
            }

            $dataToReturn['data'] = $filterData;
            $dataToReturn['code'] = 200;
            $dataToReturn['success'] = true;
            $dataToReturn['message'] = 'Orders List.';

            return response()->json($dataToReturn);
        //}


    }
    public function getAllLabels(Request $request, $orderID){

        $orderID = intval($orderID);
        $labels = PastLabels::where('order_id',$orderID)->get();



        if(count($labels) === 0){
            //create one if possible

            $orderDetails = Order::where('id',$orderID)->first();

            if($orderDetails->shipping_label_url !== null && (@$request->type === 'shipping' || !isset($request->type))){
                $pastLabel = PastLabels::create([
                    'order_id' => $orderID,
                    'label_url' => $orderDetails->shipping_label_url
                ]);
            }

            
        }


        $labels = PastLabels::where([
            'order_id' => $orderID,
            'type' => $request->type !== null ? $request->type : 'shipping'
        ])->get();


        return response([
            'code' => 200,
            'success' => true,
            'message' => 'List of Labels for Order ID: ' .$orderID ,
            'data' => $labels
        ]);

    }

    public function GetOrderDetail(Request $request, $orderID) {

        //auth check

        if(!auth('api')->check()){
            
            //check if validation code is there

            try {

                $accessCodeData = AccessCode::where('order_id' , $orderID)
                ->where('code', $request->code)->first();
                
                if($request->code === null || $accessCodeData === null){
                    return response()->json([
                        'code' => 401,
                        'success' => false,
                        'message' => 'Unauthorized access.',
                    ]);
                }

            }catch(\Exception $e){
                return response()->json([

                    'code' => 401,
                    'success' => false,
                    'message' => 'Unauthorized access.',
                ]);
            }

        }else{
            if(@auth('api')->user()->role !== 'Sales' && @auth('api')->user()->role !== 'Trader' && @auth('api')->user()->role !== 'Admin' && @auth('api')->user()->role !== 'Etsy_Admin' && @auth('api')->user()->role !== 'Customer'){
                return response()->json([
                    'code' => 401,
                    'success' => false,
                    'message' => 'Unauthorized access.',
                ]);
            }   
        }

         $order = Order::select('orders.*','orders.name AS name',DB::Raw('CONCAT(customers.first_name," ",customers.last_name) as customer_name'),DB::Raw('(CASE 
                WHEN printers.title IS NULL THEN resources.name
                ELSE printers.title
            END) as printer_name'),'orders.id AS id')->with(['order_arts', 'printer','orders_meta'])
        ->leftJoin('printers', 'orders.printer_id', '=', 'printers.id')
        ->leftJoin('users as customers', 'orders.customer_id', '=', 'customers.id')
        ->leftJoin('resources', 'orders.resource_id', '=', 'resources.id')->where(['orders.id' => $orderID])->first();

        if($order) {

            $totalCount = 0;
            for($i = 1; $i <= 5; $i++) {
                if($order['pcs_1_'.$i]) {
                    $totalCount += $order['pcs_1_'.$i];
                }
                if($order['pcs_2_'.$i]) {
                    $totalCount += $order['pcs_2_'.$i];

                }
                if($order['pcs_3_'.$i]) {
                    $totalCount += $order['pcs_3_'.$i];

                }
                if($order['pcs_4_'.$i]) {
                    $totalCount += $order['pcs_4_'.$i];
                }

                if($order['xs_'.$i]) {
                    $totalCount += $order['xs_'.$i];
                }
                if($order['s_'.$i]) {
                    $totalCount += $order['s_'.$i];
                }
                if($order['m_'.$i]) {
                    $totalCount += $order['m_'.$i];
                }
                if($order['l_'.$i]) {
                    $totalCount += $order['l_'.$i];
                }
                if($order['xl_'.$i]) {
                    $totalCount += $order['xl_'.$i];
                }
                if($order['xxl_'.$i]) {
                    $totalCount += $order['xxl_'.$i];
                }               
                if($order['xxxl_'.$i]) {
                    $totalCount += $order['xxxl_'.$i];
                } 
                if($order['other_size_text_1_'.$i]) {
                    $totalCount += $order['other_size_text_1_'.$i];
                } 
                if($order['other_size_text_2_'.$i]) {
                    $totalCount += $order['other_size_text_2_'.$i];
                } 
                if($order['other_size_text_3_'.$i]) {
                    $totalCount += $order['other_size_text_3_'.$i];
                } 
                if($order['other_size_text_4_'.$i]) {
                    $totalCount += $order['other_size_text_4_'.$i];
                } 
                if($order['other_size_text_5_'.$i]) {
                    $totalCount += $order['other_size_text_5_'.$i];
                } 
            }

            $order['total_product_count'] = $totalCount;

            if($request->page == 'resources') {

                
                if($order['proof_url'] !== null){
                    $proofFileName = basename($order['proof_url']);
                    $order->order_arts[count($order->order_arts)] = [
                        'id' => 0,
                        'file_url' => $order['proof_url'],
                        'filename' => 'Proof File',
                        'aws_url' => 'proof.jpg',
                        'order_id' => $order['id'],
                        'created_at' => $order['created_at']
                    ];
                }
                if($order['film_file'] !== null){
                    $order->order_arts[count($order->order_arts)] = [
                        'id' => 0,
                        'file_url' => $order['film_file'],
                        'filename' => 'Film File',
                        'aws_url' => 'film.jpg',
                        'order_id' => $order['id'],
                        'created_at' => $order['created_at']
                    ];
                }
                if($order['shipping_label_url'] !== null){
                    $order->order_arts[count($order->order_arts)] = [
                        'id' => 0,
                        'file_url' => $order['shipping_label_url'],
                        'filename' => 'Shipping Label ',
                        'aws_url' => 'shipping_label.jpg',
                        'order_id' => $order['id'],
                        'created_at' => $order['created_at']
                    ];
                }
                if($order['packing_list_url'] !== null){
                    $order->order_arts[count($order->order_arts)] = [
                        'id' => 0,
                        'file_url' => $order['packing_list_url'],
                        'filename' => 'Packing List',
                        'aws_url' => 'packing_list.jpg',
                        'order_id' => $order['id'],
                        'created_at' => $order['created_at']
                    ];
                }


               
            
            }
            if($order['invoice_number'] !== null){
                $queryInvoiceIdData = DB::table('orders')->where('invoice_number', $order['invoice_number'])->get(['id']);             
                $order['invoice_id'] = $queryInvoiceIdData;                 
            }else{
                $order['invoice_id'] = null;
            }
 

               
            $past_labels = DB::table('past_labels')->where('order_id', $order['id'])->get(); 
            if($past_labels){
                $order['artwork_timestamp'] = $past_labels; 
            }else{
                $order['artwork_timestamp'] = "";
            }
                
            
                
    
            
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Order Detail.',
                'data' => $order
            ]);
        } else {
            return  response([
                'code' => 404,
                'success' => false,
                'message' => 'No order found',
            ]);
        }
    }

    // OBS - For search order - Chat push
    public function GetOrderDetails(Request $request, $orderID) {

        //auth check

        if(!auth('api')->check()){

            //check if validation code is there

            try {

                /* $accessCodeData = AccessCode::where(['order_id' => $orderID, 'code' => $request->code])->first(); */
                $accessCodeData = AccessCode::where('order_id' , $orderID)
                ->where('code', $request->code)->first();

                if($request->code === null || $accessCodeData === null){
                    return response()->json([
                        'code' => 401,
                        'success' => false,
                        'message' => 'Unauthorized access.',
                    ]);
                }

            }catch(\Exception $e){
                return response()->json([

                    'code' => 401,
                    'success' => false,
                    'message' => 'Unauthorized access.',
                ]);
            }

        }else{
            if(@auth('api')->user()->role !== 'Sales' && @auth('api')->user()->role !== 'Admin'){
                return response()->json([
                    'code' => 401,
                    'success' => false,
                    'message' => 'Unauthorized access.',
                ]);
            }   
        }
    
        $order = Order::with(['order_arts', 'printer'])->where('id','like','%'. $orderID)->get();
   
        if($order){
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Order Detail.',
                'data' => $order
            ]);
        } else {
            return  response([
                'code' => 404,
                'success' => false,
                'message' => 'No order found',
            ]);
        }
    }


    //updateBoxWeight
    public function updateBoxWeight(Request $request, $orderID) {
        $order = Order::where('id', $orderID)->update(array('weight_'.$request->boxId => $request->boxValue));
        if($order) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Order successfully deleted.'
            ]);
        }else{
            return response([
                'code' => 400,
                'success' => false,
                'message' => 'Not Updated'
            ]);
        }
    }

    //OBS

    public function DeleteOrder(Request $request, $orderID) {
        $order = Order::find($orderID);
        if($order) {
            if($order->delete()) {

                ActivityNotif::create([
                    'order_id' => $orderID,
                    'title' => 'Order Deleted  - ' . $orderID,
                    'description' => $order->name,
                    'initiated_by' => $order->created_by,
                    'action' => 'order_deleted',
                    'type' => 'order_status' 
                ]);

                return response([
                    'code' => 200,
                    'success' => true,
                    'message' => 'Order successfully deleted.'
                ]);
            } else {
                return response([
                    'code' => 500,
                    'success' => false,
                    'message' => 'Something went wrong, Try again later.'
                ]);
            }
        } else {
            return  response([
                'code' => 404,
                'success' => false,
                'message' => 'No order found',
            ]);
        }
    }

    public function filename($file){
        return pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
    }

    public function nullFilter($text){
        return $text !== 'null' ? $text : null;
    }

    public function Create(Request $request) { 
        
        if(!$request->defaultTradeOrder){
            $validator = Validator::make($request->all(), [
                'customer_id' => 'required',
                'name' => 'required|max:150',
                'type' => 'required',
                'arrival_type' => 'required',
                'arrival_date' => 'required'
            ]);

            if ($validator->fails()) {
                return response([
                    'code' => 400,
                    'success' => false,
                    'message' => Misc::FirstValidationMessage($validator->errors()),
                    'errors' => $validator->errors()
                ]);
            }
        }




        $order = new Order;
        $vendorCount = false;
        switch(auth()->user()->role){
            case "Customer":
                $customerId = auth()->user()->id;
            break;
            case "Trader": 
                if($request->defaultTradeOrder){
                    $customerId = auth()->user()->id;
                }else{                    
                    $customerId = $request->customer_id;
                }
               
            break;
            default:
                $customerId = $request->customer_id;
            break;
        }

        if(auth()->user()->role != 'Trader'){
            $resourceId = Resource::where(['isPrimary' => 'true', 'is_deleted' => '0', 'order_type' => $request->type])->first();
        }
        

        if(isset($resourceId->id)){
            $order->resource_id = $resourceId->id;
        } 

        $order->customer_id = $customerId;
        $order->created_by = auth()->user()->id;

        $order->name = $request->name;
        $order->type = $request->type;

        $order->boxes = $request->boxes;
        $order->weight = $request->weight;

        $order->type_notes = $request->type_notes;
        $order->multiple_pages = isset($request->multiple_pages) && $request->multiple_pages == 'true' ? true: false;

        $order->match_proof_color = isset($request->match_proof_color) && $request->match_proof_color == 'true' ? true: false;

        $order->arrival_type = $request->arrival_type;
        $order->arrival_other = $request->arrival_other;
        $order->arrival_date = $request->arrival_date;
        $order->hard_due_date = isset($request->hard_due_date) && $request->hard_due_date == 'true' ? true: false;
   
        /* $order->art_is_sized = isset($request->art_is_sized) && $request->art_is_sized == 'true' ? true : false; */	
        /* $order->film = isset($request->film) && $request->film == 'true' ? true : false; */	
        if($request->artfile){	
            $order->art_is_sized = 1;	
        } 	

        if($request->order_arts_to_copy !== null){
            $orderArtsCount = count(explode(",",$request->order_arts_to_copy));
            if($orderArtsCount  > 0){
                $order->art_is_sized = 1;	
            }
        }

        if($request->film_file){	
            $order->film = 1;	
        }
        if($request->trader_printer_id){	
            $order->trader_printer_id = $request->trader_printer_id;	
        }
        if($request->resource_id){	
            $order->resource_id = $request->resource_id;	
        }
        if($request->resource_admin){	
            $order->resource_admin = $request->resource_admin;	
        }
 
        if($request->printer_id){	
            $order->printer_id = $request->printer_id;	
        }
        $order->tracking_number = $request->tracking_number;
        $order->manual_tracking_url = $request->manual_tracking_url;
        
        $order->art_notes = $request->art_notes;


        $order->color_1 = $request->color_1;
        $order->color_2 = $request->color_2;
        $order->color_3 = $request->color_3;
        $order->color_4 = $request->color_4;
        $order->color_5 = $request->color_5;
        $order->color_6 = $request->color_6;

        $order->color_1_pantone = $request->color_1_pantone;
        $order->color_2_pantone = $request->color_2_pantone;
        $order->color_3_pantone = $request->color_3_pantone;
        $order->color_4_pantone = $request->color_4_pantone;
        $order->color_5_pantone = $request->color_5_pantone;
        $order->color_6_pantone = $request->color_6_pantone;

        $order->color_notes = $request->color_notes;

        $order->payment_invoice_url = $request->payment_invoice_url;
        $order->payment_notes = $request->payment_notes;
        $order->payment_terms = isset($request->payment_terms) && $request->payment_terms == 'true'  ? true: false;
        

        $order->ship_type = $request->ship_type;
        $order->ship_notes = $request->ship_notes;
        $order->ship_terms = isset($request->ship_terms) && $request->ship_terms == 'true' ? true: false;


        $order->customer_name = $request->customer_name;
        $order->customer_attn = $request->customer_attn;
        $order->customer_track_url = $request->customer_track_url;
        $order->customer_notes = $request->customer_notes;
        $order->customer_address = $request->customer_address;
        $order->customer_address_2 = $request->customer_address_2;

        $order->shipping_instructions = $request->shipping_instructions;
        $order->shipping_amt  = $request->shipping_amt;

        $order->customer_state = $request->customer_state;
        $order->customer_zipcode = $request->customer_zipcode;
        $order->customer_email = $request->customer_email;
        $order->customer_phone = $request->customer_phone;
 
        $order->setup_name = $request->setup_name;
        $order->setup_screen_1 = $request->setup_screen_1;
        $order->setup_screen_2 = $request->setup_screen_2;
        $order->setup_notes = $request->setup_notes;

        $order->proof_notes = $request->proof_notes;

        $order->position_front = $request->position_front;
        $order->position_back = $request->position_back;
        $order->position_right_left = $request->position_right_left;
        $order->position_additional = $request->position_additional;
        $order->position_notes = $request->position_notes;
        $order->customer_city = $request->customer_city;
        $order->extra_services = $request->extra_services;
        $order->extra_cost_each = $request->extra_cost_each;
        $order->full_color_count = $request->full_color_count;
        $order->placements = $request->placements;
        $order->extra_service_each_cost = isset($request->extra_service_each_cost) && $request->extra_service_each_cost == 'true'  ? true: false;
        $order->adjust_placement = isset($request->adjust_placement) && $request->adjust_placement != '' ? $request->adjust_placement: false;
        $order->adjust_placement_style = isset($request->adjust_placement_style) && ($request->adjust_placement_style == 'true' || $request->adjust_placement_style == '1') ? true: false;
        $order->multiple_size_art = isset($request->multiple_size_art) && ($request->multiple_size_art == 'true' || $request->multiple_size_art == '1') ? true: false;
       

        $order->artwork_front = $request->artwork_front;
        $order->artwork_back = $request->artwork_back;
        $order->artwork_right_left = $request->artwork_right_left;
        $order->artwork_additional = $request->artwork_additional;
        $order->artwork_sizing = isset($request->artwork_sizing) && $request->artwork_sizing != '' ? $request->artwork_sizing: false;

        $order->match_proof_position = isset($request->match_proof_position) && $request->match_proof_position == 'true' ? true: false;
        
        $order->invoice_number = $request->invoice_number;

        $orderType = UserOrderType::where('name',$request->type)->first();
        if($orderType){
            if($orderType->film){
                $order->film = 1;
            }
            if($orderType->apparel){
                $order->apparel = 1;
            }
            if($orderType->art){
                $order->art_is_sized = 1;
            }
            if($orderType->payment){
                $order->film = 1;
            }
        }

        /* 

        $customerUser = User::where(['id' => $customerId])->first();

        $order->pay = $customerUser->terms === 'true';   */

        $order->pay = isset($request->pay) && ($request->pay == 'true' || $request->pay == '1')  ? true: false; 

        /* if(($order->payment_terms == 'true' || $order->payment_terms == '1' ) || ($order->pay == 'true' || $order->pay == '1')){
            $order->pay = true;
        } */
            
         
 

        $order->status = isset($request->status) && $request->status == 'Draft'  ? 'Draft': 'Processing';

        $apparelCount = 0;
        $isPurchasedCount = 0; 
        $isVendorOrders = 0;
        for($i = 1; $i <= 5; $i++) {
            $order['product_user_type_'.$i] = $this->nullFilter($request['product_user_type_'.$i]);
            $order['product_user_other_type_'.$i] = $this->nullFilter($request['product_user_other_type_'.$i]);
            $order['per_piece_'.$i] = $this->nullFilter($request['per_piece_'.$i]);
            $order['tax_'.$i] = isset($request['tax_'.$i]) && $request['tax_'.$i] == 'true' ? true : false;
            $order['item_number_'.$i] = $this->nullFilter($request['item_number_'.$i]);
            $order['apparel_type_'.$i] = $this->nullFilter($request['apparel_type_'.$i]);
            $order['product_color_'.$i] = $this->nullFilter($request['product_color_'.$i]);
            $order['brand_name_'.$i] = $this->nullFilter($request['brand_name_'.$i]);
            $order['product_description_'.$i] = $this->nullFilter($request['product_description_'.$i]);
            $order['product_apparel_source_'.$i] = $this->nullFilter($request['product_apparel_source_'.$i]);
            $order['product_apparel_source_other_'.$i] = $this->nullFilter($request['product_apparel_source_other_'.$i]);
            $order['location_'.$i] = $this->nullFilter($request['location_'.$i]);
            $order['xs_'.$i] = $this->nullFilter($request['xs_'.$i]);
            $order['s_'.$i] = $this->nullFilter($request['s_'.$i]);
            $order['m_'.$i] = $this->nullFilter($request['m_'.$i]);
            $order['l_'.$i] = $this->nullFilter($request['l_'.$i]);
            $order['xl_'.$i] = $this->nullFilter($request['xl_'.$i]);
            $order['xxl_'.$i] = $this->nullFilter($request['xxl_'.$i]);
            $order['xxxl_'.$i] = $this->nullFilter($request['xxxl_'.$i]);
            $order['other_size_1_'.$i] = $this->nullFilter($request['other_size_1_'.$i]);
            $order['other_size_text_1_'.$i] = $this->nullFilter($request['other_size_text_1_'.$i]);
            $order['pcs_1_'.$i] = $this->nullFilter($request['pcs_1_'.$i]);
            $order['other_size_2_'.$i] = $this->nullFilter($request['other_size_2_'.$i]);
            $order['other_size_text_2_'.$i] = $this->nullFilter($request['other_size_text_2_'.$i]);
            $order['pcs_2_'.$i] = $this->nullFilter($request['pcs_2_'.$i]);
            $order['other_size_3_'.$i] = $this->nullFilter($request['other_size_3_'.$i]);
            $order['other_size_text_3_'.$i] = $this->nullFilter($request['other_size_text_3_'.$i]);
            $order['pcs_3_'.$i] = $this->nullFilter($request['pcs_3_'.$i]);
            $order['other_size_4_'.$i] = $this->nullFilter($request['other_size_4_'.$i]);
            $order['other_size_text_4_'.$i] = $this->nullFilter($request['other_size_text_4_'.$i]);
            $order['pcs_4_'.$i] = $this->nullFilter($request['pcs_4_'.$i]);
            $order['price_'.$i] = $this->nullFilter($request['price_'.$i]);
            $order['pickup_'.$i] = isset($request['pickup_'.$i]) && $request['pickup_'.$i] == 'true' ? true : false;

            if($order['product_apparel_source_'.$i] !== null
                    || $order['xs_'.$i] !== null
                    || $order['s_'.$i] !== null
                    || $order['m_'.$i] !== null
                    || $order['l_'.$i] !== null
                    || $order['xl_'.$i] !== null
                    || $order['xxl_'.$i] !== null
                    || $order['xxxl_'.$i] !== null
                    || $order['other_size_text_1_'.$i] !== null
                    || $order['other_size_text_2_'.$i] !== null
                    || $order['other_size_text_3_'.$i] !== null
                    || $order['other_size_text_4_'.$i] !== null)
                    { $apparelCount++; }

            if($order['is_ordered_'.$i] === 1 || $order['product_apparel_source_'.$i] === 'provided')
                    { $isPurchasedCount++; }

            if(isset($order['product_apparel_source_'.$i]) && $order['product_apparel_source_'.$i] != 'provided' && $order['product_apparel_source_'.$i] != 'inventory' && $order['product_apparel_source_'.$i] != 'apparel_others')
            { $isVendorOrders++; }
        }
        for($i = 1; $i <= 9; $i++) {
            $order['weight_'.$i] = $request['weight_'.$i];
        }

        $order['apparel_row_count'] = $apparelCount;
        $order['is_purchased_row_count'] = $isPurchasedCount;

        
        if($order->save()) {

            $orderID = $order->id;

            /* Code - Start */
            $orderMetaData = [];
            $tracking = [];
            foreach([1,2,3,4,5] as $num){
                if($this->isJson($request->post('product_'.$num.'_json'))){
                    $orderMetaData['product_'. $num .'_json'] = $request->{'product_'.$num.'_json'};
                }
                if($this->isJson($request->post('ss_references_'.$num))){
                    $orderMetaData['ss_references_'.$num] = $request->{'ss_references_'.$num};
                }
                if($this->nullFilter($request['receiving_tracking_'.$num])){
                    $tracking[] = $request->{'receiving_tracking_'.$num};
                }else{
                    $tracking[] = '';
                }
            }
            $purchasingData = ['data' => $tracking];
            $orderMetaData['purchasing_tracking'] = json_encode($purchasingData);

            if(count($orderMetaData) > 0){ 
                OrderMeta::updateOrInsert(['order_id' => $orderID],$orderMetaData);
            }

            /* Code - End */

            AccessCode::create([
                'order_id' => $orderID,
                'code' => md5(microtime(true))
            ]);

            
            if($isVendorOrders > 0  && $order->pay == 'true'){
                $time = \Carbon\Carbon::now(); 
                $uniqueKey = $orderID .'-'.'VendorOrderPlacement';
                OrderEmailQueue::updateOrInsert(['order_id' => $uniqueKey],[
                    'order_id' => $orderID,
                    'email_type' => 'VendorOrderPlacement',
                    'created_at' => $time,
                    'updated_at' => $time
                ]);
                $vendorCount = true;
            }


            ActivityNotif::create([
                'order_id' => $orderID,
                'title' => 'New Order Is Created  - ' . $orderID,
                'description' => $order->name,
                'initiated_by' => $order->created_by,
                'action' => 'order_created',
                'type' => 'order_status' 
            ]);

            if(@$request->product_id !== null){
                $productData = Product::where(['id' => $request->product_id])->first();
                $productGroupId = $productData->product_group_id;
            }

            OrderDetails::create([
                'order_id' => $orderID, 
                'product_id' => $request->product_id,
                'product_group_id' => @$productGroupId
            ]);

            $orderUpdate = Order::find($orderID);

            try {

                $user = User::find($order->customer_id);
                $shipStation = app(\LaravelShipStation\ShipStation::class);

                $address = new \LaravelShipStation\Models\Address();

                $address->name = $order->customer_name;
                $address->city = $order->customer_city;
                $address->company = $order->customer_attn; 
                $address->street2 = $order->customer_address_2;
                $address->street1 = $order->customer_address;
                $address->state = $order->customer_state;
                $address->postalCode = $order->customer_zipcode;
                $address->country = "US";
                $address->phone = $order->customer_phone;


                $item = new \LaravelShipStation\Models\OrderItem();

                $item->lineItemKey = $order->id;
                $item->name = $order->name;
                $item->quantity = 0; // TODO Total Quantity
                $item->unitPrice  = '0.00';
                // $item->warehouseLocation = 'Warehouse A';

                $orderDe = new \LaravelShipStation\Models\Order();

                $orderDe->orderNumber = $order->id;
                $orderDe->orderKey = $order->id;
                $orderDe->orderDate = $order->arrival_date;
                $orderDe->orderStatus = 'awaiting_shipment';
                if ($user !== null && $user->shipping_email) {
                    $orderDe->customerEmail = $user->shipping_email ? $user->shipping_email : $user->email;
                }
                $orderDe->amountPaid = '0.00';
                $orderDe->taxAmount = '0.00';
                $orderDe->shippingAmount = '0.00';
                $orderDe->internalNotes = '...';
                $orderDe->billTo = $address;
                $orderDe->shipTo = $address;
                $orderDe->items[] = $item;

                $shipStationResponse =  $shipStation->orders->post($orderDe, 'createorder');
                if($shipStationResponse) {
                    $orderUpdate->shipping_order_id = $shipStationResponse->orderId;
                    $orderUpdate->order_key = $orderID;
                }
            } catch (\Exception $e) {
          
            }

            if($request->shipping_label_url !== null) {

                $folder = $orderID.'/shipping_label';
                $extension = $request->shipping_label_url->getClientOriginalExtension();

                $originalName = $this->filename($request->shipping_label_url);
                $originalName = preg_replace('/\W+/', '-', $originalName);
                $newName = $originalName."_".intval(microtime(true));

                $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->shipping_label_url, $newName.'.'.$extension, 'public');
                $orderUpdate->shipping_label_url = env('AWS_URL').$uploadPath;
 

                $pastLabel = PastLabels::create([
                    'order_id' => $orderID,
                    'label_url' => $orderUpdate->shipping_label_url
                ]);

            }

            if($request->packing_list_url !== null) {
                $folder = $orderID.'/packing_list';
                $extension = $request->packing_list_url->getClientOriginalExtension();
                $originalName = $this->filename($request->packing_list_url);
                $originalName = preg_replace('/\W+/', '-', $originalName);
                $newName = $originalName."_".intval(microtime(true));
                $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->packing_list_url, $newName.'.'.$extension, 'public');
                $orderUpdate->packing_list_url = env('AWS_URL').$uploadPath;

                $pastLabel = PastLabels::create([
                    'order_id' => $orderID,
                    'label_url' => $orderUpdate->packing_list_url,
                    'type' => 'packing'
                ]);
            }

            if($request->proof_url) {
                if (filter_var($request->proof_url, FILTER_VALIDATE_URL)) {
                    $orderUpdate->proof_url = $request->proof_url;
                } else {
                    $folder = $orderID.'/proof';
                    $originalName = $this->filename($request->proof_url);
                    $originalName = preg_replace('/\W+/', '-', $originalName);
                    $newName = $originalName."_".intval(microtime(true));
                    $extension = $request->proof_url->getClientOriginalExtension();



                    $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->proof_url, $newName.'.'.$extension, 'public');
                    $orderUpdate->proof_url = env('AWS_URL').$uploadPath;

                    if( $extension === 'jpg' || $extension === 'jpeg' ||   $extension === 'png' || $extension === 'gif' ){
                        $thumb_tmp_path="../storage/tmp/". $newName . '.' . $extension;
                        $this->resize_crop_image(300,   $request->proof_url, $thumb_tmp_path);
                        $uploadThumbnailPath = \Storage::disk('s3')->putFileAs($folder .'/thumbnail', $thumb_tmp_path, $newName . '.' . $extension, 'public');
                        $orderUpdate->proof_url = env('AWS_URL') . $uploadThumbnailPath; 
                        unlink($thumb_tmp_path);
                    }
                }
            }

 

            if($request->film_file) { 
                if (filter_var($request->film_file, FILTER_VALIDATE_URL)) {
                    $orderUpdate->film_file = $request->film_file;
                } else {
                    $folder = $orderID.'/film_file';
                    $originalName = $this->filename($request->film_file);
                    $originalName = preg_replace('/\W+/', '-', $originalName);
                    $newName = $originalName."_".intval(microtime(true));
                    $extension = $request->film_file->getClientOriginalExtension();
                    $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->film_file, $newName.'.'.$extension, 'public');
                    $orderUpdate->film_file = env('AWS_URL').$uploadPath;
        
                    if( $extension === 'jpg' || $extension === 'jpeg' ||   $extension === 'png' || $extension === 'gif' ){
    

                        $thumb_tmp_path="../storage/tmp/". $newName . '.' . $extension;
                        $this->resize_crop_image(300,   $request->film_file, $thumb_tmp_path);
                        $uploadThumbnailPath = \Storage::disk('s3')->putFileAs($folder .'/thumbnail', $thumb_tmp_path, $newName . '.' . $extension, 'public');
                        $orderUpdate->film_file = env('AWS_URL') . $uploadThumbnailPath; 
                        unlink($thumb_tmp_path); 
                    }
                }
            }else{
                if($request->film_name_url.'' !== ''){
                    $orderUpdate->film_file = $request->film_name_url;
                }
            }
    
            if($request->order_arts_to_copy !== null){
                $orderArtsToCopy = explode(",",$request->order_arts_to_copy);
                $orderArts = OrderArt::whereIn('id',$orderArtsToCopy)->get();
                foreach($orderArts as $orderArt){
                    $newOrderArt = new OrderArt;
                    $newOrderArt->order_id = $order->id;
                    $newOrderArt->aws_key = $order->id."/art/".$orderArt->filename;
                    $productGroupID = $orderArt->order_id; //technically product_id
                    $newOrderArt->filename = $orderArt->filename;
                    $uploadThumbnailPath = $order->id."/art/thumbnail/".$orderArt->filename;
                    $newOrderArt->file_url = env('AWS_URL') . $uploadThumbnailPath; 
                    
                    $newOrderArt->save();
                    \File::copyDirectory(public_path("assets/products/$productGroupID/art"), public_path("assets/".$order->id."/art"));
                }
            }
            
            if($request->artfile) {
                foreach($request->artfile as $file) {
                    $folder = $orderID.'/art';
                    $originalName = $this->filename($file);
                    $originalName = preg_replace('/\W+/', '-', $originalName);
                    $fileName = $originalName."_".Misc::GenerateToken(10).'.'.$file->getClientOriginalExtension();
                    $uploadPath = \Storage::disk('s3')->putFileAs($folder, $file, $fileName, 'public');
                    $extension = $file->getClientOriginalExtension();
                    $orderArt = new OrderArt;
                    $orderArt->order_id = $order->id;
                    $orderArt->filename = $fileName;
                    $orderArt->aws_key = $uploadPath;
                    $orderArt->file_url = env('AWS_URL').$uploadPath;
                    if( $extension === 'jpg' || $extension === 'jpeg' ||   $extension === 'png' || $extension === 'gif' ){
                        $thumb_tmp_path="../storage/tmp/". $fileName;
                        $this->resize_crop_image(300,   $file, $thumb_tmp_path);
                        $uploadThumbnailPath = \Storage::disk('s3')->putFileAs($folder .'/thumbnail', $thumb_tmp_path, $fileName, 'public');
                        $orderArt->file_url = env('AWS_URL') . $uploadThumbnailPath; 
                        unlink($thumb_tmp_path);
                    }
                    
                    $orderArt->save();
                }

                
            }

            if($request->duplicateOldOrderId){
                $oldOrderID = "/". $request->duplicateOldOrderId . "/";
                $newOrderID = "/". $orderID . "/";
                $orderUpdate->proof_url = str_replace($oldOrderID, $newOrderID, $orderUpdate->proof_url);
                $orderUpdate->film_file = str_replace($oldOrderID, $newOrderID, $orderUpdate->film_file);
                $orderUpdate->status = 'Processing';
                $orderUpdate->art_is_sized = $request->art_is_sized;
                $orderArts = OrderArt::where(['order_id' => $request->duplicateOldOrderId, 'table_name' => 'orders'])->get();
 
                foreach($orderArts as $orderArt)
                {  
                    $orderArt = OrderArt::find($orderArt->id)->replicate();
                    $orderArt->file_url = str_replace($oldOrderID, $newOrderID, $orderArt->file_url);
                    $orderArt->order_id = $orderID;
                    $orderArt->save(); 
                }
     
                $sourceDir = "public/assets/". $request->duplicateOldOrderId;
                $destinationDir = "public/assets/". $orderID;
                $success = File::copyDirectory(base_path($sourceDir), base_path($destinationDir));
                
            }

            $orderUpdate->update();

            try{ 

                if($request->tracking_number){

                    $trackingNumber = $request->tracking_number;

                    $guzzle = new Guzzle\Client([
                        'base_uri' => 'https://api.aftership.com/v4/',
                        'headers' => [ 
                            'as-api-key' => env('AFTERSHIP_DEFAULT'),
                            'Content-Type' => 'application/json'
                        ]
                    ]);
        

                    $tracking = $guzzle->get('trackings?keyword='.$trackingNumber); 
                        
                    $trackingDetailsResults = json_decode($tracking->getBody()->getContents());   
                   
                    $isNewTrackingNumber = false;
                    if(!$trackingDetailsResults->data->trackings) {
                            
                        $guzzle->post('trackings', [
                            'body' => json_encode(['tracking' => [
                                'tracking_number' => $trackingNumber
                            ]])
                        ]);  

                    } 
                }
            }catch(Exception $e){

            }

            return response([
                'code' => 200,
                'success' => true,
                'message' => 'New order created.',
                'vendorCount' => $vendorCount,
                'data' => $orderUpdate
            ]);

        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }

    }

    public function UploadFilm(Request $request, $orderID) {
        $validator = Validator::make($request->all(), [
            'film_file' => 'required',
        ]);

        if ($validator->fails()) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => Misc::FirstValidationMessage($validator->errors()),
                'errors' => $validator->errors()
            ]);
        }

        $order = Order::find($orderID);
        if(!$order) {
            return  response([
                'code' => 404,
                'success' => false,
                'message' => 'No order found',
            ]);
        }


        if($request->film_file) { 

            $folder = $orderID.'/film_file';
            $originalName = $this->filename($request->film_file);
            $originalName = preg_replace('/\W+/', '-', $originalName);
            $newName = $originalName."_".intval(microtime(true));
            $extension = $request->film_file->getClientOriginalExtension();
            $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->film_file, $newName.'.'.$extension, 'public');
            $order->film_file = env('AWS_URL').$uploadPath;

            if( $extension === 'jpg' || $extension === 'jpeg' ||   $extension === 'png' || $extension === 'gif' ){
 
                $thumb_tmp_path="../storage/tmp/". $newName . '.' . $extension;
                $this->resize_crop_image(300,   $request->film_file, $thumb_tmp_path);
                $uploadThumbnailPath = \Storage::disk('s3')->putFileAs($folder .'/thumbnail', $thumb_tmp_path, $newName . '.' . $extension, 'public');
                $order->film_file = env('AWS_URL') . $uploadThumbnailPath; 
                unlink($thumb_tmp_path);    
            }
        }

        $order->film = 1;
        $order = $this->updateStatusToProduction($order); 
  
        if($order->update()) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Film file uploaded.',
                'data' => $order
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }


    }

    
    public function UploadArtFile(Request $request, $orderID) {
        $validator = Validator::make($request->all(), [
            'file_url' => 'required',
        ]);

        if ($validator->fails()) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => Misc::FirstValidationMessage($validator->errors()),
                'errors' => $validator->errors()
            ]);
        }

        $order = Order::find($orderID);
        if(!$order) {
            return  response([
                'code' => 404,
                'success' => false,
                'message' => 'No order found',
            ]);
        }

          if($request->file_url) {
            /* foreach($request->file_url as $file) { */
                //var_dump($file);
                $folder = $orderID.'/art';
                $fileName = Misc::GenerateToken(10).'.'.$request->file_url->getClientOriginalExtension();
                $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->file_url, $fileName, 'public');
                $extension = $request->file_url->getClientOriginalExtension();                
                $orderArt = new OrderArt;
                $orderArt->order_id = $orderID;
                $orderArt->filename = $fileName;
                $orderArt->aws_key = $uploadPath;
                $orderArt->file_url = env('AWS_URL').$uploadPath;

                if( $extension === 'jpg' || $extension === 'jpeg' ||   $extension === 'png' || $extension === 'gif' ){
                    $thumb_tmp_path="../storage/tmp/". $fileName;
                    $this->resize_crop_image(300,   $request->file_url, $thumb_tmp_path);
                    $uploadThumbnailPath = \Storage::disk('s3')->putFileAs($folder .'/thumbnail', $thumb_tmp_path, $fileName, 'public');
                    $orderArt->file_url = env('AWS_URL') . $uploadThumbnailPath; 
                    unlink($thumb_tmp_path);
                }

                $orderArt->save();
            /* } */
        }  
 
        $order->art_is_sized = 1;
        $order = $this->updateStatusToProduction($order); 
         
        if($order->update()) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Art file uploaded.',
                'data' => $request->file_url
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }


    }

    public function DeliveryStatusLog(Request $request){

        //verify uber signature

        $hmac = new Hmac();
        $requestSignature = $request->Header('x-uber-signature');
        $secretKey = env('UBER_WEBHOOK_SIGNING_KEY');
        $fullData = $request->getContent();
        $createdSignature = hash_hmac('sha256', $fullData, $secretKey);

        if(hash_equals($createdSignature,$requestSignature)){
            $fullData = json_decode($fullData); 
            \Log::emergency('Order Data: ' . json_encode($fullData));

            //set delivery status to pending
            $orderId = $fullData->data->external_id;
            \Log::emergency('Order ID: ' . $orderId);
            //update order to its current delivery status
            OrderDetails::where(['order_id' => $orderId])->update(['uber_was_delivered' => $fullData->data->status]);
            if($fullData->data->status === 'pending'){
                $orderDetails = Order::where(['id' => $orderId])->first();
                //if status is pending, text the store that an order was scheduled for delivery
                $userDetailsForPickup = User::where(['id' => env('USER_ID_FOR_UBER_PICKUP')])->first();
                $customerPhone = '+1'. @$orderDetails->customer_phone;
                $note = 
'Order #'. $orderDetails->id .' ('.$orderDetails->name.') has been shipped via Uber, and is awaiting delivery. Please have it be ready for delivery.

If you want to cancel this delivery, go to '. env("APP_URL") .'/cancel_order/'. $fullData->data->id;
                \Log::emergency('Note: '. $note);
                Twilio::message('+1'.$orderDetails->customer_phone, $note);
            }
        }
    }


    public function UpdateOrder(Request $request, $orderID) {
        // $validator = Validator::make($request->all(), [
        //     'customer_id' => 'required',
        //     'name' => 'required|max:150',
        //     'type' => 'required',
        //     'arrival_type' => 'required',
        //     'arrival_date' => 'required'
        // ]);

        // if ($validator->fails()) {
        //     return response([
        //         'code' => 400,
        //         'success' => false,
        //         'message' => Misc::FirstValidationMessage($validator->errors()),
        //         'errors' => $validator->errors()
        //     ]);
        // }
     
        
        $order = Order::find($orderID);
        $orderDetails = OrderDetails::where(['order_id' => $orderID])->first();

        if($request->customer_id == '-1') {
            $getUserId = User::where(['email' => $order->customer_email])->first();
            $request->customer_id = $getUserId->id;
        }
       
        if(!$order) {
            return  response([
                'code' => 404,
                'success' => false,
                'message' => 'No order found',
            ]);
        }
        $vendorCount = false;
        if($request->post('actual_shipped') !== null){
            /* $order->actual_shipped = DB::Raw('NOW()'); */
            $order->actual_shipped = \Carbon\Carbon::now();

            $labels = PastLabels::where(['order_id' => $orderID, 'type' => 'shipping'])->get();

            $labelUrls = [];
            
            $arrivalDate = date("D,F jS", strtotime($order->arrival_date));
             

            foreach($labels as $i => $label){

                $metadata = json_decode($label->metadata);

                if(isset($metadata->shipstation)){

                    if(@$metadata->shipstation->carrierCode === null){
                        $metadata->shipstation->carrierCode = $metadata->shipstation->carriers_code;
                    }

                    switch(@$metadata->shipstation->carrierCode){
                        case "fedex":
                            $labelUrls[count($labelUrls)] = 'https://www.fedex.com/fedextrack/?action=track&trackingnumber='.$metadata->tracking_number; 
                        break;
                        case "stamps_com":
                            $labelUrls[count($labelUrls)] = 'https://tools.usps.com/go/TrackConfirmAction.action?tLabels='.$metadata->tracking_number;
                        break;
                        case "ups_walleted":
                            $labelUrls[count($labelUrls)] = 'http://wwwapps.ups.com/WebTracking/processRequest?HTMLVersion=5.0&Requester=NES&AgreeToTermsAndConditions=yes&loc=en_US&tracknum='.$metadata->tracking_number;
                        break;
                    }
                }                
            }

            if($order->update()) {

              
                ActivityNotif::create([
                    'order_id' => $order->id,
                    'title' => 'Order Shipped: ' . $orderID,
                    'description' => $order->name,
                    'initiated_by' => $order->created_by,
                    'action' => 'order_shipped',
                    'type' => 'admin' 
                ]);

                $sendMailToCreator = User::where(['id' => $order->created_by])->first();
                $userToSendTo = User::where(['id' => $order->customer_id])->first();

                $companyName = "District Printing";
                if($sendMailToCreator->role == 'Trader'){  
                    Config::set('mail',$this->traderMailConfig($sendMailToCreator));
                    $companyName = $sendMailToCreator->company_name;                  
                } 

                  //generate access code
                  $accessCode = md5(time());
                  //check to see if order already has an access code 

                  if($orderDetails){ 
                    if($orderDetails->access_code === null){  
                        $orderDetails->update(['access_code' => $accessCode]);  
                    }
                  } 
  
 

                try {            

                    if($this->isUber($order) == true){ 
                        if($order->customer_phone !== '3109169514'){   
                            Twilio::message($order->customer_phone, 
                            'Your order is ready! Want it delivered to '.$order->customer_address.'? Check your email or click the link below to instantly book an Uber:'. env('APP_URL').'/deliver_via_uber/'.$order->id.'?code='.$accessCode);
                        }
                    }else if(!$this->isEmptyValue($order->shopify_id)){
                        if($order->customer_phone !== '3109169514'){
                            Twilio::message($order->customer_phone, 'Your order  '.$order->name.' has been shipped. - '. $companyName);
                        }
                    }
                    else{ 
                        if($order->customer_phone !== '3109169514'){                                    
                            Twilio::message($order->customer_phone, 'Your order  '.$order->name.' is complete and is preparing for shipping. - '. $companyName);
                        }
                    }


                    $bcc=["notifications@districtprinting.tech"];  
                    if($this->isEmptyValue($order->shopify_id) || $this->isEmptyValue($order->etsy_id)){
                        Mail::to($sendMailToCreator->email)->bcc($bcc)->send(new OrderCompletedPlusTracking($userToSendTo,$order,$labelUrls, $sendMailToCreator ));
                        
                    }else{                    
                        Mail::to($order->customer_email)->cc($sendMailToCreator->email)->bcc($bcc)->send(new OrderCompletedPlusTracking($userToSendTo,$order,$labelUrls, $sendMailToCreator ));
                        
                    }
                }catch(\Exception $e){
                    $time = \Carbon\Carbon::now();
                    OrderEmailQueue::updateOrInsert([
                        'order_id' => $order->id,
                        'email_type' => $e,
                        'created_at' => $time,
                        'updated_at' => $time
                    ]);
                }
                $order = Order::select('orders.*','orders.name AS name',DB::Raw('(CASE 
                WHEN printers.title IS NULL THEN resources.name
                ELSE printers.title
            END) as printer_name'),'orders.id AS id','orders_meta.ss_date','orders_meta.ss_invoice','orders_meta.ss_metadata')->with(['order_arts', 'printer'])
            ->leftJoin('orders_meta', 'orders.id', '=', 'orders_meta.order_id')
            ->leftJoin('printers', 'orders.printer_id', '=', 'printers.id')
            ->leftJoin('resources', 'orders.resource_id', '=', 'resources.id')->where(['orders.id' => $orderID])->first();
        
            
                return response([
                    'code' => 200,
                    'success' => true,
                    'message' => 'Order updated.',
                    'data' => $order,
                    'labels' => [$labels,$labelUrls]
                   
                ]);
            }
        }


        $order->customer_id = $request->customer_id;
        // $order->created_by = auth()->user()->id;

        $order->name = $request->name;
        $order->type = $request->type;

        $order->boxes = $request->boxes;
        $order->weight = $request->weight;


        $order->type_notes = $request->type_notes;
        $order->multiple_pages = isset($request->multiple_pages) && ($request->multiple_pages == 'true' || $request->multiple_pages == '1') ? true: false;

        $order->match_proof_color = isset($request->match_proof_color) && ( $request->match_proof_color == 'true' ||  $request->match_proof_color == '1') ? true: false;

        $order->arrival_type = $request->arrival_type;
        $order->arrival_other = $request->arrival_other;
        $order->arrival_date = $request->arrival_date;
        $order->hard_due_date = isset($request->hard_due_date) && ($request->hard_due_date == 'true' || $request->hard_due_date == '1')  ? true: false;

        // $order->art_is_sized = isset($request->art_is_sized) && ($request->art_is_sized == 'true' || $request->art_is_sized = '1') ? true : false;

        if(isset($request->art_is_sized) && ($request->art_is_sized == 'false' || $request->art_is_sized == '0')) {
            $order->art_is_sized = false;
        } else if(isset($request->art_is_sized) && ($request->art_is_sized == 'true' || $request->art_is_sized == '1')) {
            $order->art_is_sized = true;
        }

        if(isset($request->film) && ($request->film == 'false' || $request->film == '0')) {
            $order->film = false;
        } else if(isset($request->film) && ($request->film == 'true' || $request->film == '1')) {
            $order->film = true;
        }


        // $order->film = isset($request->film) && ($request->film == 'true' || $request->film = '1') ? true : false;
        $order->art_notes = $request->art_notes;

        $order->price_1 = $request->price_1;
        $order->price_2 = $request->price_2;
        $order->price_3 = $request->price_3;
        $order->price_4 = $request->price_4;
        $order->price_5 = $request->price_5;
 
        $order->color_1 = $request->color_1; 
        $order->color_2 = $request->color_2;
        $order->color_3 = $request->color_3;
        $order->color_4 = $request->color_4;
        $order->color_5 = $request->color_5;
        $order->color_6 = $request->color_6;

        $order->color_1_pantone = $request->color_1_pantone;
        $order->color_2_pantone = $request->color_2_pantone;
        $order->color_3_pantone = $request->color_3_pantone;
        $order->color_4_pantone = $request->color_4_pantone;
        $order->color_5_pantone = $request->color_5_pantone;
        $order->color_6_pantone = $request->color_6_pantone;


        $order->color_notes = $request->color_notes;

        $order->payment_invoice_url = $request->payment_invoice_url;
        $order->payment_notes = $request->payment_notes;
        $order->payment_terms = isset($request->payment_terms) && ($request->payment_terms == 'true' || $request->payment_terms == '1')  ? true: false;
        $order->pay = isset($request->pay) && ($request->pay == 'true' || $request->pay == '1')  ? true: false;   
        

      /*   if($request->trader_printer_id){	 */
            $order->trader_printer_id = $request->trader_printer_id;	
        /* } */
        
        /* if($request->resource_id){	 */
            $order->resource_id = $request->resource_id;	
        /* } */
        
        /* if($request->resource_admin){	 */
            $order->resource_admin = $request->resource_admin;	
       /*  } */
 
       /*  if($request->printer_id){	 */
            $order->printer_id = $request->printer_id;	
       /*  } */

        $order->ship_type = $request->ship_type;
        $order->ship_notes = $request->ship_notes;
        $order->ship_terms = isset($request->ship_terms) && ($request->ship_terms == true || $request->ship_terms == '1')  ? true: false;


        $order->customer_name = $request->customer_name;
        $order->customer_attn = $request->customer_attn;
        $order->customer_track_url = $request->customer_track_url;
        $order->customer_notes = $request->customer_notes;
        $order->customer_address = $request->customer_address;
        $order->customer_address_2 = $request->customer_address_2;
        $order->customer_state = $request->customer_state;
        $order->customer_zipcode = $request->customer_zipcode;
        $order->customer_email = $request->customer_email;
        $order->customer_phone = $request->customer_phone;
        $order->shipping_instructions = $request->shipping_instructions;
        $order->shipping_amt = $request->shipping_amt;

        $order->tracking_number = $request->tracking_number;
        
         
        $order->manual_tracking_url = $request->manual_tracking_url;
         
        /* Code - Start */
        $orderMetaData = [];
        $tracking = [];
       
 
        foreach([1,2,3,4,5] as $num){
            
            if($this->isJson($request->post('product_'.$num.'_json'))){
                $orderMetaData['product_'. $num .'_json'] = $request->{'product_'.$num.'_json'};
            }
            if($this->isJson($request->post('ss_references_'.$num))){
                $orderMetaData['ss_references_'.$num] = $request->{'ss_references_'.$num};
            }

            if($request['receiving_tracking_'.$num]){
                $tracking[] = $request->{'receiving_tracking_'.$num};
               
            }else{
                $tracking[] = '';
            }
        }
        $purchasingData = ['data' => $tracking];
      
        
        $orderMetaData['purchasing_tracking'] = json_encode($purchasingData);

        if(count($orderMetaData) > 0){
            OrderMeta::updateOrInsert(['order_id' => $orderID],$orderMetaData);
        }

        /* Code - End */

        if($request->shipping_label_url) {
            $folder = $orderID.'/shipping_label';

            $extension = $request->shipping_label_url->getClientOriginalExtension();

            $originalName = $this->fileName($request->shipping_label_url);
            $originalName = preg_replace('/\W+/', '-', $originalName);
            $newName = $originalName."_".intval(microtime(true));
            $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->shipping_label_url, $newName.'.'.$extension, 'public');
            $order->shipping_label_url = env('AWS_URL').$uploadPath;

            $pastLabel = PastLabels::create([
                'order_id' => $orderID,
                'label_url' => $order->shipping_label_url
            ]);
        }

        if($request->packing_list_url) {
            $folder = $orderID.'/packing_list';
            $extension = $request->packing_list_url->getClientOriginalExtension();
            $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->packing_list_url, 'packing.'.$extension, 'public');
            $order->packing_list_url = env('AWS_URL').$uploadPath;

            $pastLabel = PastLabels::create([
                'order_id' => $orderID,
                'label_url' => $order->packing_list_url,
                'type' => 'packing'
            ]);
        }
        if($request->proof_url) {
            if (filter_var($request->proof_url, FILTER_VALIDATE_URL)) {
                $order->proof_url = $request->proof_url;
            } else {
                $folder = $orderID.'/proof';
                $originalName = $this->filename($request->proof_url);
                $originalName = preg_replace('/\W+/', '-', $originalName);
                $newName = $originalName."_".intval(microtime(true));
                $extension = $request->proof_url->getClientOriginalExtension();
                $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->proof_url, $newName.'.'.$extension, 'public');
                $order->proof_url = env('AWS_URL').$uploadPath;
                if( $extension === 'jpg' || $extension === 'jpeg' ||   $extension === 'png' || $extension === 'gif' ){

                    $thumb_tmp_path="../storage/tmp/". $newName . '.' . $extension;
                    $this->resize_crop_image(300,   $request->proof_url, $thumb_tmp_path);
                    $uploadThumbnailPath = \Storage::disk('s3')->putFileAs($folder .'/thumbnail', $thumb_tmp_path, $newName . '.' . $extension, 'public');
                    $order->proof_url = env('AWS_URL') . $uploadThumbnailPath; 
                    unlink($thumb_tmp_path);
                }
            }
        }

        if($request->film_file) {
            if (filter_var($request->film_file, FILTER_VALIDATE_URL)) {
                $order->film_file = $request->film_file;
            } else {
                $folder = $orderID.'/film_file';
                $originalName = $this->filename($request->film_file);
                $originalName = preg_replace('/\W+/', '-', $originalName);
                $newName = $originalName."_".intval(microtime(true));
                $extension = $request->film_file->getClientOriginalExtension();
                $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->film_file, $newName.'.'.$extension, 'public');
                $order->film_file = env('AWS_URL').$uploadPath;

                if( $extension === 'jpg' || $extension === 'jpeg' ||   $extension === 'png' || $extension === 'gif' ){
                    $thumb_tmp_path="../storage/tmp/". $newName . '.' . $extension;
                    $this->resize_crop_image(300,   $request->film_file, $thumb_tmp_path);
                    $uploadThumbnailPath = \Storage::disk('s3')->putFileAs($folder .'/thumbnail', $thumb_tmp_path, $newName . '.' . $extension, 'public');
                    $order->film_file = env('AWS_URL') . $uploadThumbnailPath; 
                    unlink($thumb_tmp_path);    
                }
            }
            $order->film = 1;
             
        }

        $order->setup_name = $request->setup_name;
        $order->setup_screen_1 = $request->setup_screen_1;
        $order->setup_screen_2 = $request->setup_screen_2;
        $order->setup_notes = $request->setup_notes;


        $order->proof_notes = $request->proof_notes;

        $order->position_front = $request->position_front;
        $order->position_back = $request->position_back;
        $order->position_right_left = $request->position_right_left;
        $order->position_additional = $request->position_additional;
        $order->position_notes = $request->position_notes;
        $order->customer_city = $request->customer_city;
        $order->extra_services = $request->extra_services;
        $order->extra_cost_each = $request->extra_cost_each;
        $order->full_color_count = $request->full_color_count;
        $order->placements = $request->placements;
        $order->extra_service_each_cost = isset($request->extra_service_each_cost) && $request->extra_service_each_cost == 'true'  ? true: false;
        $order->adjust_placement = isset($request->adjust_placement) && $request->adjust_placement != '' ? $request->adjust_placement: false;
        $order->adjust_placement_style = isset($request->adjust_placement_style) && ($request->adjust_placement_style == 'true' || $request->adjust_placement_style == '1') ? true: false;
        $order->match_proof_position = isset($request->match_proof_position) && ($request->match_proof_position == 'true' || $request->match_proof_position == '1') ? true: false;
        $order->multiple_size_art = isset($request->multiple_size_art) && ($request->multiple_size_art == 'true' || $request->multiple_size_art == '1') ? true: false;
        $order->artwork_front = $request->artwork_front;
        $order->artwork_back = $request->artwork_back;
        $order->artwork_right_left = $request->artwork_right_left;
        $order->artwork_additional = $request->artwork_additional;
        $order->artwork_sizing = isset($request->artwork_sizing) && $request->artwork_sizing != '' ? $request->artwork_sizing: false;
        
        $order->invoice_number = $request->invoice_number;

        $apparelCount = 0;
        $isPurchasedCount = 0; 
        $isVendorOrders = 0;
        for($i = 1; $i <= 5; $i++) {
            $order['product_user_type_'.$i] = $request['product_user_type_'.$i];
            $order['product_user_other_type_'.$i] = $request['product_user_other_type_'.$i];
            $order['per_piece_'.$i] = $request['per_piece_'.$i];
            $order['tax_'.$i] = isset($request['tax_'.$i]) && ($request['tax_'.$i] == 'true' || $request['tax_'.$i] == '1' ) ? true : false;
            $order['item_number_'.$i] = $request['item_number_'.$i];
            $order['apparel_type_'.$i] = $request['apparel_type_'.$i];
            $order['product_color_'.$i] = $request['product_color_'.$i];
            $order['brand_name_'.$i] = $request['brand_name_'.$i];
            $order['product_description_'.$i] = $request['product_description_'.$i];
            $order['product_apparel_source_'.$i] = $request['product_apparel_source_'.$i];
            $order['product_apparel_source_other_'.$i] = $request['product_apparel_source_other_'.$i];
            $order['location_'.$i] = $request['location_'.$i];
            $order['xs_'.$i] = $request['xs_'.$i];
            $order['s_'.$i] = $request['s_'.$i];
            $order['m_'.$i] = $request['m_'.$i];
            $order['l_'.$i] = $request['l_'.$i];
            $order['xl_'.$i] = $request['xl_'.$i];
            $order['xxl_'.$i] = $request['xxl_'.$i];
            $order['xxxl_'.$i] = $request['xxxl_'.$i];
            $order['other_size_1_'.$i] = $request['other_size_1_'.$i];
            $order['other_size_text_1_'.$i] = $request['other_size_text_1_'.$i];
            $order['pcs_1_'.$i] = $request['pcs_1_'.$i];
            $order['other_size_2_'.$i] = $request['other_size_2_'.$i];
            $order['other_size_text_2_'.$i] = $request['other_size_text_2_'.$i];
            $order['pcs_2_'.$i] = $request['pcs_2_'.$i];

            $order['other_size_3_'.$i] = $request['other_size_3_'.$i];
            $order['other_size_text_3_'.$i] = $request['other_size_text_3_'.$i];
            $order['pcs_3_'.$i] = $request['pcs_3_'.$i];
            $order['other_size_4_'.$i] = $request['other_size_4_'.$i];
            $order['other_size_text_4_'.$i] = $request['other_size_text_4_'.$i];
            $order['pcs_4_'.$i] = $request['pcs_4_'.$i];
            $order['price_'.$i] = $request['price_'.$i];
            $order['pickup_'.$i] = isset($request['pickup_'.$i]) && ($request['pickup_'.$i] == 'true' || $request['pickup_'.$i] == '1' ) ? true : false;
             
                if($order['product_apparel_source_'.$i] !== null
                || $order['xs_'.$i] !== null
                || $order['s_'.$i] !== null
                || $order['m_'.$i] !== null
                || $order['l_'.$i] !== null
                || $order['xl_'.$i] !== null
                || $order['xxl_'.$i] !== null
                || $order['xxxl_'.$i] !== null
                || $order['other_size_text_1_'.$i] !== null
                || $order['other_size_text_2_'.$i] !== null
                || $order['other_size_text_3_'.$i] !== null
                || $order['other_size_text_4_'.$i] !== null)
                { $apparelCount++; }

                if($order['is_ordered_'.$i] === 1 || $order['product_apparel_source_'.$i] === 'provided')
                { $isPurchasedCount++; }
            
                if(isset($order['product_apparel_source_'.$i]) && $order['product_apparel_source_'.$i] != 'provided' && $order['product_apparel_source_'.$i] != 'inventory' && $order['product_apparel_source_'.$i] != 'apparel_others')
                { $isVendorOrders++; }
          
        }
         
        $order->apparel_row_count = $apparelCount;
        $order->is_purchased_row_count = $isPurchasedCount;

        $time = \Carbon\Carbon::now();
        if($isVendorOrders > 0  && $order->pay == 'true'){
            $uniqueKey = $order->id .'-'.'VendorOrderPlacement';
           /*  OrderEmailQueue::updateOrInsert(['order_id' => $uniqueKey],[
                'order_id' => $order->id,
                'email_type' => 'VendorOrderPlacement',
                'created_at' => $time,
                'updated_at' => $time
            ]);  */

            $OrderEmailQueue = OrderEmailQueue::where('order_id',$order->id)->where('email_type','VendorOrderPlacement')->first();
            if($OrderEmailQueue){
                $OrderEmailQueue->email_type = 'VendorOrderPlacement';
                $OrderEmailQueue->updated_at = $time;
                $OrderEmailQueue->update();
            }  
            $vendorCount = true;
        }

        for($i = 1; $i <= 9; $i++) {
            $order['weight_'.$i] = $request['weight_'.$i];
        }

        if($request->artfile) {
            foreach($request->artfile as $file) {
                //var_dump($file);
                $folder = $orderID.'/art';
                $fileName = Misc::GenerateToken(10).'.'.$file->getClientOriginalExtension();
                $uploadPath = \Storage::disk('s3')->putFileAs($folder, $file, $fileName, 'public');
                $extension = $file->getClientOriginalExtension();
                $orderArt = new OrderArt;
                $orderArt->order_id = $orderID;
                $orderArt->filename = $fileName;
                $orderArt->aws_key = $uploadPath;
                $orderArt->file_url = env('AWS_URL').$uploadPath;


                if( $extension === 'jpg' || $extension === 'jpeg' ||   $extension === 'png' || $extension === 'gif' ){
                    $thumb_tmp_path="../storage/tmp/". $fileName;
                    $this->resize_crop_image(300,   $file, $thumb_tmp_path);
                    $uploadThumbnailPath = \Storage::disk('s3')->putFileAs($folder .'/thumbnail', $thumb_tmp_path, $fileName, 'public');
                    $orderArt->file_url  = env('AWS_URL') . $uploadThumbnailPath; 
                    unlink($thumb_tmp_path);
                }

                $orderArt->save();
            }
           
                $order->art_is_sized = 1;           

        }

        $order = $this->updateStatusToProduction($order);
        
        
        if($order->update()) {
            if($order->shipping_order_id && $order->order_key) {
                try {
                    $user = User::find($order->customer_id);
                    $shipStation = app(\LaravelShipStation\ShipStation::class);

                    $address = new \LaravelShipStation\Models\Address();

                    $address->name = $order->customer_name;
                    $address->city = $order->customer_city;
                    $address->company = $order->customer_attn; 
                    $address->street2 = $order->customer_address_2;
                    $address->street1 = $order->customer_address;
                    $address->state = $order->customer_state;
                    $address->postalCode = $order->customer_zipcode;
                    $address->country = "US";
                    $address->phone = $order->customer_phone;


                    $item = new \LaravelShipStation\Models\OrderItem();

                    $item->lineItemKey = $order->id;
                    $item->name = $order->name;
                    $item->quantity = 0; // TODO Total Quantity
                    $item->unitPrice  = '0.00';
                    // $item->warehouseLocation = 'Warehouse A';

                    $orderDe = new \LaravelShipStation\Models\Order();

                    $orderDe->orderKey = $order->id;
                    $orderDe->orderNumber = $order->id;
                    $orderDe->orderDate = $order->arrival_date;
                    $orderDe->orderStatus = 'awaiting_shipment';
                    if ($user !== null && $user->shipping_email) {
                        $orderDe->customerEmail = $user->shipping_email ? $user->shipping_email : $user->email;
                    }
                    $orderDe->amountPaid = '0.00';
                    $orderDe->taxAmount = '0.00';
                    $orderDe->shippingAmount = '0.00';
                    $orderDe->internalNotes = '...';
                    $orderDe->billTo = $address;
                    $orderDe->shipTo = $address;
                    $orderDe->items[] = $item;

                    $shipStationResponse =  $shipStation->orders->post($orderDe, 'createorder');
                } catch (\Exception $e) {
                    // return response([
                    //     'code' => 400,
                    //     'success' => false,
                    //     'message' => $e->getMessage()
                    // ]);
                }
            }

            $order = Order::select('orders.*','orders.name AS name','orders.created_at AS order_created_at',DB::Raw('(CASE 
                WHEN printers.title IS NULL THEN resources.name
                ELSE printers.title
            END) as printer_name'),DB::Raw('orders_meta.*'),'orders.id AS id')->with(['order_arts', 'printer'])
            ->leftJoin('printers', 'orders.printer_id', '=', 'printers.id')
            ->leftJoin('orders_meta','orders.id','=','orders_meta.order_id')
            ->leftJoin('resources', 'orders.resource_id', '=', 'resources.id')->where(['orders.id' => $orderID])->first();


            /* Code - Start */
            $dt = $order->toArray();

            $dt['ss_price'] = 0;

            foreach([1,2,3,4,5] as $num){

                $sizes = [
                    'xs',
                    's',
                    'm',
                    'l',
                    'xl',
                    'xxl',
                    'xxxl',
                    'other_size_text_1',
                    'other_size_text_2',
                    'other_size_text_3',
                    'other_size_text_4'
                ];

                //get all style color products associated with this



                if(isset($dt['product_'.$num.'_json']) && count($dt['product_'.$num.'_json']) > 0){
                    $colorStyles = StyleColorProduct::searchSpecific($dt['product_'.$num.'_json']['brand_name'],$dt['product_'.$num.'_json']['style_name'],$dt['product_'.$num.'_json']['color_name'])->get();

                    //match to corresponding quantities on the references side

                    foreach($sizes as $size){
                        //check if size is highlighted
                        if(isset($dt['ss_references_'.$num][$size]['highlighted']) && $dt['ss_references_'.$num][$size]['highlighted']){
                            //if it's highlighted, get the quantity

                            $quantity = intval($dt[$size.'_'.$num]);
                            $pricePerPiece = 0;
                            $sizeToMatchWith = $dt['ss_references_'.$num][$size]['raw'];

                            foreach($colorStyles as $product){
                                if($product->json_data['sizeName'] === $sizeToMatchWith){
                                    $pricePerPiece = floatval($product->json_data['casePrice']);
                                }
                            }

                            $dt['ss_price'] = $dt['ss_price'] + ($quantity*$pricePerPiece);

                        }
                        
                    }
                }

            }

            if(isset($dt['ss_date']) && strlen($dt['ss_date'].'') > 0 ){
              $dt['ss_date'] = @\Carbon\Carbon::parse($dt['ss_date'])->format('m/j/Y h:i A')  ;
            }else{
              $dt['ss_date'] = '<em>No invoice date.</em>';
            }

            if(!(isset($dt['ss_invoice']) && strlen($dt['ss_invoice'].'') > 0 )){
              $dt['ss_invoice'] = '<em>No SS invoice.</em>';
            }

            $order = $dt;
            /* Code - End */
            
            if($request->invoice_number !== null){
                $queryInvoiceIdData = DB::table('orders')->where('invoice_number', $request->invoice_number)->get(['id']);             
                $order['invoice_id'] = $queryInvoiceIdData;
            }else{
                $order['invoice_id'] = null;
            }
            
         

            if(strlen($order['invoice_meta']) > 10){
                $order['invoice_meta'] = json_decode($order['invoice_meta']);
                if($order['pay']."" !== '1'){
                    $order['status_display'] = 'Not Paid';
                }else{
                    $order['status_display'] = $order['invoice_meta']->invoice_number;
                }
            }else{
                $order['invoice_meta'] = (object) [];
                $order['status_display'] = 'No Invoice';
            }       

            $userName = DB::table('users')->where('id', $order['customer_id'])->first(['first_name','last_name']);
            $order['firstName'] = $userName->first_name;
            $order['lastName'] = $userName->last_name;


            
            try{ 

                if($request->tracking_number){

                    $trackingNumber = $request->tracking_number;

                    $guzzle = new Guzzle\Client([
                        'base_uri' => 'https://api.aftership.com/v4/',
                        'headers' => [ 
                            'as-api-key' => env('AFTERSHIP_DEFAULT'),
                            'Content-Type' => 'application/json'
                        ]
                    ]);
        

                    $tracking = $guzzle->get('trackings?keyword='.$trackingNumber); 
                        
                    $trackingDetailsResults = json_decode($tracking->getBody()->getContents());   
                    
                    if(!$trackingDetailsResults->data->trackings) {
                            
                        $guzzle->post('trackings', [
                            'body' => json_encode(['tracking' => [
                                'tracking_number' => $trackingNumber
                            ]])
                        ]);  

                    } 
                }
            }catch(Exception $e){

            }

            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Order updated.',
                'vendorCount' => $vendorCount,
                'data' => $order
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }

    }

    
    public function isUber($order){
        $result = false;
        if($order->ship_type == 'pickup-9am' || $order->ship_type == 'pickup-5pm' || $order->ship_type == 'uber' || $order->ship_type == 'hand_deliver'){
            $result =  true;
        }
        return $result;
    }

    public function DeleteFile(Request $request, $orderID, $fileID){
        $file = OrderArt::whereOrderId($orderID)->whereId($fileID)->first();
        if($file) {
            /* \Storage::disk('s3')->delete($file->aws_key); */
            if($file->delete()) {
                return response([
                    'code' => 204,
                    'success' => true,
                    'message' => 'File deleted successfully.'
                ]);
            } else {
                return response([
                    'code' => 500,
                    'success' => false,
                    'message' => 'Something went wrong, Try again later.'
                ]);
            }
        } else {
            return response([
                'code' => 404,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }
    }

    // public function testEmail(){

    //     $order = Order::find('200');

    //     Mail::to('yourcapslock@gmail.com')->cc([config('app.notification_email')])->send(new ResourceEmail($order));
    // }

    public function SendToOutsideResource(Request $request, $orderID) {

        $validator = Validator::make($request->all(), [
            'email' => 'required|email',
            'file' => 'required'
        ]);

        if ($validator->fails()) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => Misc::FirstValidationMessage($validator->errors()),
                'errors' => $validator->errors()
            ]);
        }

        $order = Order::find($orderID);
        $email = $request->email;
        $body = $request->body;
        $file = $request->file;

        if(count(AccessCode::where('order_id',$orderID)->get()) === 0){

            AccessCode::create([
                'order_id' => $orderID,
                'code' => md5(microtime(true))
            ]);

        }
        $bcc=["notifications@districtprinting.tech"];  

        Mail::to($email)->cc([config('app.notification_email')])->bcc($bcc)->send(new ResourceSend($email, $body, $file, $order));


        return response([
            'code' => 204,
            'success' => true,
            'message' => 'Resource successfully sent.'
        ]);
    }
    
    public function Addpartialtimestamp(Request $request) {


        $data = $request->all();
        $validator = Validator::make($data, [
        'ordernumber' => 'required',
        'printtype' => 'required',
        'copyselected' => 'required',
               
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors(), 'Validation Error']);
        }
        else{

         $ordernumber=$request->ordernumber;
         $printtype=$request->printtype;
         $copyselected=$request->copyselected;
         $timestamp=now();

         $order = Order::find($ordernumber);
         $order->apparel = 1;
         $activeNotification = ActivityNotif::where([['order_id','=' ,$order->id],['action', '=' ,'apparel_received']])->count();
                if($activeNotification === 0){
                    ActivityNotif::create([
                        'order_id' => $order->id,
                        'title' => 'Apparel Ordered for ' . $order->id,
                        'description' => $order->name,
                        'initiated_by' => $order->created_by,
                        'action' => 'apparel_received',
                        'type' => 'admin' 
                    ]);
                } 
         $order = $this->updateStatusToProduction($order); 

         $order->update();

         $select= DB::table('addpartialtimestamp')
         ->where('ordernumber', '=', $ordernumber)
         ->count();

         $addPartialTimeStampCount = DB::table('addpartialtimestamp')
         ->where('ordernumber', '=', $ordernumber)->where('printtype', '=', 'artwork')
         ->count();

         if($addPartialTimeStampCount == 0)
         {
            if($request->printtype == 'artwork'){
                ActivityNotif::create([
                    'order_id' => $order->id,
                    'title' => 'Printed Film for ' . $order->id,
                    'description' => $order->name,
                    'initiated_by' => $order->created_by,
                    'action' => 'printed_film',
                    'type' => 'admin' 
                ]);
            } 

        }

         if($select == 0)
         {
           /*  if($request->printtype == 'artwork'){
                ActivityNotif::create([
                    'order_id' => $order->id,
                    'title' => 'Printed Film for ' . $order->id,
                    'description' => $order->name,
                    'initiated_by' => $order->created_by,
                    'action' => 'printed_film',
                    'type' => 'admin' 
                ]);
            }  */

            $insertdata=array('ordernumber'=>$ordernumber,"printtype"=>$printtype,"copyselected"=>$copyselected,"timestamp"=>$timestamp);
            DB::table('addpartialtimestamp')->insert($insertdata);
            $insertdata1 = array('ordernumber'=>$ordernumber,"printtype"=>$printtype,"copyselected"=>$copyselected,"timestamp"=>$timestamp,"status"=>$order->status);
            return response([
               'code' => 200,
               'success' => true,
               'message' => 'Timestamp Inserted Successfully',
               'data' => $insertdata1
           ]);
           
         }
         else
         {
            $updatedata=array("printtype"=>$printtype,"copyselected"=>$copyselected,"timestamp"=>$timestamp);

            DB::table('addpartialtimestamp')->where('ordernumber', $ordernumber)->update($updatedata);
            $updatedata1=array("ordernumber"=>$ordernumber, "printtype"=>$printtype,"copyselected"=>$copyselected,"timestamp"=>$timestamp,"status"=>$order->status);

           return response([
               'code' => 200,
               'success' => true,
               'message' => 'Timestamp Updated Successfully',
               'data' => $updatedata1
           ]);

         }
  
        }


    }

    public function updateStatusToProduction($order){
        
        $trueCount = 0;
        if($order->status == 'Processing'){
            $trueCount = 0;
            if($order->apparel == 1){ $trueCount++; }
            if($order->film == 1){ $trueCount++; }
            if($order->art_is_sized == 1 || $order->art_is_sized == true){ $trueCount++; }
            if($order->pay == 1 || $order->pay == true || $order->payment_terms == 'true' || $order->payment_terms == '1'){ $trueCount++; }
            if($trueCount > 3){

                $order->status = 'Production';
                $arrivalDate = date("D,F jS", strtotime($order->arrival_date)); 

                ActivityNotif::create([
                    'order_id' => $order->id,
                    'title' => 'In Production  - ' . $order->id,
                    'description' => $order->name,
                    'initiated_by' => $order->created_by,
                    'action' => 'moved_to_production',
                    'type' => 'order_status' 
                ]);
                
                OrderDetails::updateOrInsert(
                    ['order_id' => $order->id], ['production_start_date' =>  date('Y-m-d', strtotime($order->arrival_date. '-1 day'))],                    
                );
                
                $time = \Carbon\Carbon::now();
                OrderEmailQueue::updateOrInsert([
                    'order_id' => $order->id,
                    'email_type' => 'OrderProduction',
                    'created_at' => $time,
                    'updated_at' => $time                    
                ]); 
                $customer = User::where('id',$order->customer_id)->first();
                $trader = User::where('id',$order->created_by)->first();
                $companyName = "District Printing";
                if($trader->role == 'Trader'){   
                    $companyName = $trader->company_name;                  
                } 
                if($order->customer_phone !== null) {
                    $arrivalDate = date('D, F jS', strtotime($order->arrival_date));
                    try {                            
                        if($customer->role  == 'Customer' && $customer->sms_required == 'true' && $customer->contact_number !== '3109169514' ){
                            Twilio::message($order->customer_phone, 'Your order, '.$order->name.'   is in production, with an estimated completion date of '.$arrivalDate.'. - '.$companyName);        
                        }
                    }catch(\Exception $e){
                        
                    } 
                } 

                if($order->resource_id !== null) {
                    try {
                        $resource_user = Resource::find($order->resource_id);    
                        $time = \Carbon\Carbon::now();                   
                        OrderEmailQueue::updateOrInsert([
                            'order_id' => $order->id,
                            'email_type' => 'ResourceEmail',
                            'created_at' => $time,
                            'updated_at' => $time
                        ]);
                        if($resource_user->sms !== null){

                            $accessCodeData = AccessCode::where(['order_id' => $order->id])->first();

                            Twilio::message($resource_user->sms, 
                                'Order #'. $order->id .''. "\n\n" .'Due '. date('n / j', strtotime($order->arrival_date) ) .'. Thank you.'. "\n" .'
                                '.env('FRONTEND_URL').'#/resource-view?order_id='.$order->id.'&page=resources&code='.$accessCodeData->code);
    
                        }
                    }catch(\Exception $e){
                        /* return "resource email : " . $e->getMessage(); */
                    }
                }
            }
        }
        return $order;
    }

    
    public function isJson($string) {
        json_decode($string);
        return json_last_error() === JSON_ERROR_NONE;
    }

     
    public function Viewpartialtimestamp(Request $request, $orderID) {
      
        $viewdata = Order::with('order_arts')
        ->leftJoin('printers', 'orders.printer_id', '=', 'printers.id')
        ->leftJoin('users', 'orders.customer_id', '=', 'users.id')
        ->leftJoin('resources', 'orders.resource_id', '=', 'resources.id')
        ->leftJoin(DB::Raw('users as creators'), 'orders.created_by', '=', 'creators.id')
        ->leftJoin('orders_meta', 'orders.id', '=', 'orders_meta.order_id')
        ->leftJoin('addpartialtimestamp', 'orders.id', '=', 'addpartialtimestamp.ordernumber')
        ->where('addpartialtimestamp.ordernumber', '=', $orderID)
        ->get();
    
            return response([
            'code' => 200,
            'success' => true,
            'message' => 'Timestamp Data View Successfully',
            'data' => $viewdata
        ]);

    }




   
    public function OrdersRecevingListV2(Request $request, $returnType = null,$id = null, $code = null) {

        DB::enableQueryLog();

        $query = Order::with('order_arts')
            ->leftJoin('printers', 'orders.printer_id', '=', 'printers.id')
            ->leftJoin('users', 'orders.customer_id', '=', 'users.id')
            ->leftJoin('resources', 'orders.resource_id', '=', 'resources.id')
            ->leftJoin(DB::Raw('users as creators'), 'orders.created_by', '=', 'creators.id')
            ->leftJoin('addpartialtimestamp', 'orders.id', '=', 'addpartialtimestamp.ordernumber')
            ->leftJoin('orders_meta','orders.id','=','orders_meta.order_id')
            ->leftJoin('order_deployment','orders.id','=','order_deployment.order_id')
            ->leftJoin('access_codes','orders.id','=','access_codes.order_id');
           

        if(isset($request->deleted_only)){
            switch($request->deleted_only){
                case "all":
                    $query = $query->withTrashed();
                break;
                case "only":
                    $query = $query->onlyTrashed();
                break;
            }
        }

        $type = $request->type;
        if(isset($request->title)) {
            $query = $query->where(function($q) use ($request, $type) {
                $q->orWhere('orders.name', 'LIKE', '%'.$request->title.'%');
                $q->orWhere('orders.customer_name', 'LIKE', '%'.$request->title.'%');
                $q->orWhere('orders.id', 'LIKE', '%'.$request->title.'%');
                $q->orWhere('users.first_name', 'LIKE', '%'.$request->title.'%');
                $q->orWhere('users.last_name', 'LIKE', '%'.$request->title.'%');
                $q->orWhere('users.email', 'LIKE', '%'.$request->title.'%');

                $q->orWhere('orders.invoice_number', 'LIKE', '%'.$request->title.'%');
                $q->orWhere('orders_meta.purchasing_tracking->data', 'LIKE', '%'.$request->title.'%');

                if(isset($type) && $type == "purchasing") {
                    $q->orWhere('orders.po_number', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.tracking_number', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_apparel_source_1', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_apparel_source_2', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_apparel_source_3', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_apparel_source_4', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_apparel_source_5', 'LIKE', '%'.$request->title.'%');

                    $q->orWhere('orders.item_number_1', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.item_number_2', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.item_number_3', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.item_number_4', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.item_number_5', 'LIKE', '%'.$request->title.'%');

                    $q->orWhere('orders.product_color_1', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_color_2', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_color_3', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_color_4', 'LIKE', '%'.$request->title.'%');
                    $q->orWhere('orders.product_color_5', 'LIKE', '%'.$request->title.'%');
                }
            });
        }

        if(isset($request->customer_id)) {
            $query = $query->where('orders.customer_id', $request->customer_id);
        }

        if(isset($request->apparel)) {
            $query = $query->where('orders.apparel', $request->apparel);
        }

        if(isset($request->sale_id)) {
            $query = $query->where('orders.created_by', $request->sale_id);
        }

        if(isset($request->print_date)) {
            $query = $query->where('orders.print_date', $request->print_date);
        }

        if(isset($request->film_status)) {
            if($request->film_status == 'not_added') {
                $query = $query->where('orders.film', false);
            } else if($request->film_status == 'film_added') {
                $query = $query->where('orders.film', true);
            } else if($request->film_status == 'all_orders') {
                $query = $query->where('orders.status', 'Processing');
            }
        }

        if(isset($request->printer_id)) {
            $query = $query->where('orders.printer_id', $request->printer_id);
        }

        if(isset($request->resource_id)) {
            $query = $query->where('orders.resource_id', $request->resource_id);
        }

     
        

        /* start */
        // Production, Completed, Processing

        if(isset($request->order_status)) {
            if($request->order_status == 'CustomerOpenOrders'){
                $query = $query->whereIn('orders.status', ['Processing','Production']);
            }else if($request->order_status == 'Draft'){
                $query = $query->where('orders.status', $request->order_status);
            }else{
                $query = $query->where('orders.status', $request->order_status);
            } 
        }else{                 
                $query = $query->where('orders.status', '!=', 'Draft'); 
        }

        

        
        if(isset($request->date_order)) {
            if($request->date_order == '14'){
                $request->startDate = \Carbon\Carbon::today()->startOfWeek()->addWeeks(1);
                $request->endDate =  \Carbon\Carbon::today()->endOfWeek()->addWeeks(1);
            }
            if($request->date_order =='7'){
                $request->startDate = \Carbon\Carbon::today()->startOfWeek();
                $request->endDate =  \Carbon\Carbon::today()->endOfWeek();
            }
            if($request->date_order =='2'){
                $request->startDate =  $request->endDate = \Carbon\Carbon::today()->addDays(1);                
            }
            if($request->date_order =='1'){
                $request->startDate =  $request->endDate = \Carbon\Carbon::today();                
            }
            if($request->date_order =='-1'){
                $request->startDate = \Carbon\Carbon::today()->subDays(10000);  
                $request->endDate =  \Carbon\Carbon::today()->subDays(1);          
            }
            if($request->date_order =='100000'){
                $request->startDate = \Carbon\Carbon::today()->subDays(10000);  
                $request->endDate =  \Carbon\Carbon::today()->addDays(10000);          
            }
            if($request->date_order =='100000' || $request->date_order =='Latest' || $request->date_order =='Soonest'){
                $request->startDate = \Carbon\Carbon::today()->subDays(10000);  
                $request->endDate =  \Carbon\Carbon::today()->addDays(10000);          
            }
            $query = $query->whereBetween('orders.arrival_date',[$request->startDate, $request->endDate]);
        }

        /* end */







        if(isset($request->order_type)) {
            /* $query = $query->where('orders.type', $request->order_type); */
            
            switch($request->order_type){
                case "screen_printing":
                    $query->whereIn('orders.type', ['screen_printing','screen_and_embroidery','screen_and_dtg','screen_and_dtf']);
                break; 
                case "direct_to_garment":
                    $query->whereIn('orders.type', ['direct_to_garment','screen_and_dtg']);
                break;
                case "embroidery":
                    $query->whereIn('orders.type', ['embroidery','screen_and_embroidery']);
                break; 
                case "dtf":
                    $query->whereIn('orders.type', ['dtf','screen_and_dtf']);
                break; 
                case "vynil":
                    $query->whereIn('orders.type', ['vynil']);
                break; 
                case "dyesub":
                    $query->whereIn('orders.type', ['dyesub']);
                break; 
                case "screen_and_embroidery":
                    $query->whereIn('orders.type', ['embroidery','screen_and_embroidery']);
                break; 
                case "screen_and_dtg":
                    $query->whereIn('orders.type', ['direct_to_garment','screen_and_dtg']);  
                break; 
                case "screen_and_dtf":
                    $query->whereIn('orders.type', ['dtf','screen_and_dtf']);
                break;  
                case "order_others":
                    $query->whereIn('orders.type', ['order_others']);
                break;  
                default:
                    $query->where('orders.type', $request->order_type);
            } 
        }

        /* if(isset($request->date_order)) {
            $query = $query->whereDate('orders.created_at','>=' ,\Carbon\Carbon::now()->subDays($request->date_order));
        } */

        if(isset($request->po_number)) {
            $query = $query->where('orders.po_number', 'LIKE', '%'.$request->po_number.'%');
        }

        if(isset($request->tracking_number)) {
            $query = $query->where('orders.tracking_number', 'LIKE', '%'.$request->tracking_number.'%');
        }

        switch(auth()->user()->role){
            case "Sales":
                $query = $query->where('orders.created_by', auth()->user()->id);
            break;
            case "Trader":
                $getUserId = User::whereStatus(1)->where('created_by',auth()->user()->id)->get('id');         
                $query = $query->where(function($sqlquery) use($getUserId){
                    $sqlquery->whereIn('orders.created_by',  $getUserId)->orWhere('orders.created_by', auth()->user()->id)
                    ->orWhere('orders.trader_printer_id', auth()->user()->id);
                });

            break;
            case "Admin":
                $trader = User::where('role', 'Trader')->whereStatus(1)->get('id');
                $traderUserId = User::whereStatus(1)->whereIn('created_by',$trader)->get('id'); 
 
                $query = $query->where(function($sqlquery) use($trader, $traderUserId){
                    $sqlquery->whereNull('orders.trader_printer_id')->whereNotIn('orders.created_by', $trader)->whereNotIn('orders.created_by', $traderUserId)
                    ->orWhere('orders.resource_admin', ['5']);
                });
            break;
            case "Etsy_Admin":
                $query = $query->where('orders.customer_id', '-1');
            break;
            case "Production":
                $query = $query->where('orders.status', 'Production');
            break;
            case "Customer":
                $query = $query
                         ->where(function($query){
                            $query->where('orders.customer_id',auth()->user()->id)
                                  ->orWhere('orders.created_by', auth()->user()->id);
                         });
                            
            break;
        }

        if (isset($request->pay)) {
            $query->where('pay', $request->pay);
        }

        if (isset($request->art_is_sized)) {
            $query->where('art_is_sized', $request->art_is_sized);
        }

        if(isset($request->in)){
            $ids = explode(",",$request->in);

            $query->whereIn('orders.id',$ids);

        }

        $query = $query->select(['orders.*', 'users.first_name as firstName', 'users.last_name as lastName',  'orders.name AS name',
            DB::Raw('(CASE 
                WHEN printers.title IS NULL THEN resources.name
                ELSE printers.title
            END) as printer_name')

            ,'resources.name as resource_name',  'addpartialtimestamp.ordernumber', 'addpartialtimestamp.printtype', 'addpartialtimestamp.copyselected',
                      
            'addpartialtimestamp.timestamp',
            'access_codes.code as access_code', 
            DB::Raw('creators.first_name as creator_name,creators.email as creator_email'),'orders_meta.invoice_url',
            'order_deployment.cart_id','order_deployment.printer_cart_id',
            'orders_meta.invoice_meta','orders_meta.ss_date','orders_meta.ss_invoice','orders_meta.purchasing_tracking',
            'orders_meta.purchasing_invoice','orders_meta.etsy_metadata','orders_meta.shopify_metadata','orders_meta.purchasing_ordering'])->orderBy('orders.arrival_date', 'ASC');

        if($returnType !== null){
            switch($returnType){
                case "raw":
                    return $query->get();
                break;
            }
        }
        $dataToReturn = $query->paginate(6)->toArray();

       
      
        //$dataToReturn['query'] = DB::getQueryLog();

        foreach($dataToReturn['data'] as $i => $data){

            if(strlen($dataToReturn['data'][$i]['invoice_meta']) > 10){
                $dataToReturn['data'][$i]['invoice_meta'] = json_decode($data['invoice_meta']);
                if($dataToReturn['data'][$i]['pay']."" !== '1'){
                    $dataToReturn['data'][$i]['status_display'] = 'Not Paid';
                }else{
                    $dataToReturn['data'][$i]['status_display'] = $dataToReturn['data'][$i]['invoice_meta']->invoice_number;
                }
            }else{
                $dataToReturn['data'][$i]['invoice_meta'] = (object) [];
                $dataToReturn['data'][$i]['status_display'] = 'No Invoice';
            }            

            if($dataToReturn['data'][$i]['invoice_number'] !== null)  {                 
                $queryInvoiceId = DB::table('orders')->where('invoice_number', $dataToReturn['data'][$i]['invoice_number'])->get(['id']);             
                $queryInvoiceIdData = $queryInvoiceId;
                $dataToReturn['data'][$i]['invoice_id'] = $queryInvoiceIdData;
            }else{
                $dataToReturn['data'][$i]['invoice_id'] = null;
            }
        }

        $dataToReturn['code'] = 200;
        $dataToReturn['success'] = true;
        $dataToReturn['message'] = 'Orders List.';

        $query = $query->select(['orders.*', 'printers.title as printer_name'])->orderBy('orders.arrival_date', 'ASC');

        $data = $query->get();

        $idsToFetch = [];

        foreach($data as $datum){
            $idsToFetch[count($idsToFetch)] = $datum->id;
        }



        if($request->get('with_labels') !== null){

            //then fetch all labels for the current list of orders

            $pastLabels = PastLabels::where(['type' => 'shipping'])->whereIn('order_id',$idsToFetch)->get();

            $dataToReturn['labels'] = new \stdClass;

            foreach($pastLabels as $label){
                if(!isset($dataToReturn['labels']->{'for_'.$label->order_id})){
                    $dataToReturn['labels']->{'for_'.$label->order_id} = [];
                }

                array_push($dataToReturn['labels']->{'for_'.$label->order_id},$label);
            }

            //check to see if there's any of the orders

            foreach($idsToFetch as $id){
                if(count($dataToReturn['labels']->{'for_'.$id}) === 0){
                    //get order data to check if there is an order

                    $orderInQ = Order::where($id)->first();
                    if(strlen($orderInQ->tracking_number."") > 5){
                        $pastLabel = PastLabels::create([
                            'order_id' => $orderInQ->id,
                            'label_url' => $orderInQ->shipping_label_url,
                            'type' => 'shipping',
                            'metadata' => json_encode([
                                'width' => '-', 
                                'height' => '-', 
                                'length' => '-', 
                                'weight' => '-',
                                'tracking_number' => $orderInQ->tracking_number
                            ])
                        ]);
                    }

                    array_push($dataToReturn['labels']->{'for_'.$id},[
                        'order_id' => $orderInQ->id,
                        'label_url' => $orderInQ->shipping_label_url,
                        'type' => 'shipping',
                        'metadata' => json_encode([
                            'width' => '-', 
                            'height' => '-', 
                            'length' => '-', 
                            'weight' => '-',
                            'tracking_number' => $orderInQ->tracking_number
                        ])
                    ]);

                }
            }

        }

        return response()->json($dataToReturn);
    }

    // Get Users List
    public function getStyleColorProduct(Request $request) {
         
        $searchWords = explode(' ', preg_replace('/\s+/', ' ', $request->get('query')));
        if(!isset($searchWords[1])){
            $searchWords[1] = "";
        }
        if(!isset($searchWords[2])){
            $searchWords[2] = "";
        } 
        $product = StyleColorProduct::select(DB::Raw('*'));
        $product->where('apparel_source', $request->get('type'));
        if($searchWords[1] != ''){ 
            $product->where(DB::raw("CONCAT(brand_name,' ',style_name, ' ', color_name)"), 'LIKE', '%' . $searchWords[0] . '% %' . $searchWords[1] . '% %' . $searchWords[2] . '%');
         
        }else{
            if($request->query !== null){
                $product = $product->where(function($query) use($request){
                    $query->where('brand_name','like','%'.$request->get('query').'%')
                    ->orWhere('style_name','like','%'.$request->get('query').'%')
                    ->orWhere('color_name','like','%'.$request->get('query').'%');
                });
            }
        }
       
        /* return $product->toSql(); */

        $dataToReturn = $product->limit(100)->paginate(99)->toArray();
        $dataToReturn['code'] = 200;
        $dataToReturn['success'] = true;
        $dataToReturn['message'] = 'Customer List.';

        return response()->json($dataToReturn);
    }

    /* Code - Start */
    
    public function updatePurchasingCron(Request $request){
        \Artisan::call('purchasing:update '.env('APP_KEY'));
    }

    public function getSCPExact(Request $request){

        $status = false;
        $data = [];
        $error = '';

        try {
            $data = StyleColorProduct::where([
                'brand_name' => $request->get('brand_name'),
                'style_name' => $request->get('style_name'),
                'color_name' => $request->get('color_name')
            ])->get();

            $status = true;
        }catch(\Exception $e){
            $error = $e->getException();
        }

        return compact('status', 'error', 'data');
    }

    /* Code - End */

    public function traderMailConfig($sendMailToCreator) {
      /*   $config = array(
            'driver'     => $sendMailToCreator->trader_transport,
            'host'       => $sendMailToCreator->trader_host,
            'port'       => $sendMailToCreator->trader_port,
            'from'       => array('address' => $sendMailToCreator->trader_email, 'name' => $sendMailToCreator->company_name),
            'encryption' => $sendMailToCreator->trader_encryp,
            'username'   => $sendMailToCreator->trader_username,
            'password'   => $sendMailToCreator->trader_password, 
        );   */
        $config = array(
            'driver'     => env('STORE_MAIL_MAILER'),
            'host'       => env('STORE_MAIL_HOST'),
            'port'       => env('STORE_MAIL_PORT'),
            'from'       => array('address' => 'orders@shopupdates.store', 'name' => $sendMailToCreator->company_name),
            'encryption' => env('STORE_MAIL_ENCRYPTION'),
            'username'   => env('STORE_MAIL_USERNAME'),
            'password'   => env('STORE_MAIL_PASSWORD'),
        );
        return $config;
    }

    public function isEmptyValue($value) {
        $result = false;
        if(isset($value) && !empty($value)){
            $result = true;
        }            
        return $result; 
    }

    public function assignStartDate($id,Request $request){
 
       /*  OrderDetails::updateOrInsert(
            ['order_id' => $id], ['production_start_date' => $request->start_date],   
        ); */

        $arrivalDate = \Carbon\Carbon::parse($request->start_date);
        $productionStartDate = $arrivalDate->copy()->subDays(1);

        // Check if production start date falls on a Saturday or Sunday
        if ($productionStartDate->isWeekend()) {
            // Adjust to the previous Friday
            $productionStartDate->previous(\Carbon\Carbon::FRIDAY); 
        }

        OrderDetails::updateOrInsert(
            ['order_id' => $id], ['production_start_date' =>  $productionStartDate->format('Y-m-d')],                    
        );



    }
 }