<?php

namespace App\Http\Controllers;
use App\Models\Order;
use App\Models\OrderDelivery;
use App\Models\User;
use App\Models\EmailTags;
use App\Models\UserEmailTags;
use App\Models\ActivityNotif;
use App\Mail\OrderHandDelivered;
use Mail;
use \Twilio;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;  
use Imagick;
use File;
use Illuminate\Support\Facades\Storage;
use Config;

class DeliveryController extends Controller
{  
 
    public function resize_crop_image($max_width, $source_file, $dst_dir ){
        $imgsize = getimagesize($source_file);
        $width = $imgsize[0];
        $height = $imgsize[1];
        $mime = $imgsize['mime'];
    
        switch($mime){
            case 'image/gif':
                $image_create = "imagecreatefromgif";
                $image = "imagegif";
                break;
    
            case 'image/png':
                $image_create = "imagecreatefrompng";
                $image = "imagepng";
                $quality = 7;
                break;
    
            case 'image/jpeg':
                $image_create = "imagecreatefromjpeg";
                $image = "imagejpeg";
                $quality = 80;
                break;
    
            default:
            $image_create = "imagecreatefromjpeg";
            $image = "imagejpeg";
            $quality = 80;
                break;
        }
        $new_height = abs($max_width * $height / $width);
        $dst_img = imagecreatetruecolor($max_width, $new_height);
        $src_img = @$image_create($source_file);
                
        imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $max_width, $new_height, $width, $height); 
 
        $image($dst_img, $dst_dir, $quality);
    
        if($dst_img)imagedestroy($dst_img);
        if($src_img)imagedestroy($src_img);
    }

    public function autorotate($image)
    {
        
       
        switch ($image->getImageOrientation()) {

            case Imagick::ORIENTATION_TOPLEFT: 

                break;
            case Imagick::ORIENTATION_TOPRIGHT:
                $image->flopImage();
                break;
            case Imagick::ORIENTATION_BOTTOMRIGHT:
                $image->rotateImage("#000", 180);
                break;
            case Imagick::ORIENTATION_BOTTOMLEFT:
                $image->flopImage();
                $image->rotateImage("#000", 180);
                break;
            case Imagick::ORIENTATION_LEFTTOP:
                $image->flopImage();
                $image->rotateImage("#000", -90);
                break;
            case Imagick::ORIENTATION_RIGHTTOP:
                $image->rotateImage("#000", 90);
                break;
            case Imagick::ORIENTATION_RIGHTBOTTOM:
                $image->flopImage();
                $image->rotateImage("#000", 90);
                break;
            case Imagick::ORIENTATION_LEFTBOTTOM:
                $image->rotateImage("#000", -90);
                break;
            default: // Invalid orientation
                break;
            }
            $image->setImageOrientation(Imagick::ORIENTATION_TOPLEFT);
    }

    public function filename($file){
        return pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
    }        
    public function nullFilter($text){
        return $text !== 'null' ? $text : null;
    }

    public function createDelivery(Request $request){

        $orderdelivery = new OrderDelivery;

        $orderdelivery->order_id  = $request->order_id;
        $orderdelivery->delivery_text  = $request->delivery_text;

        if($request->delivery_photo) {
            if (filter_var($request->delivery_photo, FILTER_VALIDATE_URL)) {
                $orderdelivery->delivery_photo_url = $request->delivery_photo;
            } else {
                $folder = $orderdelivery->order_id.'/delivery';
                $originalName = $this->filename($request->delivery_photo);
                $originalName = preg_replace('/\W+/', '-', $originalName);
                $newName = $originalName."_".intval(microtime(true));
                $extension = $request->delivery_photo->getClientOriginalExtension();
                $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->delivery_photo, $newName.'.'.$extension, 'public');
                $orderdelivery->delivery_photo_url = env('AWS_URL').$uploadPath; 
                
                try{ 
                    $APP_URL =  env('APP_URL');
                    $imageValue  = str_replace($APP_URL, '', $orderdelivery->delivery_photo_url);
                    $file_to_grab = public_path($imageValue);
                    $img = new Imagick($file_to_grab); 
                    $this->autorotate($img);          
                    $img->setImageAlphaChannel(Imagick::ALPHACHANNEL_REMOVE );
                    $img->resizeImage(300, 0, Imagick::FILTER_LANCZOS, 1);
                    $img->writeImage(public_path($imageValue));
        
                }catch(\Exception $e){
                    return $e;
                } 
            }

         
            
        }

        $orderdelivery->save();

        return response([
            'code' => 200,
            'success' => true,
            'data' => $orderdelivery
        ]);
    }

    public function updateDeliveryPhoto(Request $request){

        $orderdelivery = OrderDelivery::where(['order_id' => $request->order_id])->first(); 
        if(!$orderdelivery) {
            return response([
                'code' => 404,
                'success' => false,
                'message' => 'OrderDelivery not found.'
            ]);
        }
        $orderdelivery->delivery_text  = $request->delivery_text;

        if($request->delivery_photo) {
            if (filter_var($request->delivery_photo, FILTER_VALIDATE_URL)) {
                $orderdelivery->delivery_photo_url = $request->delivery_photo;
                
            } else {
                $folder = $orderdelivery->order_id.'/delivery';
                $originalName = $this->filename($request->delivery_photo);
                $originalName = preg_replace('/\W+/', '-', $originalName);
                $newName = $originalName."_".intval(microtime(true));
                $extension = $request->delivery_photo->getClientOriginalExtension();
                $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->delivery_photo, $newName.'.'.$extension, 'public');
                /* $uploadPathThumbnail = \Storage::disk('s3')->putFileAs($folder .'/thumbnail', $request->delivery_photo, $newName.'.'.$extension, 'public'); */
                $orderdelivery->delivery_photo_url = env('AWS_URL').$uploadPath;
               /*  $thumbnail = env('AWS_URL').$uploadPathThumbnail; */

                try{ 
                    $APP_URL =  env('APP_URL');
                    $imageValue  = str_replace($APP_URL, '', $orderdelivery->delivery_photo_url);
                    $file_to_grab = public_path($imageValue);
                    $img = new Imagick($file_to_grab); 
                    $this->autorotate($img);          
                    $img->setImageAlphaChannel(Imagick::ALPHACHANNEL_REMOVE );
                    $img->resizeImage(300, 0, Imagick::FILTER_LANCZOS, 1);
                    $img->writeImage(public_path($imageValue));
        
                }catch(\Exception $e){
                    return $e;
                } 
            }
        }
         

        $orderdelivery->save();
 
        return response([
            'code' => 200,
            'success' => true,
            'data' => $orderdelivery
        ]);
    }
 

    public function orderListWithDelivery(Request $request, $returnType = null,$id = null, $code = null) {
        

        $query = Order::leftJoin('users', 'orders.customer_id', '=', 'users.id') 
            ->leftJoin(DB::Raw('users as creators'), 'orders.created_by', '=', 'creators.id')
            ->leftJoin('order_delivery', 'orders.id', '=', 'order_delivery.order_id');

        if(isset($request->deleted_only)){
            switch($request->deleted_only){
                case "all":
                    $query = $query->withTrashed();
                break;
                case "only":
                default:
                    $query = $query->onlyTrashed();
                break;
            }
        }

        $query = $query->whereIn('orders.ship_type', ['courier','hand_deliver']);

        $query = $query
        ->where(function($query){
           $query->whereNotIn('orders.shipping_des', ['Delivered'])
                 ->orWhere('orders.shipping_des',  null);
        }); 
        $query = $query->whereIn('orders.status', ['Completed']);
       
        switch(auth()->user()->role){
            case "Sales":
                $query = $query->where('orders.created_by', auth()->user()->id);
            break;
            case "Trader":
                $query = $query->where('orders.created_by', auth()->user()->id);
            break;
            case "Etsy_Admin":
                $etsyUsers = User::where('role', 'Etsy_Admin')->get('id');
                $query = $query->whereIn('orders.created_by', $etsyUsers);
            break;
            case "Production":
                $query = $query->where('orders.status', 'Production');
            break;
            case "Customer":
                $query = $query
                         ->where(function($query){
                            $query->where('orders.customer_id',auth()->user()->id)
                                  ->orWhere('orders.created_by', auth()->user()->id);
                         });
                               
            break;
        }  
      
                          
        $query = $query->select(['orders.*', 'order_id', 'order_delivery.delivery_text',  'order_delivery.delivery_photo_url',  'users.first_name as firstName', 'users.last_name as lastName', DB::Raw('creators.first_name as creator_name,creators.email as creator_email, creators.role as creator_role')])->orderBy('orders.id', 'DESC');
       /*   return $query->toSql();  */   
         
        $dataToReturn = $query->paginate(6)->toArray(); 
        $dataToReturn['code'] = 200;
        $dataToReturn['success'] = true;
        $dataToReturn['message'] = 'Order List'; 
        $data = $query->get(); 

        return response()->json($dataToReturn);
    }

    public function traderMailConfig($sendMailToCreator) {
       /*  $config = array(
            'driver'     => $sendMailToCreator->trader_transport,
            'host'       => $sendMailToCreator->trader_host,
            'port'       => $sendMailToCreator->trader_port,
            'from'       => array('address' => $sendMailToCreator->trader_email, 'name' => $sendMailToCreator->company_name),
            'encryption' => $sendMailToCreator->trader_encryp,
            'username'   => $sendMailToCreator->trader_username,
            'password'   => $sendMailToCreator->trader_password, 
        );   */
        $config = array(
            'driver'     => env('STORE_MAIL_MAILER'),
            'host'       => env('STORE_MAIL_HOST'),
            'port'       => env('STORE_MAIL_PORT'),
            'from'       => array('address' => 'orders@shopupdates.store', 'name' => $sendMailToCreator->company_name),
            'encryption' => env('STORE_MAIL_ENCRYPTION'),
            'username'   => env('STORE_MAIL_USERNAME'),
            'password'   => env('STORE_MAIL_PASSWORD'),
        );
        return $config;
    }
    public function updateHandDeliveryMail(Request $request) {
         

        $orderdelivery = OrderDelivery::where(['order_id' => $request->order_id])->first(); 
        if(!$orderdelivery) {
            return response([
                'code' => 404,
                'success' => false,
                'message' => 'OrderDelivery not found.'
            ]);
        }

        $order = Order::where(['id' =>  $request->order_id])->first();

        ActivityNotif::create([
            'order_id' => $order->id,
            'title' => 'Order Delivered - ' . $order->id,
            'description' => $order->name,
            'initiated_by' => $order->created_by,
            'action' => 'order_delivered',
            'type' => 'admin' 
        ]);

        try{

            $sendMailToCreator = User::where(['id' => $order->created_by])->first();
            $userToSendTo = User::where(['id' => $order->customer_id])->first();

            $companyName = "District Printing";
            if($sendMailToCreator->role == 'Trader'){  
                Config::set('mail',$this->traderMailConfig($sendMailToCreator)); 
                $companyName = $sendMailToCreator->company_name;                
            } 
            $bcc=["notifications@districtprinting.tech"];  


            if($this->isEmptyValue($order->shopify_id) || $this->isEmptyValue($order->etsy_id)){
                Mail::to($sendMailToCreator->email)->bcc($bcc)->send(new OrderHandDelivered($userToSendTo, $order, $orderdelivery,$sendMailToCreator ));
            }else{
                Mail::to($order->customer_email)->cc($sendMailToCreator->email)->bcc($bcc)->send(new OrderHandDelivered($userToSendTo, $order, $orderdelivery,$sendMailToCreator ));

            }

            
        }catch(\Exception $e){
            return $e;
        }

        try {
            if($order->customer_phone !== '3109169514'){                       
                Twilio::message($order->customer_phone, 'Your order  has been Delivered. Please check link for updates - '. $companyName );
            }
        }catch(\Exception $e){
        }

        $order->shipping_des = 'Delivered';
        $order->status = 'Completed';
        $order->save();
     
        return response([
            'code' => 200,
            'success' => true,
            'data' => "Delivered"
        ]);
    }


 

    public function getTraderJson($companyName) { 
        $json = Storage::disk('s3')->get('/users/company_logo/'. $companyName . '.json');
        $json = json_decode($json, true);
        return $json;   
    }
    
    public function isEmptyValue($value) {
        $result = false;
        if(isset($value) && !empty($value)){
            $result = true;
        }            
        return $result; 
    }

    public function testmail(){
     
        $config = array(
            'driver'     => env('STORE_MAIL_MAILER'),
            'host'       => env('STORE_MAIL_HOST'),
            'port'       => env('STORE_MAIL_PORT'),
            'from'       => array('address' => 'orders@shopupdates.store', 'name' => 'District Printing'),
            'encryption' => env('STORE_MAIL_ENCRYPTION'),
            'username'   => env('STORE_MAIL_USERNAME'),
            'password'   => env('STORE_MAIL_PASSWORD'),
        );

        Config::set('mail', $config); 
        $companyName = 'District Printing';
        $orderdelivery = OrderDelivery::where(['order_id' => '100'])->first(); 
        $order = Order::where(['id' => '180'])->first();
        $sendMailToCreator = User::where(['id' => '1947'])->first();
        $userToSendTo = User::where(['id' => '1917'])->first();
        try{
        Mail::to('infomurugadas@gmail.com')->send(new OrderHandDelivered($userToSendTo, $order, $orderdelivery,$sendMailToCreator));
        }catch(\Exception $e){
            echo $e;
        }
    
    }

    
}
