<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Misc;
use Validator, Mail, Hash;
use App\Models\User;
use App\Models\Printer;
use App\Models\Resource;
use App\Models\UserOrderType;
use App\Models\PrinterTimeLog;
use App\Models\Event;;
use App\Mail\RecoverPassword;
use App\Models\ShopifyIntegration;
use Carbon\Carbon;
use Twilio;  

class AuthController extends Controller
{
    // POST::Login
    public function Login(Request $request) {
        $validator = Validator::make($request->all(), [
            'email' => 'email|required',
            'password' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => Misc::FirstValidationMessage($validator->errors()),
                'errors' => $validator->errors()
            ]);
        }
 

        $user = [
            'email' => $request->email,
            'password' => $request->password
        ];

        if (auth()->attempt($user)) {
            
            $user = auth()->user();
            if(!$user->status) {
                return response([
                    'code' => 403,
                    'success' => false,
                    'message' => 'Account not active. Please contact admin for activation.'
                ]);
            }

            $user['access_token'] = auth()->user()->createToken('authToken')->accessToken;
            $getProductionManager = User::where(['production_manager' => 'true'])->first(['id','role','first_name','production_manager','profile_image']);
            if($getProductionManager){
                $user['production_manager_id'] = "user" . $getProductionManager->id;    
                $user['production_manager_name'] = $getProductionManager->first_name;
                $user['production_manager_role'] = $getProductionManager->role;
                if($getProductionManager->profile_image){
                    $user['production_manager_image'] = $getProductionManager->profile_image;
                }else{
                    $user['production_manager_image'] =  "production_manager.jpg";
                } 
            }else{
                $getDefaultProductionManager = User::where(['email' => 'andrew@districtprinting.com'])->first(['id','role','first_name','production_manager','profile_image']);
                if($getDefaultProductionManager){
                    $user['production_manager_id'] = "user" . $getDefaultProductionManager->id;    
                    $user['production_manager_name'] = "Andrew S.";
                    $user['production_manager_role'] = "Admin";
                    if($getDefaultProductionManager->profile_image){
                        $user['production_manager_image'] = $getDefaultProductionManager->profile_image;
                    }else{
                        $user['production_manager_image'] =  "production_manager.jpg";
                    } 
                }else{
                    $user['production_manager_id'] = "user5";    
                    $user['production_manager_name'] = "Andrew S.";
                    $user['production_manager_role'] =  "Admin";
                    $user['production_manager_image'] =  "production_manager.jpg";
                }
            } 

            $user['order_type'] = UserOrderType::where('deleted_at', null)->get();

            if(auth()->user()->role == 'Admin'){
                $createdById = User::where('role', 'Admin')->get('id');
                $printerAndTrader[] = Resource::where('resources.is_deleted', 0)->get(['id','name','order_type','isPrimary']);
    
                $printerAndTrader[] = User::where('users.deleted_at', NULL)->where('users.role', 'Trader')->get(['id','company_name','trader_order_type','trader_order_type_primary']);

                $printerAndTrader[] = Printer::where('printers.is_deleted', 0)->whereIn('printer_created_by', $createdById)->get(['id','title']);
            }else if(auth()->user()->role == 'Trader'){
                $printerAndTrader[] = Printer::whereIsDeleted(0)->where('printer_created_by', auth()->user()->id)->get(['id','title']);
    
            }else{
                $printerAndTrader[] = "";
            }

            $user['tradelist'] = $printerAndTrader;
            return response([
                'code' => 200,
                'success' => true,
                'data' => $user,
                'accessToken' => $user['access_token']
            ]);
        }

        return response([
            'code' => 401,
            'success' => false,
            'message' => 'Invalid Credentials'
        ]);
    }

    public function googleLogin(Request $request) {
        $validator = Validator::make($request->all(), [
            'email' => 'email|required',
            'gmailId' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => Misc::FirstValidationMessage($validator->errors()),
                'errors' => $validator->errors()
            ]);
        }
 
        $user = User::where('email', $request->email)->first();
        /* $user = [
            'email' => $getUser->email,
            'password' => 'pass1234'
        ]; */
        auth()->login($user);
        $user['access_token'] = auth()->user()->createToken('authToken')->accessToken;
        return response([
            'code' => 200,
            'success' => true,
            'data' => $user
        ]);

/*         if (auth()->attempt($user)) {
            
            $user = auth()->user();
            if(!$user->status) {
                return response([
                    'code' => 403,
                    'success' => false,
                    'message' => 'Account not active. Please contact admin for activation.'
                ]);
            }

            $user['access_token'] = auth()->user()->createToken('authToken')->accessToken;
            return response([
                'code' => 200,
                'success' => true,
                'data' => $user
            ]);
        } */

        return response([
            'code' => 401,
            'success' => false,
            'message' => 'Invalid Credentials'
        ]);
    }
    //POST::Forgot 
    public function Forgot(Request $request) {
        $validator = Validator::make($request->all(), [
            'email' => 'email|required|exists:users,email',
            'redirect_url' => 'required|url'
        ]);
        
        if ($validator->fails()) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => Misc::FirstValidationMessage($validator->errors()),
                'errors' => $validator->errors()
            ]);
        }

        $user = User::whereEmail($request->email)->first();
        $user->forgot_token = Misc::GenerateToken();

        if($user->update()) {
            $redirectURL = $request->redirect_url.$user->forgot_token;
            Mail::to($user->email)->cc([config('app.notification_email')])->send(new RecoverPassword($user, $redirectURL));

            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Password reset email sent, Plase check your email to reset password.'
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }
    }

    // POST::Recover
    public function Recover(Request $request) {
        $validator = Validator::make($request->all(), [
            'token' => 'required',
            'password' => 'required|confirmed|min:8',
        ]);

         
        if ($validator->fails()) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => Misc::FirstValidationMessage($validator->errors()),
                'errors' => $validator->errors()
            ]);
        }

        $user = User::whereForgotToken($request->token)->first();
        if($user) {
            $user->password = bcrypt($request->password);
            $user->forgot_token = Misc::GenerateToken();
            if($user->update()) {
                return response([
                    'code' => 200,
                    'success' => true,
                    'message' => 'Password updated successfully.'
                ]);
            } else {
                return response([
                    'code' => 500,
                    'success' => false,
                    'message' => 'Something went wrong, Try again later.'
                ]);
            }

        } else {
            return response([
                'code' => 400,
                'success' => false,
                'message' => 'Password recovery link expired.'
            ]);
        }
    
    }

    // POST::User
    public function User(Request $request) {
        return response([
            'code' => 200,
            'success' => true, 
            'message' => 'User data.',
            'data' => $request->user()
        ]);
    }

    // POST::UpdatePassword

    public function UpdatePassword(Request $request) {
        $validator = Validator::make($request->all(), [
            'current_password' => 'required|min:8',
            'password' => 'required|confirmed|min:8',
        ]);

         
        if ($validator->fails()) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => Misc::FirstValidationMessage($validator->errors()),
                'errors' => $validator->errors()
            ]);
        }
    
        $user = $request->user();
        if (Hash::check($request->current_password, $user->password)) {
            
            $user->password = bcrypt($request->password);
            if($user->update()) {
                return response([
                    'code' => 200,
                    'success' => true,
                    'message' => 'Password updated successfully.'
                ]);
            } else {
                return response([
                    'code' => 500,
                    'success' => false,
                    'message' => 'Something went wrong, Try again later.'
                ]);
            }


        } else {
            return response([
                'code' => 400,
                'success' => false,
                'message' => 'Password mismatch. Please provide correct password.'
            ]);
        }


    }


    // POST::UpdateProfile
    public function UpdateProfile(Request $request) {
        $validator = Validator::make($request->all(), [
            'first_name' => 'required|max:50',
            'last_name' => 'required|max:50',
            'contact_number' => 'max:50',
            'city' => 'max:50',
            'state' => 'max:50',
            'zipcode' => 'max:50',
        ]);

         
        if ($validator->fails()) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => Misc::FirstValidationMessage($validator->errors()),
                'errors' => $validator->errors()
            ]);
        }

        $user = $request->user();
        $user->first_name = $request->first_name;
        $user->last_name = $request->last_name;

        if(isset($request->contact_number)) 
            $user->contact_number = $request->contact_number;

        if(isset($request->address))
            $user->address = $request->address;

        if(isset($request->city)) 
            $user->city = $request->city;

        if(isset($request->email)) 
            $user->email = $request->email;

        if(isset($request->state)) 
            $user->state = $request->state;

        if(isset($request->zipcode)) 
            $user->zipcode = $request->zipcode;

        if($user->update()) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Profile updated successfully.',
                'data' => $user
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }
    }

    public function UpdateShipping(Request $request) {
        $validator = Validator::make($request->all(), [
            'shipping_email' => 'max:100|email',
            'shipping_name' => 'max:50',
            'shipping_street_appartment' => 'max:50',
            'shipping_city' => 'max:50',
            'shipping_state' => 'max:50',
            'shipping_zipcode' => 'max:50',
        ]);

         
        if ($validator->fails()) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => Misc::FirstValidationMessage($validator->errors()),
                'errors' => $validator->errors()
            ]);
        }

        $user = $request->user();

        if(isset($request->shipping_email)) 
            $user->shipping_email = $request->shipping_email;
        
        if(isset($request->shipping_name)) 
            $user->shipping_name = $request->shipping_name;
        
        if(isset($request->shipping_address)) 
            $user->shipping_address = $request->shipping_address;

        if(isset($request->shipping_company)) 
            $user->shipping_company = $request->shipping_company;

        if(isset($request->shipping_street_appartment)) 
            $user->shipping_street_appartment = $request->shipping_street_appartment;

        if(isset($request->shipping_city))
            $user->shipping_city = $request->shipping_city;

        if(isset($request->shipping_state)) 
            $user->shipping_state = $request->shipping_state;

        if(isset($request->shipping_zipcode)) 
            $user->shipping_zipcode = $request->shipping_zipcode;

        if($user->update()) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Shipping info updated successfully.',
                'data' => $user
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }
    }   

    public function GetCustomerList(Request $request) {
 
        if(auth()->user()->role == 'Admin') {
            $users = User::whereIn('role', ['Customer','Etsy_Customer'])->whereStatus(1);
        }else if(auth()->user()->role == 'Etsy_Admin') {
            $users = User::whereRole('Etsy_Customer')->whereStatus(1);
        } else if(auth()->user()->role == 'Sales' || auth()->user()->role == 'Trader') {
            $users = User::whereRole('Customer')->whereCreatedBy(auth()->user()->id)->whereStatus(1);
        } else {
            $users = User::whereRole('Customer')->whereStatus(1);
        }

        if($request->query !== null){
            $users = $users->where(function($query) use($request){
                $query->orWhere('first_name','like','%'.$request->get('query').'%')
                ->orWhere('last_name','like','%'.$request->get('query').'%')
                ->orWhere('email','like','%'.$request->get('query').'%')
                ->orWhereRaw('CONCAT(first_name," ",last_name) like "%'.$request->get('query').'%"');
            });
        }
 
        $users = $users->limit(20)->get();
        
        return response([
            'code' => 200,
            'success' => true, 
            'message' => 'Customer List.',
            'data' => $users
        ]);
    }

    public function GetCustomerListByWhoOrdered(Request $request) {
      
 
 
    if(auth()->user()->role == 'Admin') {
        
        $getAdminId = User::whereStatus(1)->where('role','Admin')->pluck('id')->toArray();  

            $users = User::whereStatus(1)
            ->where(function ($query) use ($getAdminId) {
                $query->where('role', 'Admin')
                        ->orWhereIn('created_by', $getAdminId);
            })
            ->whereIn('role', ['Admin', 'Etsy_Admin', 'Sales', 'Customer', 'Trader', 'Shop_Owner'])
            ->withCount(['totalCount as totalOrders' => function ($query) {
                $query->whereIn('status', ['Processing', 'Production']);
            }])
            ->having('totalOrders', '>', 0); 

         
    }else if(auth()->user()->role == 'Trader'){

        $getUserId = User::whereStatus(1)->where('created_by',auth()->user()->id)->pluck('id'); 

        $getUserId[] = auth()->user()->id;
      
        $users = User::withCount(['totalCount as totalOrders' => function ($query) {
        
            $query->whereIn('status', ['Processing','Production']);
         
         }])->whereIn('id',$getUserId)->whereStatus(1)->having('totalOrders', '>', 0);
         
    }else{
        $users = User::withCount(['totalCount as totalOrders' => function ($query) {
        
            $query->whereIn('status', ['Processing','Production']);
         
         }])->whereCreatedBy(auth()->user()->id)->whereStatus(1)->having('totalOrders', '>', 0);  
    } 

       $users = $users->get();
       
        foreach($users as $i => $user){
            if($user->shopify_id != null || $user->etsy_id != null){
                $shopData = ShopifyIntegration::where(['user_id' => $user->id])->first();
                if($shopData){
                    $users[$i]->storeName = $shopData->name;
                } 
            }
        }
        return response([
            'code' => 200,
            'success' => true, 
            'message' => 'Admin And Sales List.',
            'data' => $users 
        ]);
    }

    public function GetSaleList(Request $request) {
        return response([
            'code' => 200,
            'success' => true, 
            'message' => 'Customer List.',
            'data' => User::whereRole('Sales')->whereStatus(1)->get()
        ]);
    }

    public function GetEventsList(Request $request) {
        return response([
            'code' => 200,
            'success' => true, 
            'message' => 'Events List.',
            'data' => Event::orderBy('id', 'desc')->get()
        ]);
    }

    public function CreateEvent(Request $request) {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'date' => 'required'
        ]);

         
        if ($validator->fails()) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => Misc::FirstValidationMessage($validator->errors()),
                'errors' => $validator->errors()
            ]);
        }

        $user = $request->user();
        $event = new Event;
        $event->user_id = $user->id;
        $event->title = $request->title;
        $event->date = $request->date;

        if($event->save()) {
            return response([
                'code' => 200,
                'success' => true, 
                'message' => 'Events List.',
                'data' => Event::orderBy('id', 'desc')->get()
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }
    }

    public function DeleteEvent(Request $request, $id) {
        $event = Event::find($id);
        if(!$event) {
            return response([
                'code' => 404,
                'success' => false,
                'message' => 'Event not found'
            ]);
        }

        if($event->delete()) {
            return response([
                'code' => 200,
                'success' => true, 
                'message' => 'Events Deleted.',
                'data' => Event::orderBy('id', 'desc')->get()
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }
    }


    public function faceIdLogin(Request $request) {
        $validator = Validator::make($request->all(), [
            'email' => 'email|required',
            'whoami' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => Misc::FirstValidationMessage($validator->errors()),
                'errors' => $validator->errors()
            ]);
        }
 
        $printer = Printer::where('email', $request->email)->where('whoami', $request->whoami)->first();      
        
        if($printer){
            $user = User::where('email', 'production@districtprinting.com')->first();
             
            PrinterTimeLog::create([
                'printer_id' => $printer->id,
                'date' => \Carbon\Carbon::now()->format('Y-m-d'),
                'start_time' => \Carbon\Carbon::now()->format('h:i:s'),
                'login_type' => 'login'
            ]); 

            $timeNow = \Carbon\Carbon::now()->format('M, d Y @ h:i A');

            if($printer->mobile){
                Twilio::message($printer->mobile, 'Clock in '.  $timeNow);   
            }
         
            auth()->login($user);
            $user['access_token'] = auth()->user()->createToken('authToken')->accessToken;
            $user['role'] = "Printer";
            $user['printer_id'] = $printer->id;
            $user['printer_name'] = $printer->title;
            $user['login_image'] = $printer->login_image;
            $getProductionManager = User::where(['production_manager' => 'true'])->first(['id','role','first_name','production_manager','profile_image']);
            if($getProductionManager){
                $user['production_manager_id'] = "user" . $getProductionManager->id;    
                $user['production_manager_name'] = $getProductionManager->first_name;
                $user['production_manager_role'] = $getProductionManager->role;
                if($getProductionManager->profile_image){
                    $user['production_manager_image'] = $getProductionManager->profile_image;
                }else{
                    $user['production_manager_image'] =  "production_manager.jpg";
                } 
            }else{
                $getDefaultProductionManager = User::where(['email' => 'andrew@districtprinting.com'])->first(['id','role','first_name','production_manager','profile_image']);
                if($getDefaultProductionManager){
                    $user['production_manager_id'] = "user" . $getDefaultProductionManager->id;    
                    $user['production_manager_name'] = "Andrew S.";
                    $user['production_manager_role'] = "Admin";
                    if($getDefaultProductionManager->profile_image){
                        $user['production_manager_image'] = $getDefaultProductionManager->profile_image;
                    }else{
                        $user['production_manager_image'] =  "production_manager.jpg";
                    } 
                }else{
                    $user['production_manager_id'] = "user5";    
                    $user['production_manager_name'] = "Andrew S.";
                    $user['production_manager_role'] =  "Admin";
                    $user['production_manager_image'] =  "production_manager.jpg";
                }
            } 
            return response([
                'code' => 200,
                'success' => true,
                'data' => $user
            ]);

              
        }else{
            return response([
                'code' => 401,
                'success' => false,
                'message' => 'Invalid Credentials'
            ]);
        }
        
        return response([
            'code' => 401,
            'success' => false,
            'message' => 'Invalid Credentials'
        ]);
    }


    public function ApiLogin(request $request) { 
        return response([
            'code' => 200,
            'success' => true,
            'data' => auth('api')->user(),
            'accessToken' => $request->accessToken
        ]); 
    }
}
