<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Monitoring;

class TcpCheck extends \Google\Model
{
  protected $pingConfigType = PingConfig::class;
  protected $pingConfigDataType = '';
  public $pingConfig;
  /**
   * @var int
   */
  public $port;

  /**
   * @param PingConfig
   */
  public function setPingConfig(PingConfig $pingConfig)
  {
    $this->pingConfig = $pingConfig;
  }
  /**
   * @return PingConfig
   */
  public function getPingConfig()
  {
    return $this->pingConfig;
  }
  /**
   * @param int
   */
  public function setPort($port)
  {
    $this->port = $port;
  }
  /**
   * @return int
   */
  public function getPort()
  {
    return $this->port;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(TcpCheck::class, 'Google_Service_Monitoring_TcpCheck');
